<?php
$this->load->view('admin/comman/header');
?>
<div class="clearfix"></div>

<div class="content-wrapper">
    <div class="container-fluid">
        <!-- Breadcrumb-->
        <div class="row pt-2 pb-2">
            <div class="col-sm-9">
                <h4 class="page-title">Book Edit</h4>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo base_url() ?>admin/dashboard">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="<?php echo base_url() ?>admin/book">Books</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Edit</li>
                </ol>
            </div>
        </div>
        <!-- End Breadcrumb-->
        <?php $vid = $booklist;?>
        <div class="row">
            <div class="col-lg-12 mx-auto">
                <div class="card">
                    <div class="card-body">
                        <form id="edit_video_form" enctype="multipart/form-data">
                            <input type="hidden" name="id" value="<?PHP echo $vid->id; ?>">
                            <div class="row col-lg-12">
                                <div class="form-group col-lg-6">
                                    <label for="input-1">Book Name</label>
                                    <input type="text" required value="<?php echo $vid->title; ?>" class="form-control"
                                        name="title" id="title" placeholder="Enter Book Name">
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="input-2">Book Category</label>
                                    <select name="category_id" id="category_id" required class="form-control">
                                        <option value="">Select Category</option>
                                        <?php foreach ($categorylist as $cat) {?>
                                        <option value="<?php echo $cat->id; ?>"
                                            <?php if ($cat->id == $vid->category_id) {echo 'selected="selected"';}?>>
                                            <?php echo $cat->name ?></option>
                                        <?php }?>
                                    </select>
                                </div>
                            </div>


                            <div class="row col-lg-12">
                                <div class="form-group col-lg-6">
                                    <label for="input-3">Book Cost</label>
                                    <select name="is_paid" onchange="type_paid()" class="form-control" id="is_paid">
                                        <option value="0" <?php if ($vid->is_paid == "0") {
    echo 'selected';
}
?>>Free</option>
                                        <option value="1" <?php if ($vid->is_paid == "1") {
    echo 'selected';
}
?>>Paid</option>
                                    </select>
                                </div>
                                <div class="form-group col-lg-6" id="business" style="display:none">
                                    <div>
                                        <label for="input-1">Book price</label>
                                        <input type="text" required value="<?php echo $vid->price; ?>"
                                            class="form-control" name="price" id="price" placeholder="Enter Book Price">
                                    </div>
                                </div>
                            </div>
                            <div class="row col-lg-12">
                                <div class="form-group col-lg-12">
                                    <?php if ($_SESSION['role_id'] == 1) {?>
                                    <label for="input-2">Book Author</label>
                                    <!-- DropDown -->
                                    <select name="author_id" required class="form-control">
                                        <option value="">Select Author</option>
                                        <?php $i = 1;foreach ($authorlist as $auth) {?>
                                        <option value="<?php echo $auth->id; ?>"
                                            <?php if ($auth->id == $vid->author_id) {echo 'selected="selected"';}?>>
                                            <?php echo $auth->name ?></option>
                                        <?php $i++;}?>
                                    </select>
                                    <?php } else {?>
                                    <input type="hidden" name="author_id" value="<?php echo $_SESSION['id']; ?>">
                                    <?php }?>
                                </div>
                            </div>
                            <div class="row col-lg-12">
                                <div class="form-group col-lg-12">
                                    <label for="input-1">Book Description</label>
                                    <textarea class="form-control summernote" name="description"
                                        id="description"><?php echo $vid->description; ?></textarea>
                                </div>
                            </div>

                            <div class="row col-lg-12">
                                <div class="form-group col-lg-6">
                                    <label for="input-1"> Upload Sample Book</label>
                                    <div class="form-group">
                                        <input type="file" required class="" name="sample_url" id="sample_url">
                                        <a class="btn btn-outline-github"
                                            href="<?php echo base_url() . 'assets/images/book/' . $vid->sample_url; ?>"
                                            target="_blank">click to open file</a>
                                    </div>
                                    <input type="hidden" name="inputsamplebook" value="<?PHP echo $vid->sample_url; ?>">
                                    
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="input-1"> Book Cover Poster</label>
                                    <input type="file" required class="form-control" name="image" id="image"
                                        onchange="readURL(this,'showImage')">
                                    <input type="hidden" name="inputbookcover" value="<?PHP echo $vid->image; ?>">
                                    <p class="noteMsg">Note: Image Size must be less than 2MB.Image Height and Width
                                        less than 1000px.</p>
                                    <img id="showImage"
                                        src="<?php echo base_url() . 'assets/images/book/' . $vid->image; ?>"
                                        height="100" width="100" />
                                </div>
                            </div>

                            <div class="row col-lg-12">
                                <div class="form-group col-lg-6">
                                    <label for="input-1">Upload Full Book</label>
                                    <div id="filelist">Your browser doesn't have Flashs, Silverlight or HTML5
                                        support.
                                    </div>
                                    <div id="container">
                                        <div class="form-group">
                                            <input type="file" id="uploadFile" name="uploadFile">
                                        </div>
                                        <input type="hidden" name="mp3_file_name" id="mp3_file_name" value=""
                                            class="form-control">
                                        <input type="hidden" name="mp3_file_name_edit" id="mp3_file_name_edit"
                                            value="<?php echo $vid->url; ?>" class="form-control">
                                        <div class="form-group">
                                            <a id="upload" href="javascript:" class="btn btn-danger">Upload
                                                files</a>

                                            <?php if ($vid->url) {?>
                                            <a class="btn btn-outline-github"
                                                href="<?php echo base_url() . 'assets/images/book/' . $vid->url; ?>"
                                                target="_blank">click to open file</a>
                                            <?php }?>

                                        </div>
                                    </div>
                                    <input type="hidden" id="file_ext" name="file_ext"
                                        value="<?=substr(md5(rand(10, 100)), 0, 10)?>">
                                    <div id="console"></div>
                                </div>

                            </div>
                            <div class="row col-lg-12">
                                <div class="form-group col-lg-12">
                                    <button type="button" onclick="update_book()"
                                        class="btn btn-primary shadow-primary px-5"> Update</button>
                                    <a href="<?php echo base_url(); ?>admin/book"
                                        class="border-primary btn btn-default px-5 ">Cancel
                                    </a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $this->load->view('admin/comman/footerpage');?>
<script type="text/javascript">
$(document).ready(function() {
    type_paid();
})

function type_paid() {
    var type = $('#is_paid').val();
    if (type === '1') {
        $("#business").show();
    } else {
        $("#business").hide();
    }
};

function update_book() {
    $("#dvloader").show();
    var formData = new FormData($("#edit_video_form")[0]);

    var textareaValue = $('#description').code();
    formData.append("description", textareaValue);

    $.ajax({
        type: 'POST',
        url: '<?php echo base_url(); ?>admin/book/update',
        data: formData,
        cache: false,
        contentType: false,
        processData: false,
        dataType: "json",
        success: function(resp) {
            if (resp.status == '200') {
                $("#dvloader").hide();
                document.getElementById("edit_video_form").reset();
                toastr.success(resp.message, 'success');
                setTimeout(function() {
                    window.location.replace('<?php echo base_url(); ?>admin/book');
                }, 500);
            } else {
                $("#dvloader").hide();
                var obj = resp.message;
                if (typeof obj === 'string') {
                    toastr.error(obj);
                } else {
                    $.each(obj, function(i, e) {
                        toastr.error(e);
                    });
                }
            }
        }
    });
}
</script>