<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

/**
 * Class : Login_model (Login Model)
 * Login model class to get to authenticate user credentials
 * @author : Kishor Mali
 * @version : 1.1
 * @since : 15 November 2016
 */
class API_CRUD_model extends CI_Model
{

    public function __construct()
    {
        $this->load->database();
    }

    public function p($data)
    {
        echo '<pre>';
        print_r($data);exit;
    }

    public function avg_book_rating($book_id)
    {
        $this->db->select('AVG(rating) as average');
        $this->db->where('book_id', $book_id);
        return $result = $this->db->get('rating')->row();
    }

    public function avg_magazine_rating($book_id)
    {
        $this->db->select('AVG(rating) as average');
        $this->db->where('magazine_id', $book_id);
        return $result = $this->db->get('rating_magazine')->row();
    }

    public function view_website($where)
    {
        $this->db->set('views', 'views+1', false);
        $this->db->where($where);
        $this->db->update('website_analysis');
    }

    public function get_sum($id,$type='book')
    {
        $this->db->select("sum(amount) as total_amount");
        $this->db->from("transaction");
        $this->db->where('user_id', $id);
        if($type == 'book')
        {
            $this->db->where('magazine_id', '0');
        }else
        {
            $this->db->where('book_id', '0');
        }
        $q = $this->db->get();
        return $q->row();
    }

    public function get_book_id($id)
    {
        $this->db->select("*");
        $this->db->from("book");
        $this->db->where_in('id', $id);
        $q = $this->db->get();
        return $q->result();
    }

    // Get count

    public function getsumCount($field_name,$where, $tablename)
    {
        $this->db->select($field_name);
        $this->db->from($tablename);
        if (!empty($where)) {
            $this->db->where($where);
        }
        $query = $this->db->get();
        $row = $query->row();
        return $row;
    }

    public function getCount($where, $tablename)
    {
        $this->db->select('*');
        $this->db->from($tablename);
        if (!empty($where)) {
            $this->db->where($where);
        }
        $query = $this->db->get();
        $row = $query->result();
        return $row;
    }

    public function updateByIdWithcount($id, $field_name, $value, $tablename)
    {
        $this->db->set($field_name, $field_name . '+' . $value, false);
        $this->db->where('id', $id);
        $this->db->update($tablename);
        return $id;
    }

    public function subtractionByIdWithcount($id, $field_name, $value, $tablename)
    {
        $this->db->set($field_name, $field_name . '-' . $value, false);
        $this->db->where('id', $id);
        $this->db->update($tablename);
        return $id;
    }

    public function get($where, $tablename, $field_name = null, $order_by = 'desc')
    {
        $this->db->select('*');
        $this->db->from($tablename);
        if (!empty($where)) {
            $this->db->where($where);
        }
        if ($field_name) {
            $this->db->order_by($field_name, $order_by);
        }
        $query = $this->db->get();
        $row = $query->result();
        return $row;
    }

    public function getById($where, $tablename)
    {
        $this->db->select('*');
        $this->db->from($tablename);
        if (!empty($where)) {
            $this->db->where($where);
        }
        $query = $this->db->get();
        $row = $query->row();
        return $row;
    }


    public function get_join($data)
    {
        $where = isset($data['where']) ? $data['where'] : '';
        $whereIn = isset($data['where_in']) ? $data['where_in'] : '';
        $group_by = isset($data['group_by']) ? $data['group_by'] : '';
        $order_by_field = isset($data['order_by_field']) ? $data['order_by_field'] : $data['table'].'.id';
        $order_by = isset($data['order_by']) ? $data['order_by'] : 'DESC';
        $page_no = isset($data['page_no']) ? $data['page_no'] : '1';
        $page_limit = isset($data['page_limit']) ? $data['page_limit'] : $this->config->item('page_limit');

        $this->db->select($data['field']);
        $this->db->from($data['table']);

        if(isset($data['joins'])){
            foreach ($data['joins'] as $joins) {
                $this->db->join($joins['table'], $joins['join']);
            }
        }

        if($where){
          foreach ($where as $value) {
              $this->db->where($value);
          }
        }

        if($whereIn){

          foreach ($whereIn as $value) {

              $this->db->where("FIND_IN_SET(".$value['value'].",`".$value['key']."`) <>",'0');
          }
        }

        if ($order_by_field) {
          $this->db->order_by($order_by_field, $order_by);
        }

        if ($group_by) {
          $this->db->group_by($group_by);
        }

        $num_rows = $this->db->count_all_results('', false);

        if ($page_no) {
          $offset = ($page_limit * $page_no) - $page_limit;
          $this->db->limit($page_limit, $offset);
        }

        $query = $this->db->get();
        
        $row['data'] = $query->result();
        $row['total_records'] = $num_rows;
        $row['total_page'] = ceil($num_rows/$page_limit);

        return $row;
    }
    
    public function getLastRecord($where, $tablename)
    {
        $this->db->select('*');
        $this->db->from($tablename);
        $this->db->where($where);
        $this->db->limit(1);
        $this->db->order_by('id', "desc");
        $query = $this->db->get();
        $row = $query->row();
        return $row;
    }

    public function insert($data, $tablename)
    {
        $insert = [];
        foreach ($data as $key => $value) {
            $insert[$key] = $this->db->escape_str($value);
        }

        $query = $this->db->insert($tablename, $data);
        return $this->db->insert_id();
    }

    public function update($id, $field_name, $data, $tablename)
    {

        $insert = [];
        foreach ($data as $key => $value) {
            $insert[$key] = $this->db->escape_str($value);
        }

        $this->db->where($field_name, $id);
        $this->db->update($tablename, $insert);
        return $id;
    }

    public function delete($where, $tablename)
    {
        $this->db->where($where);
        $this->db->delete($tablename);
        return true;
    }

    public function delete_all($id, $field_name, $tablename)
    {
        $this->db->where($field_name, $id);
        $this->db->delete($tablename);
        return true;
    }

    public function imageupload($imageName, $imgname, $uploadpath, $widths = 1000, $heights = 1000)
    {
        if (!file_exists($uploadpath)) {
            mkdir($uploadpath, 0777, true);
        }

        if (empty($imageName['name'])) {
            $res = array('status' => '400', 'message' => 'Please Upload Image first.');
            echo json_encode($res);exit;
        }
        if (!empty($imageName['name']) && ($imageName['error'] == 1 || $imageName['size'] > 2215000)) {
            $res = array('status' => '202', 'message' => 'Max 2MB file is allowed for image.');
            echo json_encode($res);exit;
        } else {
            list($width, $height) = getimagesize($imageName['tmp_name']);
            if ($width > $widths || $height > $heights) {
                $res = array('status' => '201', 'message' => 'Image height and width must be less than height .' . $heights . ' and width ' . $widths);
                echo json_encode($res);exit;
            } else {

                $catImg = $imageName['name'];
                $ext = pathinfo($catImg);
                $catImages = str_replace(array(' ', '.', '-', '`'), '_', $ext['filename']);
                $category_image = time() . '.' . $ext['extension'];
                $config = array(
                    'allowed_types' => 'jpg|jpeg|gif|png',
                    'upload_path' => $uploadpath,
                    'file_name' => $category_image,
                );
                $this->load->library('upload');
                $this->upload->initialize($config);
                $this->upload->do_upload($imgname);
                return $category_image;
            }

        }
    }
}