<?php
defined('BASEPATH') or exit('No direct script access allowed');

class User extends CI_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->library('email');
		$this->load->model('API_CRUD_model');
	}

	public function Login()
	{
		$this->form_validation->set_rules('email', 'email', 'required');
		if ($this->form_validation->run() == false) {
			$errors = $this->form_validation->error_array();
			sort($errors);
			$array = array('status' => 400, 'message' => $errors[0]);
			echo json_encode($array);
			exit;
		}

		$email = $_REQUEST['email'];
		$password = isset($_REQUEST['password']) ? $_REQUEST['password'] : '';
		$type = isset($_REQUEST['type']) ? $_REQUEST['type'] : '1';

		if ($type == '2' or $type == '4') {
			$where = 'email="' . $email . '"';
			$user_data = $this->API_CRUD_model->getById($where, 'user');

			if ($user_data) {
				$user_data->image =  get_image_path($user_data->image, 'user');
				if ($user_data->id) {
					$response = array('status' => 200, 'message' => $this->lang->line('LOGIN_SUCCESSFULLY'), 'result' => array($user_data));
				} else {
					$r = array();
					$response = array('status' => 400, 'message' => $this->lang->line('USER_NAME_AND_PASSWORD_WRONG'));
				}
			} else {
				// Facebook User Register 
				$email = $_REQUEST['email'];
				$fullname = isset($_REQUEST['fullname']) ? $_REQUEST['fullname'] : '';
				$mobile = isset($_REQUEST['mobile'])  ? $_REQUEST['mobile'] : '';

				$image = '';
				if (isset($_FILES['image']['name'])) {
					$image = $this->API_CRUD_model->imageupload($_FILES['image'], 'image', FCPATH . 'assets/images/user');
				}

				$data = array(
					'fullname' => $fullname,
					'email' => $_REQUEST['email'],
					'type' => $type,
					'mobile' => $mobile,
					'image' => $image
				);

				$user_id = $this->API_CRUD_model->insert($data, 'user');
				unset($data['password']);
				$data['id'] = $user_id;
				$data['image'] = get_image_path($data['image'], 'user');
				$response = array('status' => 200, 'message' => $this->lang->line('USER_LOGIN_SUCCESSFULY'), 'result' => array($data));
				echo json_encode($response);
				exit;
			}
		} else {
			$where = 'password="' . md5($password) . '" and email="' . $email . '"';
			$user_data = $this->API_CRUD_model->getById($where, 'user');

			if (isset($user_data->id)) {
				$user_data->image =  get_image_path($user_data->image, 'user');
				$response = array('status' => 200, 'message' => $this->lang->line('USER_LOGIN_SUCCESSFULY'), 'result' => array($user_data));
			} else {
				$r = array();
				$response = array('status' => 400, 'message' => $this->lang->line('USER_AND_PASSWORD_IS_WRONG'));
			}
		}
		echo json_encode($response);
		exit;
	}

	public function registration()
	{

		$this->form_validation->set_rules('email', 'email', 'required');
		$this->form_validation->set_rules('fullname', 'fullname', 'required');
		$this->form_validation->set_rules('password', 'password', 'required');
		$this->form_validation->set_rules('mobile', 'mobile', 'required');
		if ($this->form_validation->run() == false) {
			$errors = $this->form_validation->error_array();
			sort($errors);
			$array = array('status' => 400, 'message' => $errors[0]);
			echo json_encode($array);
			exit;
		}


		$fullname = $_REQUEST['fullname'];
		$email = $_REQUEST['email'];
		$password = $_REQUEST['password'];
		$mobile = $_REQUEST['mobile'];

		$where = 'email="' . $email . '"';
		$emailresult = $this->API_CRUD_model->getById($where, 'user');

		$where_mobile = 'mobile="' . $mobile . '"';
		$mobileresult = $this->API_CRUD_model->getById($where_mobile, 'user');


		if (isset($emailresult->id)) {
			$response = array('status' => 400, 'message' => $this->lang->line('EMAIL_ALREADY_EXISTS'));
			echo json_encode($response);
			exit;
		}

		if (isset($mobileresult->id)) {
			$response = array('status' => 400, 'message' => $this->lang->line('MOBILE_ALREADY_EXISTS'));
			echo json_encode($response);
			exit;
		}

		$data = array(
			'fullname' => $fullname,
			'email' => $email,
			'password' => md5($password),
			'mobile' => $mobile,
			'type' => 1,
		);

		$user_id = $this->API_CRUD_model->insert($data, 'user');

		$settinglist = $this->API_CRUD_model->get('', 'general_setting');
		foreach ($settinglist as $set) {
			$setn[$set->key] = $set->value;
		}

		$where = 'id ="' . $user_id . '"';
		$share_user = $this->API_CRUD_model->getById($where, 'user');
		$mail['user'] = $share_user;
		$mail['setn'] = $setn;
		$register = $this->load->view("admin/email/register", $mail, true);

		$smtpWhere = 'id="1"';
		$smtp_detail = $this->API_CRUD_model->getById($smtpWhere, 'smtp_setting');
		$emailconfig = get_smtp_setting();

		$this->load->library('email', $emailconfig);

		$this->email->from($smtp_detail->from_email, $smtp_detail->from_name);
		$this->email->to($_REQUEST['email']);
		$this->email->set_mailtype('html');
		$this->email->subject('Register');
		$this->email->message($register);
		$this->email->send();

		$response = array('status' => 200, 'message' => $this->lang->line('USER_REGISTRATION_SUCCESSFULLY'));
		echo json_encode($response);
		exit;
	}

	public function profile()
	{
		$this->form_validation->set_rules('user_id', 'user_id', 'required');
		if ($this->form_validation->run() == false) {
			$errors = $this->form_validation->error_array();
			sort($errors);
			$array = array('status' => 400, 'message' => $errors[0]);
			echo json_encode($array);
			exit;
		}

		$user_id = $_REQUEST['user_id'];
		$where = 'id="' . $user_id . '" ';
		$result = $this->API_CRUD_model->getById($where, 'user');
		if (isset($result->id)) {
			if ($result->image) {
				$result->image = get_image_path($result->image, 'user');
			}

			$where = 'user_id="' . $user_id . '" ';
			$author_result = $this->API_CRUD_model->getById($where, 'author');
			if ($author_result->image) {
				$author_result->image = get_image_path($author_result->image, 'author');
			}

			$response = array('status' => 200, 'message' => $this->lang->line('GET_RECORD_SUCCESS'), 'result' => array($result), 'author_profile' => $author_result);
		} else {
			$response = array('status' => 400, 'message' => $this->lang->line('RECORD_NOT_FOUND'), 'result' => array());
		}
		echo json_encode($response);
		exit;
	}

	public function update_profile()
	{
		$this->form_validation->set_rules('user_id', 'user_id', 'required');
		if ($this->form_validation->run() == false) {
			$errors = $this->form_validation->error_array();
			sort($errors);
			$array = array('status' => 400, 'message' => $errors[0]);
			echo json_encode($array);
			exit;
		}

		$user_id = $_REQUEST['user_id'];
		$data = array();


		if (isset($_REQUEST['fullname']) && $_REQUEST['fullname'] != '') {
			$data['fullname'] = $_REQUEST['fullname'];
		}

		if (isset($_REQUEST['mobile']) && $_REQUEST['mobile'] != '') {
			$data['mobile'] = $_REQUEST['mobile'];
		}

		if (isset($_REQUEST['email']) && $_REQUEST['email'] != '') {
			$data['email'] = $_REQUEST['email'];
		}

		if (isset($_FILES['image']['name']) && $_FILES['image']['name'] != '') {
			$data['image'] = $this->API_CRUD_model->imageupload($_FILES['image'], 'image', FCPATH . 'assets/images/user');
		}

		if (isset($_REQUEST['password'])) {
			$data['password'] = md5($_REQUEST['password']);
		}

		$data['is_updated'] = "1";
		$where = 'id="' . $user_id . '" ';
		$result = $this->API_CRUD_model->update($_REQUEST['user_id'], 'id', $data, 'user');

		if ($result) {
			$response = array('status' => 200, 'message' => $this->lang->line('UPDATE_PROFILE_SUCCESSFULLY'), 'id' => (string)$user_id);
			echo json_encode($response);
		} else {
			$response = array('status' => 400, 'message' => $this->lang->line('UPDATE_PROFILE_FAIL'));
			echo json_encode($response);
		}
	}

	public function send_mail($message, $email, $subject)
	{
		$smtpWhere = 'id="1"';
		$smtp_detail = $this->API_CRUD_model->getById($smtpWhere, 'smtp_setting');
		$emailconfig = get_smtp_setting();
		// $this->load->library('email',$emailconfig);
		$this->email->initialize($emailconfig);
		$this->email->from($smtp_detail->from_email, $smtp_detail->from_name);
		$this->email->to($email);
		$this->email->set_mailtype('html');
		$this->email->subject($subject);
		$this->email->message($message);
		$restul = $this->email->send();
	}

	public function forgotpassword()
	{
		$this->form_validation->set_rules('email', 'email', 'required');
		if ($this->form_validation->run() == false) {
			$errors = $this->form_validation->error_array();
			sort($errors);
			$array = array('status' => 400, 'message' => $errors[0]);
			echo json_encode($array);
			exit;
		}

		$settinglist = $this->API_CRUD_model->get('', 'general_setting');
		foreach ($settinglist as $set) {
			$setn[$set->key] = $set->value;
		}

		$where = 'email ="' . $_REQUEST['email'] . '"';
		$share_user = $this->API_CRUD_model->getById($where, 'user');

		if (isset($share_user->id)) {

			if ($share_user->type == 1) {
				$mail['user'] = $share_user;
				$mail['setn'] = $setn;
				$book_invoice = $this->load->view("admin/email/forgotpassword", $mail, true);

				$smtpWhere = 'id="1"';
				$smtp_detail = $this->API_CRUD_model->getById($smtpWhere, 'smtp_setting');
				$emailconfig = get_smtp_setting();

				$this->load->library('email', $emailconfig);

				$this->email->from($smtp_detail->from_email, $smtp_detail->from_name);
				$this->email->to($_REQUEST['email']);
				$this->email->set_mailtype('html');
				$this->email->subject('Reset Password');
				$this->email->message($book_invoice);
				$this->email->send();

				$response = array('status' => 200, 'message' => $this->lang->line('YOUR_PASSWORD_SENT_ON_EMAIL'));
				echo json_encode($response);
				exit;
			} else {
				$response = array('status' => 200, 'message' => $this->lang->line('YOU_HAVE_REGISTERED_WITH_SOCIAL'));
				echo json_encode($response);
				exit;
			}
		} else {
			$response = array('status' => 400, 'message' => $this->lang->line('ENTER_VALID_EMAIL'));
			echo json_encode($response);
			exit;
		}
	}

	public function loginwithotp()
	{
		try {
			$this->form_validation->set_rules('mobile', 'mobile', 'required');
			if ($this->form_validation->run() == false) {
				$errors = $this->form_validation->error_array();
				sort($errors);
				$array = array('status' => 400, 'message' => $this->lang->line('required_field'));
				echo json_encode($array);
				exit;
			} else {
				$mobileNumber = isset($_POST['mobile']) ? $_POST['mobile'] : '';
				$where = 'mobile="' . $mobileNumber . '"';
				$userData = $this->API_CRUD_model->getById($where, 'user');

				if (isset($userData->id)) {
					$userId = $userData->id;
				} else {
					$data = array(
						'fullname' => '',
						'email' => '',
						'password' => '',
						'type' => '3',
						'mobile' => $mobileNumber,
						'image' => ''
					);
					$userId = $this->API_CRUD_model->insert($data, 'user');
				}

				$where = "id=" . $userId;
				$userData = $this->API_CRUD_model->getById($where, 'user');

				$userData->image = get_image_path($userData->image, 'user');
				$userDatauser_type = 'login';
				$response = array('status' => 200, 'message' => $this->lang->line('LOGIN_SUCCESSFULLY'), 'result' => array($userData));
				echo json_encode($response);
				exit;
			}
		} catch (Exception $e) {
			$response = array('status' => 400, 'message' => $this->lang->line('ERROR'));
			echo json_encode($response);
			exit;
		}
	}

	public function earn_point()
	{

		$earn_point = $this->API_CRUD_model->get('', 'earn_point');

		$spin_wheel = $daily_login = $free_coin = [];
		foreach ($earn_point as $key => $value) {
			if ($value->point_type == 2) {
				$daily_login[] = $value;
			} else {
				$free_coin[] = $value;
			}
		}

		$response = array('status' => 200, 'daily_login' => $daily_login, 'free_coin' => $free_coin, 'message' => $this->lang->line('GET_RECORD_SUCCESS'));

		echo json_encode($response);
	}

	public function get_notification()
	{
		try {
			$this->form_validation->set_rules('user_id', 'user_id', 'required');
			if ($this->form_validation->run() == false) {
				$errors = $this->form_validation->error_array();
				sort($errors);
				$array = array('status' => 400, 'message' => $this->lang->line('PLEASE_ENTER_REQUIRED_FIELDS'));
				echo json_encode($array);
				exit;
			} else {

				$userId = trim($_REQUEST['user_id']);
				$whereUserId = 'user_id="' . $userId . '"';
				$getReadNotificationId = $this->API_CRUD_model->get($whereUserId, 'user_notification_tracking', 'id', 'desc');


				$notificationArr = array();
				foreach ($getReadNotificationId as $row) {

					array_push($notificationArr, $row->notification_id);
				}

				$wherecond = "";
				if (count($notificationArr) > 0) {
					$notificationArr = implode(',', $notificationArr);
					$wherecond = " id  NOT IN(" . $notificationArr . ")";
				}


				$getAllNotifications = $this->API_CRUD_model->get($wherecond, 'notification', 'id', 'desc');

				if (count($getAllNotifications) > 0) {
					$rows = [];
					foreach ($getAllNotifications as $key => $value) {

						if ($value->big_picture != '') {
							$value->big_picture = base_url() . 'assets/images/notification/' . $value->big_picture;
						}
						$rows[] = $value;
					}

					$response = array('status' => 200, 'result' => $rows, 'message' => $this->lang->line('GET_RECORD_SUCCESS'));
				} else {
					$response = array('status' => 400, 'message' => $this->lang->line('RECORD_NOT_FOUND'));
				}

				echo json_encode($response);
			}
		} catch (Exception $e) {
			$res = array('status' => 400, 'message' =>  $this->lang->line('ERROR'));
			return true;
		}
	}

	public function read_notification()
	{
		try {

			$this->form_validation->set_rules('user_id', 'user_id', 'required');
			$this->form_validation->set_rules('notification_id', 'notification_id', 'required');
			if ($this->form_validation->run() == false) {
				$errors = $this->form_validation->error_array();
				sort($errors);
				$array = array('status' => 400, 'message' => $this->lang->line('PLEASE_ENTER_REQUIRED_FIELDS'));
				echo json_encode($array);
				exit;
			} else {

				// echo "<pre>";print_r($_REQUEST);die;
				$userId = trim($_REQUEST['user_id']);
				$notification_id = trim($_REQUEST['notification_id']);
				$readArr = array();
				$readArr['user_id'] = $userId;
				$readArr['notification_id'] = $notification_id;
				$readArr['created_at'] = date('Y-m-d h:i:s');
				$this->API_CRUD_model->insert($readArr, 'user_notification_tracking');
				$response = array('status' => 200, 'message' =>  $this->lang->line('NOTIFICATION_READ_SUCCESSFULLY'));
				echo json_encode($response);
			}
		} catch (Exception $e) {
			$res = array('status' => 400, 'message' => $this->lang->line('ERROR'));
			return true;
		}
	}

	public function get_paymentoption()
	{
		$payment_option = $this->API_CRUD_model->get('', 'payment_option', 'id', 'desc');
		$data['paytm'] = [];
		$data['payumoney'] = [];
		$data['flutterwave'] = [];
		$data['razorpay'] = [];
		$data['paypal'] = [];
		$data['inapppurchage'] = [];

		foreach ($payment_option as $key => $value) {
			if ($value->name == 'PayTm') {
				$data['paytm'] = $value;
			}

			if ($value->name == 'PayUMoney') {
				$data['payumoney'] = $value;
			}

			if ($value->name == 'FlutterWave') {
				$data['flutterwave'] = $value;
			}

			if ($value->name == 'Razorpay') {
				$data['razorpay'] = $value;
			}

			if ($value->name == 'Paypal') {
				$data['paypal'] = $value;
			}

			if ($value->name == 'InApp Purchage') {
				$data['inapppurchage'] = $value;
			}
		}

		$response = array('status' => 200, 'paytm' => $data['paytm'], 'payumoney' => $data['payumoney'], 'flutterwave' => $data['flutterwave'], 'razorpay' => $data['razorpay'], 'paypal' => $data['paypal'], 'inapppurchage' => $data['inapppurchage']);
		echo json_encode($response);
	}

	public function getHashesByuser()
	{
		$this->form_validation->set_rules('txnid', 'txnid', 'required');
		$this->form_validation->set_rules('amount', 'amount', 'required');
		$this->form_validation->set_rules('productinfo', 'productinfo', 'required');
		$this->form_validation->set_rules('firstname', 'firstname', 'required');
		$this->form_validation->set_rules('email', 'email', 'required');
		if ($this->form_validation->run() == false) {
			$errors = $this->form_validation->error_array();
			sort($errors);
			$array = array('status' => 400, 'message' => $this->lang->line('PLEASE_ENTER_REQUIRED_FIELDS'));
			echo json_encode($array);
			exit;
		}

		$output = $this->getHashes($_POST["txnid"], $_POST["amount"], $_POST["productinfo"], $_POST["firstname"], $_POST["email"], '', '', '', '', '', '', '', '');
		$response = array('status' => 200, 'message' =>  $this->lang->line('NOTIFICATION_READ_SUCCESSFULLY'), 'result' => $output);
		echo json_encode($response);
	}

	public function getHashes($txnid, $amount, $productinfo, $firstname, $email, $user_credentials, $udf1, $udf2, $udf3, $udf4, $udf5, $offerKey, $cardBin)
	{

		$payment_option_where = 'name="PayUMoney"';
		$payment_option = $this->API_CRUD_model->getById($payment_option_where, 'payment_option');

		$MERCHANTID = '';
		$MERCHANTKEY = '';
		if (isset($payment_option->id)) {
			if ($payment_option->is_live == 1) {
				$MERCHANTID = $payment_option->live_key_1;
				$MERCHANTKEY = $payment_option->live_key_2;
			} else {
				$MERCHANTID = $payment_option->test_key_1;
				$MERCHANTKEY = $payment_option->test_key_2;
			}
		}

		$key = $MERCHANTID;
		$salt = $MERCHANTKEY;

		$payhash_str = $key . '' . $this->checkNull($txnid) . '' . $this->checkNull($amount)  . '' . $this->checkNull($productinfo)  . '' . $this->checkNull($firstname) . '' . $this->checkNull($email) . '' . $this->checkNull($udf1) . '' . $this->checkNull($udf2) . '' . $this->checkNull($udf3) . '' . $this->checkNull($udf4) . '' . $this->checkNull($udf5) . '' . $salt;
		$paymentHash = strtolower(hash('sha512', $payhash_str));
		$arr['payment_hash'] = $paymentHash;

		$cmnNameMerchantCodes = 'get_merchant_ibibo_codes';
		$merchantCodesHash_str = $key . '' . $cmnNameMerchantCodes . 'default' . $salt;
		$merchantCodesHash = strtolower(hash('sha512', $merchantCodesHash_str));
		$arr['get_merchant_ibibo_codes_hash'] = $merchantCodesHash;

		$cmnMobileSdk = 'vas_for_mobile_sdk';
		$mobileSdk_str = $key . '' . $cmnMobileSdk . 'default' . $salt;
		$mobileSdk = strtolower(hash('sha512', $mobileSdk_str));
		$arr['vas_for_mobile_sdk_hash'] = $mobileSdk;

		$cmnPaymentRelatedDetailsForMobileSdk1 = 'payment_related_details_for_mobile_sdk';
		$detailsForMobileSdk_str1 = $key  . '' . $cmnPaymentRelatedDetailsForMobileSdk1 . 'default' . $salt;
		$detailsForMobileSdk1 = strtolower(hash('sha512', $detailsForMobileSdk_str1));
		$arr['payment_related_details_for_mobile_sdk_hash'] = $detailsForMobileSdk1;

		if ($udf3 != NULL && !empty($udf3)) {
			$cmnSend_Sms = 'send_sms';
			$sendsms_str = $key . '' . $cmnSend_Sms . '' . $udf3 . '' . $salt;
			$send_sms = strtolower(hash('sha512', $sendsms_str));
			$arr['send_sms_hash'] = $send_sms;
		}

		if ($offerKey != NULL && !empty($offerKey)) {
			$cmnCheckOfferStatus = 'check_offer_status';
			$checkOfferStatus_str = $key  . '' . $cmnCheckOfferStatus . '' . $offerKey . '' . $salt;
			$checkOfferStatus = strtolower(hash('sha512', $checkOfferStatus_str));
			$arr['check_offer_status_hash'] = $checkOfferStatus;
		}

		if ($cardBin != NULL && !empty($cardBin)) {
			$cmnCheckIsDomestic = 'check_isDomestic';
			$checkIsDomestic_str = $key  . '' . $cmnCheckIsDomestic . '' . $cardBin . '' . $salt;
			$checkIsDomestic = strtolower(hash('sha512', $checkIsDomestic_str));
			$arr['check_isDomestic_hash'] = $checkIsDomestic;
		}


		return $arr;
	}

	function checkNull($value)
	{
		if ($value == null) {
			return '';
		} else {
			return $value;
		}
	}
}