<?php
defined('BASEPATH') or exit('No direct script access allowed');

class General extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->library('email');
        $this->load->model('API_CRUD_model');
    }

    public function add_comment()
    {
        $this->form_validation->set_rules('user_id', 'user_id', 'required');
        $this->form_validation->set_rules('comment', 'comment', 'required');

        if ($this->form_validation->run() == false) {
            $errors = $this->form_validation->error_array();
            sort($errors);
            $array = array('status' => 400, 'message' => $errors[0]);
            echo json_encode($array);
            exit;
        } else {

            $book_id = isset($_REQUEST['book_id']) ? $_REQUEST['book_id'] : '0';
            $magazine_id = isset($_REQUEST['magazine_id']) ? $_REQUEST['magazine_id'] : '0';
            $user_id = $_REQUEST['user_id'];
            $comment = $_REQUEST['comment'];

            $data = array(
                'book_id' => $book_id,
                'magazine_id' =>$magazine_id,
                'comment' => $_REQUEST['comment'],
                'user_id' => $_REQUEST['user_id'],
            );

            $comment_id = $this->API_CRUD_model->insert($data, 'comment');
            $response = array('status' => 200, 'message' => $this->lang->line('ADD_COMMNET_SUCCESS'), 'id' => (string) $comment_id);
            echo json_encode($response);       
        }
    }

    public function view_comment()
    {
        if (isset($_REQUEST['book_id']) || isset($_REQUEST['magazine_id'])) {

            if (isset($_REQUEST['book_id']) && $_REQUEST['book_id'] != '') {
                $where = 'book_id="' . $_REQUEST['book_id'] . '"';
            }

            if (isset($_REQUEST['magazine_id']) && $_REQUEST['magazine_id'] != '') {
                $where = 'magazine_id="' . $_REQUEST['magazine_id'] . '"';
            }

            $table = 'comment';
            $order = 'DESC';
            $field_order=$table.'.id';
            $data['page_limit'] = isset($_REQUEST['page_limit']) ? $_REQUEST['page_limit'] :  $this->config->item('page_limit');
            $data['page_no'] = isset($_REQUEST['page_no']) ? $_REQUEST['page_no'] : 1;
            $data['order_by'] = $order;
            $data['order_by_field'] = $field_order;

            // Join data
            $joinData = ['user'];
            foreach ($joinData as $value) {
                $joinArray[] = ['join' => $value . '.id=' . $table . '.' . $value . '_id', 'table' => $value];
            }

            $date = date('Y-m-d');
            if($where){
                $where = array($where);
            }
            $data['field'] = 'user.fullname,comment.*';
            $data['table'] = $table;
            $data['joins'] = $joinArray;
            $data['where'] = $where;
            $result = $this->API_CRUD_model->get_join($data);

            if (sizeof($result['data']) > 0) {
                $response = array('status' => 200, 'message' => $this->lang->line('GET_RECORD_SUCCESS'), 'result' => $result['data'],'total_records'=> $result['total_records'],'total_page'=> $result['total_page']);

            } else {
                $response = array('status' => 400, 'message' =>$this->lang->line('RECORD_NOT_FOUND'), 'result' => array());
            }
            echo json_encode($response);
        }
    }

    public function categorylist()
    {
        $result = $this->API_CRUD_model->get('', 'category');
        $rk = array();
        foreach ($result as $row) {
            $row->image = base_url() . 'assets/images/category/' . $row->image;
            $rk[] = $row;
        }

        if (sizeof($rk) > 0) {
            $response = array('status' => 200, 'message' => $this->lang->line('GET_RECORD_SUCCESS'), 'result' => $rk);
        } else {
            $response = array('status' => 400, 'message' => $this->lang->line('RECORD_NOT_FOUND'), 'result' => $rk);
        }
        echo json_encode($response);
    }

    public function general_setting()
    {

        $result = $this->API_CRUD_model->get('', 'general_setting');

        $where = 'status=1';
        $currency = $this->API_CRUD_model->getById($where, 'currency');
        if (isset($currency->id)) {
            $data[0]['id'] = "101";
            $data[1]['id'] = "101";
            $data[2]['id'] = "103";
            $data[3]['id'] = "104";
            $data[4]['id'] = "105";
            $data[5]['id'] = "106";

            $data[0]['key'] = 'currency_name';
            $data[1]['key'] = 'currency_symbol';
            $data[2]['key'] = 'currency_code';
            $data[3]['key'] = 'terms-and-conditions';
            $data[4]['key'] = 'privacy-policy';
            $data[5]['key'] = 'about-us';

            $data[0]['value'] = $currency->name;
            $data[1]['value'] = $currency->symbol;
            $data[2]['value'] = $currency->code;
            $data[3]['value'] = base_url().'page/terms-and-conditions';
            $data[4]['value'] = base_url().'page/privacy-policy';
            $data[5]['value'] = base_url().'page/about-us';

            $result = (array) $result;

            $rows = array_merge($result, $data);
        } else {
            $data[0]['id'] = "104";
            $data[1]['id'] = "105";
            $data[2]['id'] = "106";

            $data[0]['key'] = 'tram-and-conditions';
            $data[1]['key'] = 'privacy-policy';
            $data[2]['key'] = 'about-us';
            
             $data[3]['value'] = base_url().'page/terms-and-conditions';
            $data[4]['value'] = base_url().'page/privacy-policy';
            $data[5]['value'] = base_url().'page/about-us';
            
            $result = (array)$result;

            $rows = array_merge($result,$data);
            $rows = (array)$result;
        }

        if (sizeof($result) > 0) {
            $response = array('status' => 200, 'message' => $this->lang->line('GET_RECORD_SUCCESS'), 'result' => $rows);
        } else {
            $response = array('status' => 400, 'message' => $this->lang->line('RECORD_NOT_FOUND'), 'result' => $result);
        }
        echo json_encode($response);
    }

    public function add_view()
    {
        $this->form_validation->set_rules('book_id', 'book id', 'required');
        if ($this->form_validation->run() == false) {
            $errors = $this->form_validation->error_array();
            sort($errors);
            $array = array('status' => 400, 'message' => $errors[0]);
            echo json_encode($array);
            exit;
        } else {

            $add_point = 1;
            $result = $this->API_CRUD_model->updateByIdWithcount($_REQUEST['book_id'], 'readcnt', $add_point, 'book');

            if ($result) {
                $response = array('status' => 200, 'message' => $this->lang->line('ADD_RECORD_SUCCESS'));
            } else {
                $response = array('status' => 400, 'message' => $this->lang->line('ERROR'));
            }
            echo json_encode($response);exit;
        }
    }

    public function add_continue_read()
    {
        $this->form_validation->set_rules('book_id', 'book id', 'required');
        $this->form_validation->set_rules('user_id', 'user id', 'required');
        if ($this->form_validation->run() == false) {
            $errors = $this->form_validation->error_array();
            sort($errors);
            $array = array('status' => 400, 'message' => $errors[0]);
            echo json_encode($array);
            exit;
        } else {

            $user_id = $_REQUEST['user_id'];
            $book_id = $_REQUEST['book_id'];

            $where_tra = 'user_id=' . $user_id . ' AND book_id=' . $book_id . ' ';
            $resultr_con = $this->API_CRUD_model->getById($where_tra, 'continue_read');
            if (isset($resultr_con->id)) {
                $response = array('status' => 400, 'message' => $this->lang->line('RECORD_ALREADY_ADDED'));
                echo json_encode($response);exit;
            } else {
                $data = array(
                    'user_id' => $user_id,
                    'book_id' => $book_id,
                );

                $continue_read_id = $this->API_CRUD_model->insert($data, 'continue_read');
                $response = array('status' => 200, 'message' => $this->lang->line('ADD_RECORD_SUCCESS'), 'id' => (string) $continue_read_id);
                echo json_encode($response);exit;
            }
        }
    }

    public function add_bookmark()
    {
        $this->form_validation->set_rules('user_id', 'user id', 'required');
         
        if ($this->form_validation->run() == false) {
            $errors = $this->form_validation->error_array();
            sort($errors);
            $array = array('status' => 400, 'message' => $errors[0]);
            echo json_encode($array);
            exit;
        } else {
        
            $user_id = $_REQUEST['user_id'];
            $book_id = isset($_REQUEST['book_id']) ? $_REQUEST['book_id'] : '';
            $magazine_id = isset($_REQUEST['magazine_id']) ? $_REQUEST['magazine_id'] : '';

            if ($magazine_id) {
                $where_tra = 'user_id=' . $user_id . ' AND magazine_id=' . $magazine_id . ' ';
            }

            if ($book_id) {
                $where_tra = 'user_id=' . $user_id . ' AND book_id=' . $book_id . ' ';
            }

            $resultr_con = $this->API_CRUD_model->getById($where_tra, 'bookmark');

            if (isset($resultr_con->id)) {
                $where_delete = 'id=' . $resultr_con->id;
                $this->API_CRUD_model->delete($where_delete, 'bookmark');
                $response = array('status' => 400, 'message' => $this->lang->line('REMOVE_BOOKMARK_SUCCESS'));

            } else {
                $data = array(
                    'user_id' => $user_id,
                    'book_id' => $book_id,
                    'magazine_id' => $magazine_id,
                );

                $bookmark_id = $this->API_CRUD_model->insert($data, 'bookmark');
                $response = array('status' => 200, 'message' => $this->lang->line('ADD_BOOKMARK_SUCCESS'), 'id' => (string) $bookmark_id);
            }
            echo json_encode($response);
            exit;
        } 
    }

    public function userlist()
    {
        // Join data
        $joinArray = [];
        $data['page_no'] = isset($_REQUEST['page_no']) ? $_REQUEST['page_no'] : 1;
        $table = 'user';
        $data['field'] = 'user.*';
        $data['table'] = $table;
        $data['joins'] = $joinArray;
        $data['where'] = [];
        $result = $this->API_CRUD_model->get_join($data);

        if (sizeof($result['data']) > 0) {
            $response = array('status' => 200, 'message' => $this->lang->line('GET_RECORD_SUCCESS'), 'result' => $result['data'],'total_records'=> $result['total_records'],'total_page'=> $result['total_page']);
        } else {
            $response = array('status' => 400, 'message' => $this->lang->line('RECORD_NOT_FOUND'));
        }
        echo json_encode($response);
    }

    public function add_rating()
    {
        $this->form_validation->set_rules('user_id', 'user id', 'required');
        $this->form_validation->set_rules('book_id', 'book id', 'required');
        $this->form_validation->set_rules('rating', 'rating', 'required');
         
        if ($this->form_validation->run() == false) {
            $errors = $this->form_validation->error_array();
            sort($errors);
            $array = array('status' => 400, 'message' => $errors[0]);
            echo json_encode($array);
            exit;
        } else {
       
            $book_id = $_REQUEST['book_id'];
            $user_id = $_REQUEST['user_id'];
            $ratingData = $_REQUEST['rating'];
            $where = 'book_id="' . $book_id . '" and user_id="' . $user_id . '"';
            $rating = $this->API_CRUD_model->getById($where, 'rating');

            $data = array(
                'book_id' => $book_id,
                'user_id' => $user_id,
                'rating' => $ratingData);

            if (isset($rating->id)) {
                $where = 'rating_id="' . $rating->id . '"';
                $this->API_CRUD_model->update($rating->id, 'id', $data, 'rating');
            } else {
                $this->API_CRUD_model->insert($data, 'rating');
            }

            $response = array('status' => 200, 'message' => $this->lang->line('ADD_RATING'));
            echo json_encode($response);
        }
    }

    public function get_package()
    {
        $results = $this->API_CRUD_model->get('', 'package');
        $data = [];
        foreach ($results as $value) {
            $value->package_image = base_url() . 'assets/images/package/' . $value->package_image;
            $data[] = $value;
        }

        if (sizeof($data) > 0) {
            $response = array('status' => 200, 'message' => $this->lang->line('GET_RECORD_SUCCESS'), 'result' => $data);
        } else {
            $response = array('status' => 400, 'message' => $this->lang->line('RECORD_NOT_FOUND'));
        }
        echo json_encode($response);
    }

    public function get_ads_banner()
    {
       // Join data
        $joinArray = [];
        $data['page_no'] = isset($_REQUEST['page_no']) ? $_REQUEST['page_no'] : 1;
        $table = 'ads_banner';
        $data['field'] = 'ads_banner.*';
        $data['table'] = $table;
        $data['joins'] = $joinArray;
        $data['where'] = [];
        $result = $this->API_CRUD_model->get_join($data);

        $rk = array();
        foreach ($result['data'] as $row) {
            $row->image = base_url() . 'assets/images/banner/' . $row->image;
            $rk[] = $row;
        }

        if (sizeof($rk) > 0) {
            $response = array('status' => 200, 'message' =>$this->lang->line('GET_RECORD_SUCCESS'), 'result' => $rk,'total_records'=> $result['total_records'],'total_page'=> $result['total_page']);
        } else {
            $response = array('status' => 400, 'message' => $this->lang->line('RECORD_NOT_FOUND'));
        }
        echo json_encode($response);
    }

    public function checkbookmark()
    {
        $this->form_validation->set_rules('user_id', 'user id', 'required');
        if ($this->form_validation->run() == false) {
            $errors = $this->form_validation->error_array();
            sort($errors);
            $array = array('status' => 400, 'message' => $errors[0]);
            echo json_encode($array);
            exit;
        } else {
             
            $book_id = isset($_REQUEST['book_id']) ? $_REQUEST['book_id'] : '';
            $magazine_id = isset($_REQUEST['magazine_id']) ? $_REQUEST['magazine_id'] : '';
            
            if($magazine_id){
                $where = 'user_id=' . $_REQUEST['user_id'] . ' AND magazine_id=' . $magazine_id . '';
            }else{
                $where = 'user_id=' . $_REQUEST['user_id'] . ' AND book_id=' . $book_id . '';
            }

            $result = $this->API_CRUD_model->getById($where, 'bookmark');

            if (isset($result->id)) {
                $response = array('status' => 200, 'message' =>$this->lang->line('IS_BOOKMARK_YES'));
            } else {
                $response = array('status' => 400, 'message' => $this->lang->line('IS_BOOKMARK_NO'));
            }
            echo json_encode($response);
        
        }
    }

    public function add_transaction()
    {
        $this->form_validation->set_rules('author_id', 'author id', 'required');
        $this->form_validation->set_rules('user_id', 'user id', 'required');
        $this->form_validation->set_rules('amount', 'amount', 'required');
        if ($this->form_validation->run() == false) {
            $errors = $this->form_validation->error_array();
            sort($errors);
            $array = array('status' => 400, 'message' => $errors[0]);
            echo json_encode($array);
            exit;
        } else {

            $author_id = isset($_REQUEST['author_id']) ? $_REQUEST['author_id'] : '';
            $book_id = isset($_REQUEST['book_id']) ? $_REQUEST['book_id'] : '';
            $magazine_id = isset($_REQUEST['magazine_id']) ? $_REQUEST['magazine_id'] : '';
            $book_chapter_id = isset($_REQUEST['book_chapter_id']) ? $_REQUEST['book_chapter_id'] : '0';
            $user_id = isset($_REQUEST['user_id']) ? $_REQUEST['user_id'] : '';
            $amount = isset($_REQUEST['amount']) ? $_REQUEST['amount'] : '0';
            $voucher_id = isset($_REQUEST['voucher_id']) ? $_REQUEST['voucher_id'] : '';
            $voucher_amount = isset($_REQUEST['voucher_amount']) ? $_REQUEST['voucher_amount'] : '0';

            $transcation_amount = isset($_REQUEST['transcation_amount']) ? $_REQUEST['transcation_amount'] : '0';
            $wallet_amount = isset($_REQUEST['wallet_amount']) ? $_REQUEST['wallet_amount'] : '0';
            $type = isset($_REQUEST['type']) ? $_REQUEST['type'] : '2'; // 1- payment getway, 2- wallet amount

            $settinglist = $this->API_CRUD_model->get('', 'general_setting');
            foreach ($settinglist as $set) {
                $setn[$set->key] = $set->value;
            }

            // Voucher check
            if ($voucher_id) {
                $v_ids = explode(',', $voucher_id);
                foreach ($v_ids as $key => $row) {
                    $whereVoucher = 'id=' . $row;
                    $voucher = $this->API_CRUD_model->getById($whereVoucher, 'voucher');

                    if (isset($voucher->status) && $voucher->status == 1) {
                        $response = array('status' => 400, 'message' =>$this->lang->line('ENTER_VALID_VOUCHER'));
                        echo json_encode($response);exit;
                    }
                }
            }

            $totalAmount = $amount + $voucher_amount;

            $author_commission = $setn['author_commission'];
            $author_commission_amount = ($totalAmount * $author_commission) / 100;

            $data = array(
                'user_id' => $user_id,
                'author_id' => $author_id,
                'book_id' => $book_id,
                'type' =>$type,
                'magazine_id' => $magazine_id,
                'book_chapter_id' => $book_chapter_id,
                'voucher_id' => $voucher_id,
                'voucher_amount' => $voucher_amount,
                'author_commission_amount' => $author_commission_amount,
                'amount' => $amount,
                'transcation_amount' => $transcation_amount,
                'wallet_amount' => $wallet_amount,
                'total_amount' => $totalAmount,
            );

            $id = $this->API_CRUD_model->insert($data, 'transaction');
            

            if($wallet_amount > 0){
                $field_name = "coin_balance";
                $value = $wallet_amount;

                $whereUser = "id=".$user_id;
                $user = $this->API_CRUD_model->getById($whereUser, 'user');
              
                if ($user->coin_balance < $value) {
                    $array = array('status' => 400, 'message' => $this->lang->line('INSUFFICIENT_BALANCE'));
                    echo json_encode($array);
                    exit;
                }

                $this->API_CRUD_model->subtractionByIdWithcount($user_id, $field_name, $value, 'user');
            }

            if($voucher_amount > 0){
                $field_name = "voucher_balance";
                $value = $voucher_amount;

                $this->API_CRUD_model->subtractionByIdWithcount($user_id, $field_name, $value, 'user');
                // Voucher check
                if ($voucher_id) {
                    $v_ids = explode(',', $voucher_id);
                    foreach ($v_ids as $key => $row) {
                        $dataVoucher['status'] = 1;
                        $this->API_CRUD_model->update($row, 'id', $dataVoucher, 'voucher');
                    }
                }
            }

            $result['id'] = $id;
            $data['id'] = $id;
            $where_book = 'id=' . $book_id;
            $mail['book'] = $this->API_CRUD_model->getById($where_book, 'book');

            $where_author = 'id=' . $author_id;
            $mail['author'] = $this->API_CRUD_model->getById($where_author, 'author');

            $where_user = 'id=' . $user_id;
            $mail['user'] = $this->API_CRUD_model->getById($where_user, 'user');

            $mail['transaction'] = $data;

            $mail['setn'] = $setn;
            // p($mail);
            $book_invoice = $this->load->view("admin/email/book_invoice", $mail, true);
            // p($book_invoice);
            $email = $mail['user']->email;
            $subject = "Book Invoice #EB" . date('Ym') . 'T' . $data['id'];
            send_mail($book_invoice, $email, $subject);

            $response = array('status' => 200, 'message' => $this->lang->line('TRANSACTION_SUCCESSFULLY'), 'result' => $result);
            echo json_encode($response);exit;
        }
    }    

    public function add_package_transaction()
    {
        $this->form_validation->set_rules('user_id', 'user id', 'required');
        $this->form_validation->set_rules('amount', 'amount', 'required');
        // $this->form_validation->set_rules('package_id', 'package id', 'required');
        if ($this->form_validation->run() == false) {
            $errors = $this->form_validation->error_array();
            sort($errors);
            $array = array('status' => 400, 'message' => $errors[0]);
            echo json_encode($array);
            exit;
        } else {
            $user_id = isset($_REQUEST['user_id']) ? $_REQUEST['user_id'] : '';
            $amount = isset($_REQUEST['amount']) ? $_REQUEST['amount'] : '';
          
            $payment_id = isset($_REQUEST['payment_id']) ? $_REQUEST['payment_id'] : '';
            $state = isset($_REQUEST['state']) ? $_REQUEST['state'] : '';
            $package_id = isset($_REQUEST['package_id']) ? $_REQUEST['package_id'] : '';

            $data = array(
                'user_id' => $user_id,
                'package_id' => $package_id,            
                'state' => $state,
                'payment_id' => $payment_id,
                'amount' => $amount,
            );

            $this->API_CRUD_model->insert($data, 'package_transaction');

            $field_name = "coin_balance";
            $value = $amount;
            $this->API_CRUD_model->updateByIdWithcount($user_id, $field_name, $value, 'user');


            $settinglist = $this->API_CRUD_model->get('','general_setting');
            foreach($settinglist as $set){
                $setn[$set->key]=$set->value;
            }

            $where='id ="'.$user_id.'"';
            $share_user = $this->API_CRUD_model->getById($where,'user');
         
            $mail['user'] = $share_user;
            $mail['amount'] = $amount;
            $mail['setn'] = $setn;
            $register = $this->load->view("admin/email/package_transaction",$mail,true);
            
            $smtpWhere = 'id="1"';
            $smtp_detail = $this->API_CRUD_model->getById($smtpWhere, 'smtp_setting');
            $emailconfig = get_smtp_setting();

            $this->load->library('email',$emailconfig);
            $this->email->from($smtp_detail->from_email, $smtp_detail->from_name);
            $this->email->to($share_user->email);
            $this->email->set_mailtype('html');
            $this->email->subject('Payment Transaction');
            $this->email->message($register);
            $this->email->send();


            $response = array('status' => 200, 'message' =>$this->lang->line('TRANSACTION_SUCCESSFULLY'));
            echo json_encode($response);exit;
        }
    }

    public function get_wallet_transaction()
    {
        $this->form_validation->set_rules('user_id', 'user id', 'required');
        if ($this->form_validation->run() == false) {
            $errors = $this->form_validation->error_array();
            sort($errors);
            $array = array('status' => 400, 'message' => $errors[0]);
            echo json_encode($array);
            exit;
        } else {
        
            $table = 'package_transaction';
            $order = 'DESC';
            $field_order=$table.'.id';
            $data['page_limit'] = isset($_REQUEST['page_limit']) ? $_REQUEST['page_limit'] :  $this->config->item('page_limit');
            $data['page_no'] = isset($_REQUEST['page_no']) ? $_REQUEST['page_no'] : 1;
            $data['order_by'] = $order;
            $data['order_by_field'] = $field_order;

            // Join data
            $joinArray = [];
            
            $where = 'package_transaction.user_id=' . $_REQUEST['user_id'];

            $date = date('Y-m-d');
            if($where){
                $where = array($where);
            }
            $data['field'] = 'package_transaction.*';
            $data['table'] = $table;
            $data['joins'] = $joinArray;
            $data['where'] = $where;
            $result = $this->API_CRUD_model->get_join($data);

            if (count($result['data']) > 0) {
                $dataArray= [];
                foreach ($result['data'] as $key => $value) {
                    $package_name = '';
                    if($value->package_id >0){
                        $wherePackages = 'id='.$value->package_id;
                        $packagesName = $this->API_CRUD_model->getById($wherePackages, 'package');
                        $package_name = $packagesName->package_name;
                    }

                    $value->package_name = $package_name;

                    $dataArray[] = $value;
                }
                
                $response = array('status' => 200, 'message' => $this->lang->line('GET_RECORD_SUCCESS'), 'result' => $dataArray,'total_records'=> $result['total_records'],'total_page'=> $result['total_page']);
            } else {
                $response = array('status' => 400, 'message' => $this->lang->line('RECORD_NOT_FOUND'));
            }
            echo json_encode($response);exit;
        }
    }

    public function addVoucher()
    {

        $this->form_validation->set_rules('user_id', 'user id', 'required');
        $this->form_validation->set_rules('title', 'title', 'required');
        $this->form_validation->set_rules('points', 'points', 'required');
        if ($this->form_validation->run() == false) {
            $errors = $this->form_validation->error_array();
            sort($errors);
            $array = array('status' => 400, 'message' => $errors[0]);
            echo json_encode($array);
            exit;
        } else {
            $title = isset($_REQUEST['title']) ? $_REQUEST['title'] : '';
            $user_id = isset($_REQUEST['user_id']) ? $_REQUEST['user_id'] : '';
            $points = isset($_REQUEST['points']) ? $_REQUEST['points'] : '';

            $toDay = date('Y-m-d');
            $expiry_date = date("Y-m-t", strtotime($toDay));

            $data = array(
                'user_id' => $user_id,
                'title' => $title,
                'points' => $points,
                'status' => 0,
                'expiry_date' => $expiry_date,
            );

            $id = $this->API_CRUD_model->insert($data, 'voucher');

            $field_name = "voucher_balance";
            $value = $points;
            $this->API_CRUD_model->updateByIdWithcount($user_id, $field_name, $value, 'user');

            $response = array('status' => 200, 'message' =>$this->lang->line('ADD_VOUCHER_SUCCESS'));
            echo json_encode($response);
        } 
    }

    public function listVoucher()
    {
        $this->form_validation->set_rules('user_id', 'user id', 'required');
        if ($this->form_validation->run() == false) {
            $errors = $this->form_validation->error_array();
            sort($errors);
            $array = array('status' => 400, 'message' => $errors[0]);
            echo json_encode($array);
            exit;
        } else {
            
            $user_id = $_REQUEST['user_id'];
            $userWhere = 'id=' . $user_id;
            
            $user = $this->API_CRUD_model->getById($userWhere, 'user');
            $voucher_balance = 0;
            if (isset($user->id)) {
                $voucher_balance = $user->voucher_balance;
            }

            $where = 'user_id=' . $user_id . ' AND status = 0';
            $joinArray = [];
            $data['page_no'] = isset($_REQUEST['page_no']) ? $_REQUEST['page_no'] : 1;
            $table = 'voucher';
            $data['field'] = 'voucher.*';
            $data['table'] = $table;
            $data['joins'] = $joinArray;
            $data['where'] = [$where];
            $result = $this->API_CRUD_model->get_join($data);

            if (sizeof($result['data']) > 0) {
                $response = array('status' => 200, 'message' =>$this->lang->line('GET_VOUCHER_SUCCESS'), 'result' => $result['data'], 'voucher_balance' => $voucher_balance,'total_records'=> $result['total_records'],'total_page'=> $result['total_page']);
            } else {
                $response = array('status' => 400, 'message' => $this->lang->line('RECORD_NOT_FOUND'));
            }
            echo json_encode($response);
        } 
    }
}