<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Author extends CI_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->library('email');
		$this->load->model('API_CRUD_model');
		$this->load->model('CRUD_model');
		
	}
	
	public function add_author(){	
		$this->form_validation->set_rules('user_id', 'user_id', 'required');
        $this->form_validation->set_rules('name', 'name', 'required');
        $this->form_validation->set_rules('address', 'address', 'required');
        $this->form_validation->set_rules('email', 'email', 'required');
        $this->form_validation->set_rules('password', 'password', 'required');

        if ($this->form_validation->run() == false) {
            $errors = $this->form_validation->error_array();
            sort($errors);
            $array = array('status' => 400, 'message' => $errors[0]);
            echo json_encode($array);
            exit;
        }

		$where='email="'.$_POST['email'].'"';
		$emailresult = $this->API_CRUD_model->getById($where,'author'); 
			
		if(isset($emailresult->id)){
			$response=array('status'=>400,'message'=>$this->lang->line('EMAIL_ALREADY_EXISTS'));
			echo json_encode($response);exit;
		}

		$where='user_id="'.$_POST['user_id'].'"';
		$authorresult = $this->API_CRUD_model->getById($where,'author'); 
			
		if(isset($emailresult->id)){
			$response=array('status'=>400,'message'=>$this->lang->line('EMAIL_ALREADY_EXISTS'));
			echo json_encode($response);exit;
		}

		if(isset($authorresult->id)){
			$response=array('status'=>400,'message'=>$this->lang->line('AUTHOR_ALREADY_EXISTS'));
			echo json_encode($response);exit;
		}			

		$data = array(
			'name'=>$_POST['name'],
			'email'=>$_POST['email'],
			'password'=> md5($_POST['password']),
			'address'=>$_POST['address'],
			'user_id'=>$_POST['user_id'],
			'status'=>0
		);
		

		if(isset($_FILES['image']['name']) && $_FILES['image']['name'] != '')
		{
			$data['image'] = $this->API_CRUD_model->imageupload($_FILES['image'],'image', FCPATH . 'assets/images/author');
		}

		if(isset($_REQUEST['bio']) && $_REQUEST['bio'] != ''){
			$data['bio'] = $_REQUEST['bio'];
		}
		
		$author_id=$this->API_CRUD_model->insert($data,'author');


		$where='user_id ="'.$_POST['user_id'].'" AND id = "'.$author_id.'"';
		$author = $this->API_CRUD_model->getById($where,'author');

		$result = [$author];	
		$response=array('status'=>200,'message'=>$this->lang->line('AUTHOR_REGISTRATION_SUCCESSFULLY'),'result'=>$result);
		echo json_encode($response);exit;			
	}
	
	public function get_author(){		
        $this->form_validation->set_rules('author_id', 'author_id', 'required');

        if ($this->form_validation->run() == false) {
            $errors = $this->form_validation->error_array();
            sort($errors);
            $array = array('status' => 400, 'message' => $errors[0]);
            echo json_encode($array);
            exit;
        }
		
		$where = 'id="'.$_POST['author_id'].'" ';
		$result = $this->API_CRUD_model->getById($where,'author');

		$where = 'author_id='.$_POST['author_id'];
		$book = $this->API_CRUD_model->getsumCount('sum(readcnt)as read_count , sum(download) as download, count(id) as total_book', $where,'book');

		$where = 'author_id='.$_POST['author_id'];
		$magazine = $this->API_CRUD_model->getsumCount('sum(readcnt)as read_count , sum(download) as download, count(id) as total_magazine', $where,'magazine');

		$book->read_count = isset($book->read_count) ? $book->read_count : '0';
		$book->download = isset($book->download) ? $book->download : '0';
		$book->total_book = isset($book->total_book) ? $book->total_book : '0';

		$magazine->read_count = isset($magazine->read_count) ? $magazine->read_count : '0';
		$magazine->download = isset($magazine->download) ? $magazine->download : '0';
		$magazine->total_magazine = isset($magazine->total_magazine) ? $magazine->total_magazine : '0';

		if(isset($result->id)){
			if($result->image)
			{
				$result->image = get_image_path($result->image,'author');	
			}
			$response=array('status'=>200,'message'=>$this->lang->line('GET_RECORD_SUCCESS'),'result'=>array($result),'book'=>$book,'magazine'=>$magazine);
		}else{
			$response=array('status'=>400,'message'=>$this->lang->line('RECORD_NOT_FOUND'),'result'=>array());
		}
		echo json_encode($response);exit;		
	}
	
	public function update_author(){
		$this->form_validation->set_rules('user_id', 'user_id', 'required');
        $this->form_validation->set_rules('author_id', 'author_id', 'required');
		if ($this->form_validation->run() == false) {
            $errors = $this->form_validation->error_array();
            sort($errors);
            $array = array('status' => 400, 'message' => $errors[0]);
            echo json_encode($array);
            exit;
        }

		if(isset($_REQUEST['name']) && $_REQUEST['name'] != ''){
			$data['name'] = $_REQUEST['name'];
		}

		if(isset($_REQUEST['address']) && $_REQUEST['address'] != ''){
			$data['address'] = $_REQUEST['address'];
		}		

		if(isset($_REQUEST['bio']) && $_REQUEST['bio'] != ''){
			$data['bio'] = $_REQUEST['bio'];
		}			

		if(isset($_REQUEST['email']) && $_REQUEST['email'] != ''){
			$data['email'] = $_REQUEST['email'];
		}
		
		if(isset($_FILES['image']['name']) && $_FILES['image']['name'] != '')
		{
			$data['image'] = $this->API_CRUD_model->imageupload($_FILES['image'],'image', FCPATH . 'assets/images/author');
		}

		if(isset($_REQUEST['password']))
		{
			$data['password'] = MD5($_REQUEST['password']);
		}			

		$result = $this->API_CRUD_model->update($_REQUEST['author_id'], 'id', $data, 'author');

		if($result){
			$response=array('status'=>200,'message'=>$this->lang->line('UPDATE_PROFILE_SUCCESSFULLY'),'id'=>(string)$user_id);
			echo json_encode($response);
		}else{
			$response=array('status'=>400,'message'=>$this->lang->line('ERROR'));
			echo json_encode($response);
		}		
	}

	public function add_bank_detail(){	
		$this->form_validation->set_rules('author_id', 'author_id', 'required');
        $this->form_validation->set_rules('bank_name', 'bank_name', 'required');
        $this->form_validation->set_rules('account_no', 'account_no', 'required');
        $this->form_validation->set_rules('bank_holder_name', 'bank_holder_name', 'required');
		$this->form_validation->set_rules('ifsc_code', 'ifsc_code', 'required');        

        if ($this->form_validation->run() == false) {
            $errors = $this->form_validation->error_array();
            sort($errors);
            $array = array('status' => 400, 'message' => $errors[0]);
            echo json_encode($array);
            exit;
        }	

    	$where='author_id="'.$_POST['author_id'].'"';
		$emailresult = $this->API_CRUD_model->getById($where,'bank_detail'); 
			
		if(isset($emailresult->id)){
			$response=array('status'=>400,'message'=> $this->lang->line('BANK_DETAIL_ALREADY_EXISTS'));
			echo json_encode($response);exit;
		}

		$data = array(
			'bank_name'=>$_POST['bank_name'],
			'account_no'=>$_POST['account_no'],
			'bank_holder_name'=> $_POST['bank_holder_name'],
			'author_id'=>$_POST['author_id'],
			'ifsc_code'=>$_POST['ifsc_code']
		);			

		$bank_detail_id=$this->API_CRUD_model->insert($data,'bank_detail');

		$where='id = "'.$bank_detail_id.'"';
		$author = $this->API_CRUD_model->getById($where,'bank_detail');
		
		$result = [$author];		

		$response=array('status'=>200,'message'=>$this->lang->line('BANK_DETAIL_ADD_SUCESSFULY'),'result'=> $result);
		echo json_encode($response);exit;			
	}
	
	public function get_bank_detail(){
		$this->form_validation->set_rules('author_id', 'author_id', 'required');

        if ($this->form_validation->run() == false) {
            $errors = $this->form_validation->error_array();
            sort($errors);
            $array = array('status' => 400, 'message' => $errors[0]);
            echo json_encode($array);
            exit;
        }

		
		$where = 'author_id="'.$_POST['author_id'].'" ';
		$result = $this->API_CRUD_model->getById($where,'bank_detail');
		if(isset($result->id)){
			if($result->image)
			{
				$result->image = get_image_path($result->image,'author');	
			}
			$response=array('status'=>200,'message'=>$this->lang->line('GET_RECORD_SUCCESS'),'result'=>array($result));
		}else{
			$response=array('status'=>400,'message'=>$this->lang->line('RECORD_NOT_FOUND'),'result'=>array());
		}
		echo json_encode($response);exit;
	}
	
	public function update_bank_detail(){

		$this->form_validation->set_rules('id', 'id', 'required');
        $this->form_validation->set_rules('author_id', 'author_id', 'required');
		if ($this->form_validation->run() == false) {
            $errors = $this->form_validation->error_array();
            sort($errors);
            $array = array('status' => 400, 'message' => $errors[0]);
            echo json_encode($array);
            exit;
        }

		if(isset($_REQUEST['bank_name']) && $_REQUEST['bank_name'] != ''){
			$data['bank_name'] = $_REQUEST['bank_name'];
		}

		if(isset($_REQUEST['account_no']) && $_REQUEST['account_no'] != ''){
			$data['account_no'] = $_REQUEST['account_no'];
		}

		if(isset($_REQUEST['ifsc_code']) && $_REQUEST['ifsc_code'] != ''){
			$data['ifsc_code'] = $_REQUEST['ifsc_code'];
		}			

		if(isset($_REQUEST['bank_holder_name']) && $_REQUEST['bank_holder_name'] != ''){
			$data['bank_holder_name'] = $_REQUEST['bank_holder_name'];
		}				

		$result = $this->API_CRUD_model->update($_REQUEST['author_id'], 'author_id', $data, 'bank_detail');

		if($result){
			$response=array('status'=>200,'message'=>$this->lang->line('BANK_DETAIL_UPDATE_SUCCESSFULY'),'id'=>(string)$user_id);
			echo json_encode($response);
		}else{
			$response=array('status'=>400,'message'=>$this->lang->line('BANK_DETAIL_NOT_UPDATE'));
			echo json_encode($response);
		}
	}

	public function upload_book(){

        $this->form_validation->set_rules('author_id', 'author_id', 'required');
		$this->form_validation->set_rules('title', 'title', 'required');
		$this->form_validation->set_rules('category_id', 'category_id', 'required');
		$this->form_validation->set_rules('description', 'description', 'required');
		$this->form_validation->set_rules('is_paid', 'is_paid', 'required');
		if ($this->form_validation->run() == false) {
            $errors = $this->form_validation->error_array();
            sort($errors);
            $array = array('status' => 400, 'message' => $errors[0]);
            echo json_encode($array);
            exit;
        }

        $price = isset($_POST['price']) ? $_POST['price'] :0;
		

        $where = 'id="'.$_POST['author_id'].'" ';
		$author = $this->API_CRUD_model->getById($where,'author');

		if($author->status == 0){
			$data['status'] = 0;
		}

		$data['price'] = $price;
		$data['author_id'] = $_REQUEST['author_id'];
		$data['title'] = $_REQUEST['title'];
		$data['category_id'] = $_REQUEST['category_id'];
		$data['description'] = $_REQUEST['description'];
		$data['is_paid'] = $_REQUEST['is_paid'];

		if (isset($_FILES['sample_url']) && !empty($_FILES['sample_url']['name'])) {
            $data['sample_url'] = $this->CRUD_model->imageupload($_FILES['sample_url'], 'sample_url', FCPATH . 'assets/images/book');
        } 
	
		if (isset($_FILES['image']) && !empty($_FILES['image']['name'])) {
            $data['image'] = $this->CRUD_model->imageupload($_FILES['image'], 'image', FCPATH . 'assets/images/book');
        } 

        if (isset($_FILES['full_book']) && !empty($_FILES['full_book']['name'])) {
            $data['url'] = $this->CRUD_model->imageupload($_FILES['full_book'], 'full_book', FCPATH . 'assets/images/book');
        } 

		$result = $this->API_CRUD_model->insert($data, 'book');

		if($result){
			$response=array('status'=>200,'message'=>$this->lang->line('ADD_BOOK_SUCCESS'),'id'=>(string)$result);
			echo json_encode($response);
		}else{
			$response=array('status'=>400,'message'=>$this->lang->line('BOOK_NOT_ADDED'));
			echo json_encode($response);
		}		
	}

	public function upload_magazine(){		

        $this->form_validation->set_rules('author_id', 'author_id', 'required');
		$this->form_validation->set_rules('title', 'title', 'required');
		$this->form_validation->set_rules('category_id', 'category_id', 'required');
		$this->form_validation->set_rules('description', 'description', 'required');
		$this->form_validation->set_rules('is_paid', 'is_paid', 'required');
		if ($this->form_validation->run() == false) {
            $errors = $this->form_validation->error_array();
            sort($errors);
            $array = array('status' => 400, 'message' => $errors[0]);
            echo json_encode($array);
            exit;
        }

        $price = isset($_POST['price']) ? $_POST['price'] :0;
		
 		$where = 'id="'.$_POST['author_id'].'" ';
		$author = $this->API_CRUD_model->getById($where,'author');

		if($author->status == 0){
			$data['status'] = 0;
		}

		$data['price'] = $price;
		$data['author_id'] = $_REQUEST['author_id'];
		$data['title'] = $_REQUEST['title'];
		$data['category_id'] = $_REQUEST['category_id'];
		$data['description'] = $_REQUEST['description'];
		$data['is_paid'] = $_REQUEST['is_paid'];

		if (isset($_FILES['sample_url']) && !empty($_FILES['sample_url']['name'])) {
            $data['sample_url'] = $this->CRUD_model->imageupload($_FILES['sample_url'], 'sample_url', FCPATH . 'assets/images/magazine');
        } 
	
		if (isset($_FILES['image']) && !empty($_FILES['image']['name'])) {
            $data['image'] = $this->CRUD_model->imageupload($_FILES['image'], 'image', FCPATH . 'assets/images/magazine');
        } 

        if (isset($_FILES['full_magazine']) && !empty($_FILES['full_magazine']['name'])) {
            $data['url'] = $this->CRUD_model->imageupload($_FILES['full_magazine'], 'full_magazine', FCPATH . 'assets/images/magazine');
        } 

		$result = $this->API_CRUD_model->insert($data, 'magazine');

		if($result){
			$response=array('status'=>200,'message'=> $this->lang->line('ADD_MAGAZINE_SUCCESS'),'id'=>(string)$result);
			echo json_encode($response);
		}else{
			$response=array('status'=>400,'message'=> $this->lang->line('ADD_MAGAZINE_FAIL'));
			echo json_encode($response);
		}		
	}

	public function update_book(){
		$this->form_validation->set_rules('author_id', 'author_id', 'required');
		$this->form_validation->set_rules('book_id', 'book_id', 'required');
		if ($this->form_validation->run() == false) {
            $errors = $this->form_validation->error_array();
            sort($errors);
            $array = array('status' => 400, 'message' => $errors[0]);
            echo json_encode($array);
            exit;
        }

        if(isset($_POST['price'])){
        	$data['price'] = $_POST['price'];
        }

        if(isset($_POST['title'])){
        	$data['title'] = $_POST['title'];
        }

        if(isset($_POST['category_id'])){
        	$data['category_id'] = $_POST['category_id'];
        }

        if(isset($_POST['description'])){
        	$data['description'] = $_POST['description'];
        }

        if(isset($_POST['is_paid'])){
        	$data['is_paid'] = $_POST['is_paid'];
        }
	
		if (isset($_FILES['sample_url']) && !empty($_FILES['sample_url']['name'])) {
            $data['sample_url'] = $this->CRUD_model->imageupload($_FILES['sample_url'], 'sample_url', FCPATH . 'assets/images/book');
        } 
	
		if (isset($_FILES['image']) && !empty($_FILES['image']['name'])) {
            $data['image'] = $this->CRUD_model->imageupload($_FILES['image'], 'image', FCPATH . 'assets/images/book');
        } 

        if (isset($_FILES['full_book']) && !empty($_FILES['full_book']['name'])) {
            $data['url'] = $this->CRUD_model->imageupload($_FILES['full_book'], 'full_book', FCPATH . 'assets/images/book');
        } 

		$result = $this->API_CRUD_model->update($_POST['book_id'], 'id', $data, 'book');

		if($result){
			$response=array('status'=>200,'message'=> $this->lang->line('BOOK_UPDATE'));
			echo json_encode($response);
		}else{
			$response=array('status'=>400,'message'=>$this->lang->line('BOOK_UPDATE_FAIL'));
			echo json_encode($response);
		}		
	}

	public function update_magazine(){		
        $this->form_validation->set_rules('author_id', 'author_id', 'required');
		$this->form_validation->set_rules('magazine_id', 'magazine_id', 'required');

		if ($this->form_validation->run() == false) {
            $errors = $this->form_validation->error_array();
            sort($errors);
            $array = array('status' => 400, 'message' => $errors[0]);
            echo json_encode($array);
            exit;
        }

        if(isset($_POST['price'])){
			$data['price'] = $_POST['price'];
		}

		if(isset($_POST['category_id'])){
			$data['category_id'] = $_POST['category_id'];
		}
		if(isset($_POST['title'])){
			$data['title'] = $_POST['title'];
		}
		if(isset($_POST['description'])){
			$data['description'] = $_POST['description'];
		}
		if(isset($_POST['is_paid'])){
			$data['is_paid'] = $_POST['is_paid'];
		}

		if (isset($_FILES['sample_url']) && !empty($_FILES['sample_url']['name'])) {
            $data['sample_url'] = $this->CRUD_model->imageupload($_FILES['sample_url'], 'sample_url', FCPATH . 'assets/images/magazine');
        } 
	
		if (isset($_FILES['image']) && !empty($_FILES['image']['name'])) {
            $data['image'] = $this->CRUD_model->imageupload($_FILES['image'], 'image', FCPATH . 'assets/images/magazine');
        } 

        if (isset($_FILES['full_magazine']) && !empty($_FILES['full_magazine']['name'])) {
            $data['url'] = $this->CRUD_model->imageupload($_FILES['full_magazine'], 'full_magazine', FCPATH . 'assets/images/magazine');
        }

		$result = $this->API_CRUD_model->update($_POST['magazine_id'], 'id', $data, 'magazine');		

		if($result){
			$response=array('status'=>200,'message'=>$this->lang->line('UPDATE_MAGAZINE_SUCCESS'));
			echo json_encode($response);
		}else{
			$response=array('status'=>400,'message'=>$this->lang->line('UPDATE_MAGAZINE_FAIL'));
			echo json_encode($response);
		}		
	}

	public function update_book_status(){
		$this->form_validation->set_rules('author_id', 'author_id', 'required');
		$this->form_validation->set_rules('book_id', 'book_id', 'required');
		$this->form_validation->set_rules('status', 'status', 'required');
		
		if ($this->form_validation->run() == false) {
            $errors = $this->form_validation->error_array();
            sort($errors);
            $array = array('status' => 400, 'message' => $errors[0]);
            echo json_encode($array);
            exit;
        }

        $data['status']=$_POST['status'];

       	$result = $this->API_CRUD_model->update($_POST['book_id'], 'id', $data, 'book');

        $response=array('status'=>200,'message'=>$this->lang->line('UPDATE_MAGAZINE_FAIL'));
		echo json_encode($response);
	}

	public function update_magazine_status(){
		$this->form_validation->set_rules('author_id', 'author_id', 'required');
		$this->form_validation->set_rules('magazine_id', 'magazine_id', 'required');
		$this->form_validation->set_rules('status', 'status', 'required');

		if ($this->form_validation->run() == false) {
            $errors = $this->form_validation->error_array();
            sort($errors);
            $array = array('status' => 400, 'message' => $errors[0]);
            echo json_encode($array);
            exit;
        }

     	$data['status']=$_POST['status'];
       	$result = $this->API_CRUD_model->update($_POST['magazine_id'], 'id', $data, 'magazine');

        $response=array('status'=>200,'message'=>$this->lang->line('MAGAZINE_STATUS_UPDATE'));
		echo json_encode($response);
	}	
}