<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Subsubcategory extends CI_Controller{

	public function __construct() {
		parent::__construct();
		$CI =& get_instance();
		frontendcheck();
	}

	public function index(){
		$this->load->view("admin/subsubcategory/list");
	}

	public function add(){
		$data['category'] = $this->CRUD_model->get('','category');
		$this->load->view("admin/subsubcategory/add",$data);
	}

	public function save(){
		$this->form_validation->set_rules('name', 'subsubcategory Name', 'required');
        if ($this->form_validation->run() == FALSE)
        {
            $errors = validation_errors();
			$array  = array('status'=>400,'message'=>$errors);
         	echo json_encode($array);exit;
        }
        else
        {
			$name = $_POST['name'];
			$category_id = $_POST['category_id'];
			$sub_category_id = $_POST['sub_category_id'];
			$where='name="'.$name.'"';
			$subsubcategory = $this->CRUD_model->get($where,'subsubcategory');

			if(sizeof($subsubcategory)>0){
				$res=array('status'=>'400','message'=>'subsubcategory name is already exists.');
				echo json_encode($res);exit;	
			}
			
			if(isset($_FILES['image']['name']) && $_FILES['image']['name'] != '')
			{ 
				$subsubcategory_image = $this->CRUD_model->imageupload($_FILES['image'],'image', FCPATH . 'assets/images/subsubcategory');
			}else
			{
				$res=array('status'=>'400','message'=>'Please select subsubcategory image.');
				echo json_encode($res);exit;	
			}

			$data = array(
				'name' => $name,
				'image' => $subsubcategory_image,
				'category_id' =>$category_id,
				'sub_category_id' => $sub_category_id
			);
		
			$id=$this->CRUD_model->insert($data,'subsubcategory');
			$res=array('status'=>'200','message'=>'Sucessfully updated','id'=>$id);
			echo json_encode($res);exit;
		}
	}

	public function edit(){
		$where='id="'.$_GET['id'].'"';
		$data['category'] = $this->CRUD_model->get('','category');
		$data['subsubcategory'] = $this->CRUD_model->getById($where,'subsubcategory');
		
		$subcategory = 'category_id='.$data['subsubcategory']->category_id;
		$data['subcategory'] = $this->CRUD_model->get($subcategory,'subcategory');
		$this->load->view("admin/subsubcategory/edit",$data);
	}

	public function update(){
		$this->form_validation->set_rules('name', 'subsubcategory Name', 'required');
        if ($this->form_validation->run() == FALSE)
        {
            $errors = validation_errors();
			$array  = array('status'=>400,'message'=>$errors);
         	echo json_encode($array);exit;
        }
        else
        {
			$name=$_POST['name'];
			$category_id = $_POST['category_id'];
			$sub_category_id = $_POST['sub_category_id'];
			if (isset($_FILES['image']) && !empty($_FILES['image']['name'])) {
				$subsubcategory_image=$this->CRUD_model->imageupload($_FILES['image'],'image', FCPATH . 'assets/images/subsubcategory');
				
			}else{
				$subsubcategory_image=$_POST['subsubcategoryimage'];	
			}

			$data = array(
				'name' => $name,
				'image' => $subsubcategory_image,
				'category_id' =>$category_id,
				'sub_category_id' =>$sub_category_id,
			);
			
			$cat_id=$this->CRUD_model->update($_POST['id'],'id',$data,'subsubcategory');
			$res=array('status'=>'200','message'=>'Sucessfully updated','id'=>$cat_id);
			echo json_encode($res);exit;
		}
	}

	public function getSubSubCategory()
	{
		if(isset($_POST['sub_category_id']))
		{
			$where = 'sub_category_id='.$_POST['sub_category_id'];
			$subcategory = $this->CRUD_model->get($where,'subsubcategory');
			$result = array('status'=>'200','message'=>'Get subcategory Sucessfully','result'=>$subcategory);
			echo json_encode($result);exit;
		}else
		{
			$res=array('status'=>'400','message'=>'Please select category.');
			echo json_encode($res);exit;
		}
	}

	public function fetch_data(){  

    	$table = "subsubcategory";
	  	$select_column = array("id","image","name", "created_at");  
	  	$order_column = array(null, "image", "name", "created_at");  
	  	$search = array("image","name", "created_at");

       	$fetch_data = $this->CRUD_model->make_datatables($table, $select_column,$order_column,$search);  
       	$data = array();  
       	foreach($fetch_data as $key=> $row)  
       	{  
            $sub_array = array();  
           	$sub_array[] = '<img src="'.base_url().'assets/images/subsubcategory/'.$row->image.'"  width="50" height="35" />';  
            $sub_array[] = string_cut($row->name,15);
            $sub_array[] = dateformate($row->created_at);
            $sub_array[] = '<a href="'.base_url().'admin/subsubcategory/edit?id='.$row->id.'">Edit</a> | <a href="javaScript:void(0)" onclick="delete_record('.$row->id.',\'subsubcategory\')">Delete</a>';
            $data[] = $sub_array;  
       	}
       	$output = array(  
            "draw"             => intval($_POST["draw"]),  
            "recordsTotal"     => $this->CRUD_model->get_all_data($table),  
            "recordsFiltered"  => $this->CRUD_model->get_filtered_data($table,$select_column,$order_column,$search=null),  
            "data"             => $data  
       	);  
       	echo json_encode($output);  
    }
}
