<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Subcategory extends CI_Controller{

	public function __construct() {
		parent::__construct();
		$CI =& get_instance();
		frontendcheck();
	}

	public function index(){
		$this->load->view("admin/subcategory/list");
	}

	public function add(){
		$data['category'] = $this->CRUD_model->get('','category');
		$this->load->view("admin/subcategory/add" ,$data);
	}

	public function save(){
		$this->form_validation->set_rules('name', 'Subcategory Name', 'required');
        if ($this->form_validation->run() == FALSE)
        {
            $errors = validation_errors();
			$array  = array('status'=>400,'message'=>$errors);
         	echo json_encode($array);exit;
        }
        else
        {

			$name = $_POST['name'];
			$category_id = $_POST['category_id'];
			$where='name="'.$name.'"';
			$subcategory = $this->CRUD_model->get($where,'subcategory');

			if(sizeof($subcategory)>0){
				$res=array('status'=>'400','message'=>'subcategory name is already exists.');
				echo json_encode($res);exit;	
			}
			
			if(isset($_FILES['image']['name']) && $_FILES['image']['name'] != '')
			{ 
				$subcategory_image = $this->CRUD_model->imageupload($_FILES['image'],'image', FCPATH . 'assets/images/subcategory');
			}else
			{
				$res=array('status'=>'400','message'=>'Please select subcategory image.');
				echo json_encode($res);exit;	
			}

			$data = array(
				'name' => $name,
				'image' => $subcategory_image,
				'category_id' =>$category_id,
			);
		
			$id=$this->CRUD_model->insert($data,'subcategory');
			$res=array('status'=>'200','message'=>'Sucessfully updated','id'=>$id);
			echo json_encode($res);exit;
		}
	}

	public function edit(){
		$data['category'] = $this->CRUD_model->get('','category');
		$where='id="'.$_GET['id'].'"';
		$data['subcategory'] = $this->CRUD_model->getById($where,'subcategory');
		$this->load->view("admin/subcategory/edit",$data);
	}

	public function update(){
		$this->form_validation->set_rules('name', 'subcategory Name', 'required');
        if ($this->form_validation->run() == FALSE)
        {
            $errors = validation_errors();
			$array  = array('status'=>400,'message'=>$errors);
         	echo json_encode($array);exit;
        }
        else
        {
			$name=$_POST['name'];
			$category_id=$_POST['category_id'];
			if (isset($_FILES['image']) && !empty($_FILES['image']['name'])) {
				$subcategory_image=$this->CRUD_model->imageupload($_FILES['image'],'image', FCPATH . 'assets/images/subcategory');
				
			}else{
				$subcategory_image=$_POST['subcategoryimage'];	
			}

			$data = array(
				'name' => $name,
				'image' => $subcategory_image,
				'category_id' =>$category_id
			);
			
			$cat_id=$this->CRUD_model->update($_POST['id'],'id',$data,'subcategory');
			$res=array('status'=>'200','message'=>'Sucessfully updated','id'=>$cat_id);
			echo json_encode($res);exit;
		}
	}

	
	public function getSubCategory()
	{
		if(isset($_POST['category_id']))
		{
			$where = 'category_id='.$_POST['category_id'];
			$subcategory = $this->CRUD_model->get($where,'subcategory');
			$result = array('status'=>'200','message'=>'Get subcategory Sucessfully','result'=>$subcategory);
			echo json_encode($result);exit;
		}else
		{
			$res=array('status'=>'400','message'=>'Please select category.');
			echo json_encode($res);exit;
		}

	}

	public function fetch_data(){  

    	$table = "subcategory";
	  	$select_column = array("id","image","name", "created_at");  
	  	$order_column = array(null, "image", "name", "created_at");  
	  	$search = array("image","name", "created_at");

       	$fetch_data = $this->CRUD_model->make_datatables($table, $select_column,$order_column,$search);  
       	$data = array();  
       	foreach($fetch_data as $key=> $row)  
       	{  
            $sub_array = array();  
           	$sub_array[] = '<img src="'.base_url().'assets/images/subcategory/'.$row->image.'"  width="50" height="35" />';  
            $sub_array[] = string_cut($row->name,15);
            $sub_array[] = dateformate($row->created_at);
            $sub_array[] = '<a href="'.base_url().'admin/subcategory/edit?id='.$row->id.'">Edit</a> | <a href="javaScript:void(0)" onclick="delete_record('.$row->id.',\'subcategory\')">Delete</a>';
            $data[] = $sub_array;  
       	}
       	$output = array(  
            "draw"             => intval($_POST["draw"]),  
            "recordsTotal"     => $this->CRUD_model->get_all_data($table),  
            "recordsFiltered"  => $this->CRUD_model->get_filtered_data($table,$select_column,$order_column,$search=null),  
            "data"             => $data  
       	);  
       	echo json_encode($output);  
    }
}
