<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Paymentoption extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
    }

    /*====================== payment_option =============================*/
    public function index()
    {
        $this->load->view("admin/payment_option/list");
    }

    public function edit()
    {
        $id = $_GET['id'];
        $where = 'id="' . $id . '"';
        $data['payment_option'] = $this->CRUD_model->getById($where, 'payment_option');

        $this->load->view("admin/payment_option/edit", $data);
    }

    public function update()
    {

        
        $this->form_validation->set_rules('visibility', 'visibility', 'required');
        $this->form_validation->set_rules('is_live', 'is_live', 'required');
        if ($this->form_validation->run() == false) {
            $errors = $this->form_validation->error_array();
            sort($errors);
            $array = array('status' => 400, 'message' => $errors);
            echo json_encode($array);exit;
        } else {

            $id = $_POST['id'];

            $data = array(
                'visibility ' =>$_POST['visibility'],
                'is_live ' =>$_POST['is_live'],
                'live_key_1' => isset($_POST['live_key_1']) ? $_POST['live_key_1'] :'0',
                'live_key_2' => isset($_POST['live_key_2']) ? $_POST['live_key_2'] :'0',
                'live_key_3' => isset($_POST['live_key_3']) ? $_POST['live_key_3'] :'0',
                'test_key_1' => isset($_POST['test_key_1']) ? $_POST['test_key_1'] :'0',
                'test_key_2' => isset($_POST['test_key_2']) ? $_POST['test_key_2'] :'0',               
                'test_key_3' => isset($_POST['test_key_3']) ? $_POST['test_key_3'] :'0',               
            );

            $id = $this->CRUD_model->update($id, 'id', $data, 'payment_option');

            if ($id) {
                $res = array('status' => '200', 'message' => 'Update payment_option success', 'id' => $id);
                echo json_encode($res);exit;
            } else {
                $res = array('status' => '400', 'message' => 'fail');
                echo json_encode($res);exit;
            }
        }
    }
    
    /*======================End payment_option=============================*/

    public function fetch_data()
    {
        $table = "payment_option";
        $select_column = array("id", "name", "visibility",  "is_live", "created_at");
        $order_column = array(null, "name", "visibility", "is_live", "created_at");
        $search = array("name", "visibility",  "is_live", "created_at");

        $fetch_data = $this->CRUD_model->make_datatables($table, $select_column, $order_column, $search);
        $data = array();
        foreach ($fetch_data as $key => $row) {
            $sub_array = array();
           
            $visibility = 'inactive';
            if($row->visibility == 1){
            	$visibility = 'active';
            }

            $is_live = 'Sandbox';
            if($row->is_live == 1){
            	$is_live = 'Live';
            }

            $sub_array[] = $row->name;
            $sub_array[] = $visibility;
            $sub_array[] = $is_live;
            $sub_array[] = '<a href="' . base_url() . 'admin/paymentoption/edit?id=' . $row->id . '" class="btn btn-xs btn-primary p-1" ><i class="fa fa-edit p-1"></i></a> ';
            $data[] = $sub_array;
        }

        $output = array(
            "draw" => intval($_POST["draw"]),
            "recordsTotal" => $this->CRUD_model->get_all_data($table),
            "recordsFiltered" => $this->CRUD_model->get_filtered_data($table, $select_column, $order_column, $search = null),
            "data" => $data,
        );
        echo json_encode($output);
    }
}