<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Package extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
    }

    /*====================== Package =============================*/

    public function index()
    {
        $this->load->view("admin/package/list");
    }

    public function add()
    {
        $this->load->view("admin/package/add");
    }

    public function save()
    {
        $this->form_validation->set_rules('package_name', 'Package Name', 'required');
        $this->form_validation->set_rules('price', 'Price', 'required');
        if ($this->form_validation->run() == false) {
            $errors = $this->form_validation->error_array();
            sort($errors);
            $array = array('status' => 400, 'message' => $errors);
            echo json_encode($array);exit;
        } else {
            $data = $_POST;

            if (isset($_FILES['package_image']['name']) && $_FILES['package_image']['name'] != '') {
                $data['package_image'] = $this->CRUD_model->imageupload($_FILES['package_image'], 'package_image', FCPATH . 'assets/images/package');
            } else {
                $res = array('status' => '400', 'message' => array('Please select package image'));
                echo json_encode($res);exit;
            }

            $id = $this->CRUD_model->insert($data, 'package');

            if ($id) {
                $res = array('status' => '200', 'message' => 'New package create.', 'id' => $id);
                echo json_encode($res);exit;
            } else {
                $res = array('status' => '400', 'message' => 'Package not save ');
                echo json_encode($res);exit;
            }
        }
    }

    public function edit()
    {
        $id = $_GET['id'];
        $where = 'id="' . $id . '"';
        $data['package'] = $this->CRUD_model->getById($where, 'package');

        $this->load->view("admin/package/edit", $data);
    }

    public function update()
    {

        $this->form_validation->set_rules('package_name', 'Package Name', 'required');
        $this->form_validation->set_rules('price', 'Price', 'required');
        if ($this->form_validation->run() == false) {
            $errors = $this->form_validation->error_array();
            sort($errors);
            $array = array('status' => 400, 'message' => $errors);
            echo json_encode($array);exit;
        } else {

            $package_name = isset($_POST['package_name']) ? $_POST['package_name'] : '';
            $price = isset($_POST['price']) ? $_POST['price'] : 0;

            if (isset($_FILES['package_image']) && !empty($_FILES['package_image']['name'])) {

                $package_image = $this->CRUD_model->imageupload($_FILES['package_image'], 'package_image', FCPATH . 'assets/images/package');
            } else {
                $package_image = $_POST['packageimage'];
            }
            $id = $_POST['id'];

            $data = array(
                'package_name' => $package_name,
                'price ' => $price,
                'package_image ' => $package_image,
                'product_package ' => isset($_POST['product_package']) ? $_POST['product_package'] :'',
            );

            $id = $this->CRUD_model->update($id, 'id', $data, 'package');

            if ($id) {
                $res = array('status' => '200', 'message' => 'Update package success', 'id' => $id);
                echo json_encode($res);exit;
            } else {
                $res = array('status' => '400', 'message' => 'fail');
                echo json_encode($res);exit;
            }
        }
    }
    /*======================End Package=============================*/

    public function fetch_data()
    {

        $table = "package";
        $select_column = array("id", "package_name", "price",  "package_image", "created_at");
        $order_column = array(null, "package_name", "price", "package_image", "created_at");
        $search = array("package_name", "price",  "package_image", "created_at");

        $fetch_data = $this->CRUD_model->make_datatables($table, $select_column, $order_column, $search);
        $data = array();
        foreach ($fetch_data as $key => $row) {
            $sub_array = array();
            $sub_array[] = '<img src="' . get_image_path($row->package_image, "package") . '" width="50" height="50" />';

            $sub_array[] = string_cut($row->package_name, 15);
            $sub_array[] = $row->price;
            $sub_array[] = '<a href="' . base_url() . 'admin/package/edit?id=' . $row->id . '" class="btn btn-xs btn-primary p-1" ><i class="fa fa-edit p-1"></i></a>  <a href="javaScript:void(0)" class="btn btn-xs btn-danger p-1" onclick="delete_record(' . $row->id . ',\'package\')"><i class="fa fa-trash p-1"></i></a>';
            $data[] = $sub_array;
        }

        $output = array(
            "draw" => intval($_POST["draw"]),
            "recordsTotal" => $this->CRUD_model->get_all_data($table),
            "recordsFiltered" => $this->CRUD_model->get_filtered_data($table, $select_column, $order_column, $search = null),
            "data" => $data,
        );
        echo json_encode($output);
    }
}