<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Category extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $CI = &get_instance();
        frontendcheck();
    }

    public function index()
    {
        $page_id = 1;
        $config["per_page"] = 12;

        if (isset($_GET['page'])) {
            $page_id = $_GET['page'];
        }
       
        $name = '';
        if (isset($_GET['name'])) {
            $name = $_GET['name'];
        }

        $totla_record = 0;
        $totla_record = count($this->CRUD_model->get_category_list($name));

        $total_pages = 1;
        if ($totla_record > 12) {
            $total_pages = ceil($totla_record / $config["per_page"]);
        }

        $pagination['page'] = $page_id;
        $pagination['total_pages'] = $total_pages;
        $pagination['totla_record'] = $totla_record;
        $pagination['per_page'] = $config["per_page"];

        $data['category'] = $this->CRUD_model->categoryList($config["per_page"], $page_id, $name);
        $data['pagination'] = $pagination;
        
        $this->load->view("admin/category/list", $data);
    }

    public function add()
    {
        $this->load->view("admin/category/add");
    }

    public function save()
    {
        $this->form_validation->set_rules('name', 'Category Name', 'required');
        if ($this->form_validation->run() == false) {
            $errors = validation_errors();
            $array = array('status' => 400, 'message' => $errors);
            echo json_encode($array);exit;
        } else {

            $name = $_POST['name'];
            $where = 'name="' . $name . '"';
            $category = $this->CRUD_model->get($where, 'category');

            if (sizeof($category) > 0) {
                $res = array('status' => '400', 'message' => 'Category name is already exists.');
                echo json_encode($res);exit;
            }

            if (isset($_FILES['image']['name']) && $_FILES['image']['name'] != '') {
                $category_image = $this->CRUD_model->imageupload($_FILES['image'], 'image', FCPATH . 'assets/images/category');
            } else {
                $res = array('status' => '400', 'message' => 'Please select category image.');
                echo json_encode($res);exit;
            }

            $data = array(
                'name' => $name,
                'image' => $category_image,
            );

            $id = $this->CRUD_model->insert($data, 'category');
            $res = array('status' => '200', 'message' => 'Sucessfully updated', 'id' => $id);
            echo json_encode($res);exit;
        }
    }

    public function edit()
    {
        $where = 'id="' . $_GET['id'] . '"';
        $data['category'] = $this->CRUD_model->getById($where, 'category');
        $this->load->view("admin/category/edit", $data);
    }

    public function update()
    {
        $this->form_validation->set_rules('name', 'Category Name', 'required');
        if ($this->form_validation->run() == false) {
            $errors = validation_errors();
            $array = array('status' => 400, 'message' => $errors);
            echo json_encode($array);exit;
        } else {
            $name = $_POST['name'];
            if (isset($_FILES['image']) && !empty($_FILES['image']['name'])) {
                $category_image = $this->CRUD_model->imageupload($_FILES['image'], 'image', FCPATH . 'assets/images/category');

            } else {
                $category_image = $_POST['categoryimage'];
            }

            $data = array(
                'name' => $name,
                'image' => $category_image,
            );

            $cat_id = $this->CRUD_model->update($_POST['id'], 'id', $data, 'category');

            $res = array('status' => '200', 'message' => 'Sucessfully updated', 'id' => $cat_id);
            echo json_encode($res);exit;
        }
    }

    public function getCategory()
    {
        $category = $this->CRUD_model->get('', 'category');
        $result = array('status' => '200', 'message' => 'Get Category Sucessfully', 'result' => $category);
        echo json_encode($result);exit;
    }
}