<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Adsbanner extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $CI = &get_instance();
        frontendcheck();
    }

    public function index()
    {
        $data['ads_bannerlist'] = $this->CRUD_model->get('', 'ads_banner', 'id', 'desc');
        $this->load->view("admin/ads_banner/list", $data);
    }

    public function add()
    {
        $data['book'] = $this->CRUD_model->get('', 'book', 'id', 'desc');
        $this->load->view("admin/ads_banner/add",$data);
    }

    public function save()
    {
        $this->form_validation->set_rules('name', 'Name', 'required');
        $this->form_validation->set_rules('book_id', 'book_id', 'required');

        if ($this->form_validation->run() == false) {
            $errors = $this->form_validation->error_array();
            sort($errors);
            $array = array('status' => 400, 'message' => $errors);
            echo json_encode($array);exit;
        } else {
            $url = isset($_POST['url']) ? $_POST['url'] : '';
            if (isset($_FILES['image']['name']) && $_FILES['image']['name'] != '') {
                $ads_banner_image = $this->CRUD_model->imageupload($_FILES['image'], 'image', FCPATH . 'assets/images/banner');
            } else {
                $res = array('status' => '400', 'message' => array('Please select banner image.'));
                echo json_encode($res);exit;
            }

            $data = array(
                'name' => $_POST['name'],
                'book_id' => $_POST['book_id'],
                'image' => $ads_banner_image,
                'url' => $url,
            );

            $id = $this->CRUD_model->insert($data, 'ads_banner');
            $res = array('status' => '200', 'message' => 'Sucessfully updated', 'id' => $id);
            echo json_encode($res);exit;
        }
    }

    public function edit()
    {
        $data['book'] = $this->CRUD_model->get('', 'book', 'id', 'desc');

        $where = 'id="' . $_GET['id'] . '"';
        $data['ads_banner'] = $this->CRUD_model->getById($where, 'ads_banner');
        $this->load->view("admin/ads_banner/edit", $data);
    }

    public function update()
    {
        $this->form_validation->set_rules('name', 'Banner Name', 'required');
        if ($this->form_validation->run() == false) {
            $errors = $this->form_validation->error_array();
            sort($errors);
            $array = array('status' => 400, 'message' => $errors);
            echo json_encode($array);exit;
        } else {
            $url = isset($_POST['url']) ? $_POST['url'] : '';
            $name = $_POST['name'];
            if (isset($_FILES['image']) && !empty($_FILES['image']['name'])) {
                $ads_banner_image = $this->CRUD_model->imageupload($_FILES['image'], 'image', FCPATH . 'assets/images/banner');

            } else {
                $ads_banner_image = $_POST['ads_bannerimage'];
            }

            $data = array(
                'name' => $name,
                'book_id' => $_POST['book_id'],
                'image' => $ads_banner_image,
                'url' => $url,
            );

            $cat_id = $this->CRUD_model->update($_POST['id'], 'id', $data, 'ads_banner');
           
            $res = array('status' => '200', 'message' => 'Sucessfully updated', 'id' => $cat_id);
            echo json_encode($res);exit;
        }
    }

    public function fetch_data()
    {

        $table = "ads_banner";
        $select_column = array("id", "image", "name");
        $search = array("name");
        $order_column = array(null, "name");

        $fetch_data = $this->CRUD_model->make_datatables($table, $select_column, $order_column, $search);
        $data = array();
        foreach ($fetch_data as $key => $row) {
            $sub_array = array();

            $sub_array[] = '<img src="' . get_image_path($row->image, "banner") . '" width="50" height="50" />';
            $sub_array[] = string_cut($row->name, 15);
            $sub_array[] = '<a href="' . base_url() . 'admin/adsbanner/edit?id=' . $row->id . '" class="btn btn-xs btn-primary p-1" ><i class="fa fa-edit p-1"></i></a>  <a href="javaScript:void(0)" class="btn btn-xs btn-danger p-1" onclick="delete_record(' . $row->id . ',\'ads_banner\')"><i class="fa fa-trash p-1"></i></a>';

            $data[] = $sub_array;
        }
        $output = array(
            "draw" => intval($_POST["draw"]),
            "recordsTotal" => $this->CRUD_model->get_all_data($table),
            "recordsFiltered" => $this->CRUD_model->get_filtered_data($table, $select_column, $order_column, $search = null),
            "data" => $data,
        );
        echo json_encode($output);
    }
}