<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
| my-controller/my-method	-> my_controller/my_method
*/

$route['api/login'] = 'api/user/login';
$route['api/registration'] = 'api/user/registration';
$route['api/profile'] = 'api/user/profile';
$route['api/update_profile'] = 'api/user/update_profile';
$route['api/forgotpassword'] = 'api/user/forgotpassword';
$route['api/earn_point'] = 'api/User/earn_point';
$route['api/loginwithotp'] = 'api/User/loginwithotp';
$route['api/checkStatus'] = 'api/User/checkStatus';
$route['api/get_notification'] = 'api/User/get_notification';
$route['api/read_notification'] = 'api/User/read_notification';
$route['api/get_paymentoption'] = 'api/User/get_paymentoption';


$route['api/add_author'] = 'api/author/add_author';
$route['api/update_author'] = 'api/author/update_author';
$route['api/get_author'] = 'api/author/get_author';
$route['api/add_bank_detail'] = 'api/author/add_bank_detail';
$route['api/update_bank_detail'] = 'api/author/update_bank_detail';
$route['api/get_bank_detail'] = 'api/author/get_bank_detail';

$route['api/upload_book'] = 'api/author/upload_book';
$route['api/upload_magazine'] = 'api/author/upload_magazine';

$route['api/update_book_status'] = 'api/author/update_book_status';
$route['api/update_magazine_status'] = 'api/author/update_magazine_status';

$route['api/update_magazine'] = 'api/author/update_magazine';
$route['api/update_book'] = 'api/author/update_book';


// Home Controller 
$route['api/book_by_category'] = 'api/home/book_by_category';
$route['api/autherlist'] = 'api/home/autherlist';
$route['api/book_by_author'] = 'api/home/book_by_author';
$route['api/readcount_by_author'] = 'api/home/readcount_by_author';
$route['api/booklist'] = 'api/home/booklist';
$route['api/bookdetails'] = 'api/home/bookdetails';
$route['api/popularbooklist'] = 'api/home/popularbooklist';
$route['api/free_paid_booklist'] = 'api/home/free_paid_booklist';
$route['api/related_item'] = 'api/home/related_item';
$route['api/newarriaval'] = 'api/home/newarriaval';
$route['api/feature_item'] = 'api/home/feature_item';
$route['api/add_download'] = 'api/home/add_download';
$route['api/alldownload'] = 'api/home/alldownload';
$route['api/check_coupon_code'] = 'api/home/check_coupon_code';
$route['api/continue_read'] = 'api/home/continue_read';
$route['api/all_bookmark'] = 'api/home/all_bookmark';
$route['api/booksearch'] = 'api/home/booksearch';
$route['api/purchaselist'] = 'api/home/purchaselist';
$route['api/get_transaction'] = 'api/home/get_transaction';
$route['api/alsolike'] = 'api/home/alsolike';

$route['api/getPaymentToken'] = 'api/home/getPaymentToken';
$route['api/getCashfreeToken'] = 'api/home/getCashfreeToken';
// $route['api/magazinelist'] = 'api/home/magazinelist';

// Magazine
$route['api/magazinedetails'] = 'api/Magazine/magazinedetails';
$route['api/add_magazine_rating'] = 'api/Magazine/add_magazine_rating';
$route['api/popular_magazine'] = 'api/Magazine/popularMagazine';
$route['api/top_magazine'] = 'api/Magazine/topMagazine';
$route['api/top_download_magazine'] = 'api/Magazine/topDownloadMagazine';
$route['api/magazine_by_category'] = 'api/Magazine/magazine_by_category';
$route['api/magazinesearch'] = 'api/Magazine/magazinesearch';
$route['api/magazine_by_author'] = 'api/Magazine/magazine_by_author';

// General Controller 
$route['api/add_comment'] = 'api/General/add_comment';
$route['api/view_comment'] = 'api/General/view_comment';
$route['api/categorylist'] = 'api/General/categorylist';
$route['api/general_setting'] = 'api/General/general_setting';
$route['api/add_view'] = 'api/General/add_view';
$route['api/add_continue_read'] = 'api/General/add_continue_read';
$route['api/add_voucher'] = 'api/General/addVoucher';
$route['api/list_voucher'] = 'api/General/listVoucher';
$route['api/add_bookmark'] = 'api/General/add_bookmark';
$route['api/userlist'] = 'api/General/userlist';
$route['api/add_rating'] = 'api/General/add_rating';
$route['api/get_package'] = 'api/General/get_package';
$route['api/get_ads_banner'] = 'api/General/get_ads_banner';
$route['api/checkbookmark'] = 'api/General/checkbookmark';
$route['api/add_transaction'] = 'api/General/add_transaction';
$route['api/add_package_transaction'] = 'api/General/add_package_transaction';
$route['api/get_wallet_transaction'] = 'api/General/get_wallet_transaction';
$route['api/get_book_transaction'] = 'api/General/get_book_transaction';
$route['api/get_magazine_transaction'] = 'api/General/get_magazine_transaction';





$route['page/(:any)'] = 'page/index';
$route['admin'] = 'admin/login';
$route['default_controller'] = 'welcome';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;