/*
 Navicat Premium Data Transfer

 Source Server         : localhost
 Source Server Type    : MySQL
 Source Server Version : 50733
 Source Host           : localhost:3306
 Source Schema         : easy_forms

 Target Server Type    : MySQL
 Target Server Version : 50733
 File Encoding         : 65001

 Date: 02/09/2022 13:01:34
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for addon
-- ----------------------------
DROP TABLE IF EXISTS `addon`;
CREATE TABLE `addon`  (
  `id` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `class` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `version` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `status` tinyint(1) NULL DEFAULT 0,
  `installed` tinyint(1) NULL DEFAULT 0,
  `shared` int(11) NULL DEFAULT 0,
  `created_by` int(11) NULL DEFAULT NULL,
  `updated_by` int(11) NULL DEFAULT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  UNIQUE INDEX `id`(`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of addon
-- ----------------------------

-- ----------------------------
-- Table structure for addon_user
-- ----------------------------
DROP TABLE IF EXISTS `addon_user`;
CREATE TABLE `addon_user`  (
  `addon_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  UNIQUE INDEX `addon_user_addon_id_user_id`(`addon_id`, `user_id`) USING BTREE,
  INDEX `addon_user_addon_id`(`addon_id`) USING BTREE,
  INDEX `addon_user_user_id`(`user_id`) USING BTREE,
  CONSTRAINT `fk_addon_user` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of addon_user
-- ----------------------------

-- ----------------------------
-- Table structure for addon_user_role
-- ----------------------------
DROP TABLE IF EXISTS `addon_user_role`;
CREATE TABLE `addon_user_role`  (
  `addon_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `role_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  UNIQUE INDEX `addon_user_role_addon_id_role_id`(`addon_id`, `role_id`) USING BTREE,
  INDEX `addon_user_role_addon_id`(`addon_id`) USING BTREE,
  INDEX `addon_user_role_role_id`(`role_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of addon_user_role
-- ----------------------------

-- ----------------------------
-- Table structure for auth_assignment
-- ----------------------------
DROP TABLE IF EXISTS `auth_assignment`;
CREATE TABLE `auth_assignment`  (
  `item_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `user_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`item_name`, `user_id`) USING BTREE,
  INDEX `idx-auth_assignment-user_id`(`user_id`) USING BTREE,
  CONSTRAINT `auth_assignment_ibfk_1` FOREIGN KEY (`item_name`) REFERENCES `auth_item` (`name`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of auth_assignment
-- ----------------------------

-- ----------------------------
-- Table structure for auth_item
-- ----------------------------
DROP TABLE IF EXISTS `auth_item`;
CREATE TABLE `auth_item`  (
  `name` varchar(64) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `type` smallint(6) NOT NULL,
  `description` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `rule_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `data` blob NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`name`) USING BTREE,
  INDEX `rule_name`(`rule_name`) USING BTREE,
  INDEX `idx-auth_item-type`(`type`) USING BTREE,
  CONSTRAINT `auth_item_ibfk_1` FOREIGN KEY (`rule_name`) REFERENCES `auth_rule` (`name`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of auth_item
-- ----------------------------
INSERT INTO `auth_item` VALUES ('accessFormReports', 2, 'Access Form Reports', NULL, NULL, 1662141600, 1662141600);
INSERT INTO `auth_item` VALUES ('accessFormStats', 2, 'Access Form Stats', NULL, NULL, 1662141600, 1662141600);
INSERT INTO `auth_item` VALUES ('accessOtherFormReports', 2, 'Access Other Authors\' Form Reports', 'isNotAuthor', NULL, 1662141598, 1662141598);
INSERT INTO `auth_item` VALUES ('accessOtherFormStats', 2, 'Access Other Authors\' Form Stats', 'isNotAuthor', NULL, 1662141598, 1662141598);
INSERT INTO `auth_item` VALUES ('accessOwnFormReports', 2, 'Access Own Form Reports', 'isAuthor', NULL, 1662141596, 1662141596);
INSERT INTO `auth_item` VALUES ('accessOwnFormStats', 2, 'Access Own Form Stats', 'isAuthor', NULL, 1662141597, 1662141597);
INSERT INTO `auth_item` VALUES ('accessPerformanceTools', 2, 'Access Performance Tools', NULL, NULL, 1662141595, 1662141595);
INSERT INTO `auth_item` VALUES ('accessSharedFormReports', 2, 'Access Shared Form Reports', 'isShared', NULL, 1662141597, 1662141597);
INSERT INTO `auth_item` VALUES ('accessSharedFormStats', 2, 'Access Shared Form Stats', 'isShared', NULL, 1662141597, 1662141597);
INSERT INTO `auth_item` VALUES ('administrator', 1, 'Role: Administrator', NULL, NULL, 1662141611, 1662141611);
INSERT INTO `auth_item` VALUES ('assignUserPermissions', 2, 'Assign User Permissions', NULL, NULL, 1662141595, 1662141595);
INSERT INTO `auth_item` VALUES ('blockUsers', 2, 'Block Users', NULL, NULL, 1662141595, 1662141595);
INSERT INTO `auth_item` VALUES ('changeAddonsOwner', 2, 'Change Addons Owner', NULL, NULL, 1662141610, 1662141610);
INSERT INTO `auth_item` VALUES ('changeFormsOwner', 2, 'Change Forms Owner', NULL, NULL, 1662141600, 1662141600);
INSERT INTO `auth_item` VALUES ('changeOtherAddonsOwner', 2, 'Change Other Authors\' Addons Owner', 'isNotAuthor', NULL, 1662141609, 1662141609);
INSERT INTO `auth_item` VALUES ('changeOtherFormsOwner', 2, 'Change Other Authors\' Forms Owner', 'isNotAuthor', NULL, 1662141598, 1662141598);
INSERT INTO `auth_item` VALUES ('changeOtherTemplatesOwner', 2, 'Change Other Authors\' Templates Owner', 'isNotAuthor', NULL, 1662141601, 1662141601);
INSERT INTO `auth_item` VALUES ('changeOtherThemesOwner', 2, 'Change Other Authors\' Themes Owner', 'isNotAuthor', NULL, 1662141604, 1662141604);
INSERT INTO `auth_item` VALUES ('changeOwnAddonsOwner', 2, 'Change Own Addons Owner', 'isAuthor', NULL, 1662141608, 1662141608);
INSERT INTO `auth_item` VALUES ('changeOwnFormsOwner', 2, 'Change Own Forms Owner', 'isAuthor', NULL, 1662141597, 1662141597);
INSERT INTO `auth_item` VALUES ('changeOwnTemplatesOwner', 2, 'Change Own Templates Owner', 'isAuthor', NULL, 1662141601, 1662141601);
INSERT INTO `auth_item` VALUES ('changeOwnThemesOwner', 2, 'Change Own Themes Owner', 'isAuthor', NULL, 1662141603, 1662141603);
INSERT INTO `auth_item` VALUES ('changeSharedAddonsOwner', 2, 'Change Shared Addons Owner', 'isShared', NULL, 1662141609, 1662141609);
INSERT INTO `auth_item` VALUES ('changeSharedFormsOwner', 2, 'Change Shared Forms Owner', 'isShared', NULL, 1662141597, 1662141597);
INSERT INTO `auth_item` VALUES ('changeSharedTemplatesOwner', 2, 'Change Shared Templates Owner', 'isShared', NULL, 1662141601, 1662141601);
INSERT INTO `auth_item` VALUES ('changeSharedThemesOwner', 2, 'Change Shared Themes Owner', 'isShared', NULL, 1662141603, 1662141603);
INSERT INTO `auth_item` VALUES ('changeTemplatesOwner', 2, 'Change Templates Owner', NULL, NULL, 1662141602, 1662141602);
INSERT INTO `auth_item` VALUES ('changeThemesOwner', 2, 'Change Themes Owner', NULL, NULL, 1662141604, 1662141604);
INSERT INTO `auth_item` VALUES ('configureAddons', 2, 'Configure Addons', NULL, NULL, 1662141610, 1662141610);
INSERT INTO `auth_item` VALUES ('configureForms', 2, 'Configure Forms', NULL, NULL, 1662141599, 1662141599);
INSERT INTO `auth_item` VALUES ('configureFormsWithAddons', 2, 'Configure Forms With Add-Ons', NULL, NULL, 1662141599, 1662141599);
INSERT INTO `auth_item` VALUES ('configureMailServer', 2, 'Configure Mail Server', NULL, NULL, 1662141595, 1662141595);
INSERT INTO `auth_item` VALUES ('configureOtherAddons', 2, 'Configure Other Addons', 'isNotAuthor', NULL, 1662141609, 1662141609);
INSERT INTO `auth_item` VALUES ('configureOtherForms', 2, 'Configure Other Authors\' Forms', 'isNotAuthor', NULL, 1662141598, 1662141598);
INSERT INTO `auth_item` VALUES ('configureOtherFormsWithAddons', 2, 'Configure Other Authors\' Forms With Add-Ons', 'isNotAuthor', NULL, 1662141598, 1662141598);
INSERT INTO `auth_item` VALUES ('configureOwnAddons', 2, 'Configure Own Addons', 'isAuthor', NULL, 1662141608, 1662141608);
INSERT INTO `auth_item` VALUES ('configureOwnForms', 2, 'Config Own Forms', 'isAuthor', NULL, 1662141596, 1662141596);
INSERT INTO `auth_item` VALUES ('configureOwnFormsWithAddons', 2, 'Config Own Forms With Addons', 'isAuthor', NULL, 1662141596, 1662141596);
INSERT INTO `auth_item` VALUES ('configureSharedAddons', 2, 'Configure Shared Addons', 'isShared', NULL, 1662141609, 1662141609);
INSERT INTO `auth_item` VALUES ('configureSharedForms', 2, 'Config Shared Forms', 'isShared', NULL, 1662141597, 1662141597);
INSERT INTO `auth_item` VALUES ('configureSharedFormsWithAddons', 2, 'Config Shared Forms With Addons', 'isShared', NULL, 1662141597, 1662141597);
INSERT INTO `auth_item` VALUES ('configureSite', 2, 'Configure Site', NULL, NULL, 1662141594, 1662141594);
INSERT INTO `auth_item` VALUES ('confirmUsers', 2, 'Confirm Users', NULL, NULL, 1662141595, 1662141595);
INSERT INTO `auth_item` VALUES ('copyForms', 2, 'Copy Forms', NULL, NULL, 1662141599, 1662141599);
INSERT INTO `auth_item` VALUES ('copyOtherForms', 2, 'Copy Other Authors\' Forms', 'isNotAuthor', NULL, 1662141598, 1662141598);
INSERT INTO `auth_item` VALUES ('copyOtherTemplates', 2, 'Copy Other Authors\' Templates', 'isNotAuthor', NULL, 1662141601, 1662141601);
INSERT INTO `auth_item` VALUES ('copyOtherThemes', 2, 'Copy Other Authors\' Themes', 'isNotAuthor', NULL, 1662141603, 1662141603);
INSERT INTO `auth_item` VALUES ('copyOwnForms', 2, 'Copy Own Forms', 'isAuthor', NULL, 1662141596, 1662141596);
INSERT INTO `auth_item` VALUES ('copyOwnTemplates', 2, 'Copy Own Templates', 'isAuthor', NULL, 1662141600, 1662141600);
INSERT INTO `auth_item` VALUES ('copyOwnThemes', 2, 'Copy Own Themes', 'isAuthor', NULL, 1662141603, 1662141603);
INSERT INTO `auth_item` VALUES ('copySharedForms', 2, 'Copy Shared Forms', 'isShared', NULL, 1662141597, 1662141597);
INSERT INTO `auth_item` VALUES ('copySharedTemplates', 2, 'Copy Shared Templates', 'isShared', NULL, 1662141601, 1662141601);
INSERT INTO `auth_item` VALUES ('copySharedThemes', 2, 'Copy Shared Themes', 'isShared', NULL, 1662141603, 1662141603);
INSERT INTO `auth_item` VALUES ('copyTemplates', 2, 'Copy Templates', NULL, NULL, 1662141602, 1662141602);
INSERT INTO `auth_item` VALUES ('copyThemes', 2, 'Copy Themes', NULL, NULL, 1662141604, 1662141604);
INSERT INTO `auth_item` VALUES ('createForms', 2, 'Create Forms', NULL, NULL, 1662141598, 1662141598);
INSERT INTO `auth_item` VALUES ('createFormSubmissionComments', 2, 'Create Form Submission Comments', NULL, NULL, 1662141607, 1662141607);
INSERT INTO `auth_item` VALUES ('createFormSubmissions', 2, 'Create Form Submissions', NULL, NULL, 1662141606, 1662141606);
INSERT INTO `auth_item` VALUES ('createOtherFormsSubmissionsComments', 2, 'Create Other Authors\' Forms\' Submissions\' Comments', 'isNotAuthor', NULL, 1662141606, 1662141606);
INSERT INTO `auth_item` VALUES ('createOwnFormsSubmissionsComments', 2, 'Create Own Forms\' Submissions\' Comments', 'isAuthor', NULL, 1662141605, 1662141605);
INSERT INTO `auth_item` VALUES ('createSharedFormsSubmissionsComments', 2, 'Create Shared Forms\' Submissions\' Comments', 'isShared', NULL, 1662141605, 1662141605);
INSERT INTO `auth_item` VALUES ('createTemplates', 2, 'Create Templates', NULL, NULL, 1662141601, 1662141601);
INSERT INTO `auth_item` VALUES ('createThemes', 2, 'Create Themes', NULL, NULL, 1662141604, 1662141604);
INSERT INTO `auth_item` VALUES ('createUsers', 2, 'Create Users', NULL, NULL, 1662141595, 1662141595);
INSERT INTO `auth_item` VALUES ('deleteForms', 2, 'Delete Forms', NULL, NULL, 1662141598, 1662141598);
INSERT INTO `auth_item` VALUES ('deleteFormSubmissionComments', 2, 'Delete Form Submission Comments', NULL, NULL, 1662141607, 1662141607);
INSERT INTO `auth_item` VALUES ('deleteFormSubmissionFiles', 2, 'Delete Form Submission Files', NULL, NULL, 1662141607, 1662141607);
INSERT INTO `auth_item` VALUES ('deleteFormSubmissions', 2, 'Delete Form Submissions', NULL, NULL, 1662141607, 1662141607);
INSERT INTO `auth_item` VALUES ('deleteOtherForms', 2, 'Delete Other Authors\' Forms', 'isNotAuthor', NULL, 1662141598, 1662141598);
INSERT INTO `auth_item` VALUES ('deleteOtherFormsSubmissions', 2, 'Delete Other Authors\' Forms\' Submissions', 'isNotAuthor', NULL, 1662141606, 1662141606);
INSERT INTO `auth_item` VALUES ('deleteOtherFormsSubmissionsComments', 2, 'Delete Other Authors\' Forms\' Submissions\' Comments', 'isNotAuthor', NULL, 1662141606, 1662141606);
INSERT INTO `auth_item` VALUES ('deleteOtherFormsSubmissionsFiles', 2, 'Delete Other Authors\' Forms\' Submissions\' Files', 'isNotAuthor', NULL, 1662141606, 1662141606);
INSERT INTO `auth_item` VALUES ('deleteOtherTemplates', 2, 'Delete Other Authors\' Templates', 'isNotAuthor', NULL, 1662141601, 1662141601);
INSERT INTO `auth_item` VALUES ('deleteOtherThemes', 2, 'Delete Other Authors\' Themes', 'isNotAuthor', NULL, 1662141603, 1662141603);
INSERT INTO `auth_item` VALUES ('deleteOwnForms', 2, 'Delete Own Forms', 'isAuthor', NULL, 1662141596, 1662141596);
INSERT INTO `auth_item` VALUES ('deleteOwnFormsSubmissions', 2, 'Delete Own Forms\' Submissions', 'isAuthor', NULL, 1662141605, 1662141605);
INSERT INTO `auth_item` VALUES ('deleteOwnFormsSubmissionsComments', 2, 'Delete Own Forms\' Submissions\' Comments', 'isAuthor', NULL, 1662141605, 1662141605);
INSERT INTO `auth_item` VALUES ('deleteOwnFormsSubmissionsFiles', 2, 'Delete Own Forms\' Submissions\' Files', 'isAuthor', NULL, 1662141605, 1662141605);
INSERT INTO `auth_item` VALUES ('deleteOwnTemplates', 2, 'Delete Own Templates', 'isAuthor', NULL, 1662141600, 1662141600);
INSERT INTO `auth_item` VALUES ('deleteOwnThemes', 2, 'Delete Own Themes', 'isAuthor', NULL, 1662141603, 1662141603);
INSERT INTO `auth_item` VALUES ('deleteSharedForms', 2, 'Delete Shared Forms', 'isShared', NULL, 1662141597, 1662141597);
INSERT INTO `auth_item` VALUES ('deleteSharedFormsSubmissions', 2, 'Delete Shared Forms\' Submissions', 'isShared', NULL, 1662141605, 1662141605);
INSERT INTO `auth_item` VALUES ('deleteSharedFormsSubmissionsComments', 2, 'Delete Shared Forms\' Submissions\' Comments', 'isShared', NULL, 1662141606, 1662141606);
INSERT INTO `auth_item` VALUES ('deleteSharedFormsSubmissionsFiles', 2, 'Delete Shared Forms\' Submissions\' Files', 'isShared', NULL, 1662141605, 1662141605);
INSERT INTO `auth_item` VALUES ('deleteSharedTemplates', 2, 'Delete Shared Templates', 'isShared', NULL, 1662141601, 1662141601);
INSERT INTO `auth_item` VALUES ('deleteSharedThemes', 2, 'Delete Shared Themes', 'isShared', NULL, 1662141603, 1662141603);
INSERT INTO `auth_item` VALUES ('deleteTemplates', 2, 'Delete Templates', NULL, NULL, 1662141602, 1662141602);
INSERT INTO `auth_item` VALUES ('deleteThemes', 2, 'Delete Themes', NULL, NULL, 1662141604, 1662141604);
INSERT INTO `auth_item` VALUES ('deleteUsers', 2, 'Delete Users', NULL, NULL, 1662141595, 1662141595);
INSERT INTO `auth_item` VALUES ('exportFormSubmissions', 2, 'Export Form Submissions', NULL, NULL, 1662141607, 1662141607);
INSERT INTO `auth_item` VALUES ('exportOtherFormsSubmissions', 2, 'Export Other Authors\' Forms\' Submissions', 'isNotAuthor', NULL, 1662141606, 1662141606);
INSERT INTO `auth_item` VALUES ('exportOwnFormsSubmissions', 2, 'Export Own Forms\' Submissions', 'isAuthor', NULL, 1662141605, 1662141605);
INSERT INTO `auth_item` VALUES ('exportSharedFormsSubmissions', 2, 'Export Shared Forms\' Submissions', 'isShared', NULL, 1662141605, 1662141605);
INSERT INTO `auth_item` VALUES ('forcePasswordChange', 2, 'Force Password Change', NULL, NULL, 1662141596, 1662141596);
INSERT INTO `auth_item` VALUES ('impersonateUsers', 2, 'Impersonate Users', NULL, NULL, 1662141595, 1662141595);
INSERT INTO `auth_item` VALUES ('installAddons', 2, 'Install Addons', NULL, NULL, 1662141610, 1662141610);
INSERT INTO `auth_item` VALUES ('installOtherAddons', 2, 'Install Other Authors\' Addons', 'isNotAuthor', NULL, 1662141609, 1662141609);
INSERT INTO `auth_item` VALUES ('installOwnAddons', 2, 'Install Own Addons', 'isAuthor', NULL, 1662141608, 1662141608);
INSERT INTO `auth_item` VALUES ('installSharedAddons', 2, 'Install Shared Addons', 'isShared', NULL, 1662141608, 1662141608);
INSERT INTO `auth_item` VALUES ('manageAddons', 2, 'Manage Addons', NULL, NULL, 1662141608, 1662141608);
INSERT INTO `auth_item` VALUES ('manageForms', 2, 'Manage Forms', NULL, NULL, 1662141596, 1662141596);
INSERT INTO `auth_item` VALUES ('manageFormSubmissions', 2, 'Manage Submissions', NULL, NULL, 1662141605, 1662141605);
INSERT INTO `auth_item` VALUES ('manageOtherAddons', 2, 'Manage Other Authors\' Addons', NULL, NULL, 1662141609, 1662141609);
INSERT INTO `auth_item` VALUES ('manageOtherForms', 2, 'Manage Other Authors\' Forms', NULL, NULL, 1662141597, 1662141597);
INSERT INTO `auth_item` VALUES ('manageOtherFormsSubmissions', 2, 'Manage Other Authors\' Forms\' Submissions', NULL, NULL, 1662141606, 1662141606);
INSERT INTO `auth_item` VALUES ('manageOtherTemplates', 2, 'Manage Other Authors\' Templates', NULL, NULL, 1662141601, 1662141601);
INSERT INTO `auth_item` VALUES ('manageOtherThemes', 2, 'Manage Other Authors\' Themes', NULL, NULL, 1662141603, 1662141603);
INSERT INTO `auth_item` VALUES ('manageOwnAddons', 2, 'Manage Own Addons', NULL, NULL, 1662141608, 1662141608);
INSERT INTO `auth_item` VALUES ('manageOwnForms', 2, 'Manage Own Forms', NULL, NULL, 1662141596, 1662141596);
INSERT INTO `auth_item` VALUES ('manageOwnFormsSubmissions', 2, 'Manage Own Forms\' Submissions', NULL, NULL, 1662141605, 1662141605);
INSERT INTO `auth_item` VALUES ('manageOwnTemplates', 2, 'Manage Own Templates', NULL, NULL, 1662141600, 1662141600);
INSERT INTO `auth_item` VALUES ('manageOwnThemes', 2, 'Manage Own Themes', NULL, NULL, 1662141602, 1662141602);
INSERT INTO `auth_item` VALUES ('managePermissions', 2, 'Manage Permissions', NULL, NULL, 1662141596, 1662141596);
INSERT INTO `auth_item` VALUES ('manageRoles', 2, 'Manage Roles', NULL, NULL, 1662141596, 1662141596);
INSERT INTO `auth_item` VALUES ('manageRules', 2, 'Manage Rules', NULL, NULL, 1662141596, 1662141596);
INSERT INTO `auth_item` VALUES ('manageSharedAddons', 2, 'Manage Shared Addons', NULL, NULL, 1662141608, 1662141608);
INSERT INTO `auth_item` VALUES ('manageSharedForms', 2, 'Manage Shared Forms', NULL, NULL, 1662141597, 1662141597);
INSERT INTO `auth_item` VALUES ('manageSharedFormsSubmissions', 2, 'Manage Shared Forms\' Submissions', NULL, NULL, 1662141605, 1662141605);
INSERT INTO `auth_item` VALUES ('manageSharedTemplates', 2, 'Manage Shared Templates', NULL, NULL, 1662141601, 1662141601);
INSERT INTO `auth_item` VALUES ('manageSharedThemes', 2, 'Manage Shared Themes', NULL, NULL, 1662141603, 1662141603);
INSERT INTO `auth_item` VALUES ('manageSite', 2, 'Manage Site', NULL, NULL, 1662141594, 1662141594);
INSERT INTO `auth_item` VALUES ('manageTemplateCategories', 2, 'Manage Template Categories', NULL, NULL, 1662141602, 1662141602);
INSERT INTO `auth_item` VALUES ('manageTemplates', 2, 'Manage Templates', NULL, NULL, 1662141600, 1662141600);
INSERT INTO `auth_item` VALUES ('manageThemes', 2, 'Manage Themes', NULL, NULL, 1662141602, 1662141602);
INSERT INTO `auth_item` VALUES ('manageUsers', 2, 'Manage Users', NULL, NULL, 1662141595, 1662141595);
INSERT INTO `auth_item` VALUES ('migrateData', 2, 'Migrate Data (Import / Export Forms)', NULL, NULL, 1662141595, 1662141595);
INSERT INTO `auth_item` VALUES ('performUpdates', 2, 'Perform Application Updates', NULL, NULL, 1662141595, 1662141595);
INSERT INTO `auth_item` VALUES ('publishForms', 2, 'Publish Forms', NULL, NULL, 1662141599, 1662141599);
INSERT INTO `auth_item` VALUES ('publishOtherForms', 2, 'Publish Other Authors\' Forms', 'isNotAuthor', NULL, 1662141598, 1662141598);
INSERT INTO `auth_item` VALUES ('publishOwnForms', 2, 'Publish Own Forms', 'isAuthor', NULL, 1662141596, 1662141596);
INSERT INTO `auth_item` VALUES ('publishSharedForms', 2, 'Publish Shared Forms', 'isShared', NULL, 1662141597, 1662141597);
INSERT INTO `auth_item` VALUES ('refreshAddons', 2, 'Refresh Addons', NULL, NULL, 1662141610, 1662141610);
INSERT INTO `auth_item` VALUES ('refreshOtherAddons', 2, 'Refresh Other Authors\' Addons', 'isNotAuthor', NULL, 1662141609, 1662141609);
INSERT INTO `auth_item` VALUES ('refreshOwnAddons', 2, 'Refresh Own Addons', 'isAuthor', NULL, 1662141608, 1662141608);
INSERT INTO `auth_item` VALUES ('refreshSharedAddons', 2, 'Refresh Shared Addons', 'isShared', NULL, 1662141609, 1662141609);
INSERT INTO `auth_item` VALUES ('resetFormStats', 2, 'Reset Form Stats', NULL, NULL, 1662141600, 1662141600);
INSERT INTO `auth_item` VALUES ('resetOtherFormStats', 2, 'Reset Other Authors\' Form Stats', 'isNotAuthor', NULL, 1662141598, 1662141598);
INSERT INTO `auth_item` VALUES ('resetOwnFormStats', 2, 'Reset Own Form Stats', 'isAuthor', NULL, 1662141597, 1662141597);
INSERT INTO `auth_item` VALUES ('resetSharedFormStats', 2, 'Reset Shared Form Stats', 'isShared', NULL, 1662141597, 1662141597);
INSERT INTO `auth_item` VALUES ('resetUserPasswords', 2, 'Reset User Password', NULL, NULL, 1662141595, 1662141595);
INSERT INTO `auth_item` VALUES ('selectUsers', 2, 'Select Users', NULL, NULL, 1662141596, 1662141596);
INSERT INTO `auth_item` VALUES ('shareAddons', 2, 'Share Addons with Other Users', NULL, NULL, 1662141610, 1662141610);
INSERT INTO `auth_item` VALUES ('shareForms', 2, 'Share Forms with Other Users', NULL, NULL, 1662141599, 1662141599);
INSERT INTO `auth_item` VALUES ('shareOtherAddons', 2, 'Share Other Authors\' Addons', 'isNotAuthor', NULL, 1662141609, 1662141609);
INSERT INTO `auth_item` VALUES ('shareOtherForms', 2, 'Share Other Forms with Other Users', 'isNotAuthor', NULL, 1662141598, 1662141598);
INSERT INTO `auth_item` VALUES ('shareOtherTemplates', 2, 'Share Other Authors\' Templates', 'isNotAuthor', NULL, 1662141601, 1662141601);
INSERT INTO `auth_item` VALUES ('shareOtherThemes', 2, 'Share Other Authors\' Themes', 'isNotAuthor', NULL, 1662141604, 1662141604);
INSERT INTO `auth_item` VALUES ('shareOwnAddons', 2, 'Share Own Addons', 'isAuthor', NULL, 1662141608, 1662141608);
INSERT INTO `auth_item` VALUES ('shareOwnForms', 2, 'Share Own Forms with Other Users', 'isAuthor', NULL, 1662141596, 1662141596);
INSERT INTO `auth_item` VALUES ('shareOwnTemplates', 2, 'Share Own Templates', 'isAuthor', NULL, 1662141600, 1662141600);
INSERT INTO `auth_item` VALUES ('shareOwnThemes', 2, 'Share Own Themes', 'isAuthor', NULL, 1662141603, 1662141603);
INSERT INTO `auth_item` VALUES ('shareSharedAddons', 2, 'Share Shared Addons', 'isShared', NULL, 1662141609, 1662141609);
INSERT INTO `auth_item` VALUES ('shareSharedForms', 2, 'Share Shared Forms with Other Users', 'isShared', NULL, 1662141597, 1662141597);
INSERT INTO `auth_item` VALUES ('shareSharedTemplates', 2, 'Share Shared Templates', 'isShared', NULL, 1662141601, 1662141601);
INSERT INTO `auth_item` VALUES ('shareSharedThemes', 2, 'Share Shared Themes', 'isShared', NULL, 1662141603, 1662141603);
INSERT INTO `auth_item` VALUES ('shareTemplates', 2, 'Share Templates with Other Users', NULL, NULL, 1662141602, 1662141602);
INSERT INTO `auth_item` VALUES ('shareThemes', 2, 'Share Themes with Other Users', NULL, NULL, 1662141604, 1662141604);
INSERT INTO `auth_item` VALUES ('uninstallAddons', 2, 'Uninstall Addons', NULL, NULL, 1662141610, 1662141610);
INSERT INTO `auth_item` VALUES ('uninstallOtherAddons', 2, 'Uninstall Other Authors\' Addons', 'isNotAuthor', NULL, 1662141609, 1662141609);
INSERT INTO `auth_item` VALUES ('uninstallOwnAddons', 2, 'Uninstall Own Addons', 'isAuthor', NULL, 1662141608, 1662141608);
INSERT INTO `auth_item` VALUES ('uninstallSharedAddons', 2, 'Uninstall Shared Addons', 'isShared', NULL, 1662141608, 1662141608);
INSERT INTO `auth_item` VALUES ('updateAddons', 2, 'Update Addons', NULL, NULL, 1662141609, 1662141609);
INSERT INTO `auth_item` VALUES ('updateForms', 2, 'Update Forms', NULL, NULL, 1662141598, 1662141598);
INSERT INTO `auth_item` VALUES ('updateFormSubmissions', 2, 'Update Form Submissions', NULL, NULL, 1662141607, 1662141607);
INSERT INTO `auth_item` VALUES ('updateOtherAddons', 2, 'Update Other Authors\' Addons', 'isNotAuthor', NULL, 1662141609, 1662141609);
INSERT INTO `auth_item` VALUES ('updateOtherForms', 2, 'Update Other Authors\' Forms', 'isNotAuthor', NULL, 1662141598, 1662141598);
INSERT INTO `auth_item` VALUES ('updateOtherFormsSubmissions', 2, 'Update Other Authors\' Forms\' Submissions', 'isNotAuthor', NULL, 1662141606, 1662141606);
INSERT INTO `auth_item` VALUES ('updateOtherTemplates', 2, 'Update Other Authors\' Templates', 'isNotAuthor', NULL, 1662141601, 1662141601);
INSERT INTO `auth_item` VALUES ('updateOtherThemes', 2, 'Update Other Authors\' Themes', 'isNotAuthor', NULL, 1662141603, 1662141603);
INSERT INTO `auth_item` VALUES ('updateOwnAddons', 2, 'Update Own Addons', 'isAuthor', NULL, 1662141608, 1662141608);
INSERT INTO `auth_item` VALUES ('updateOwnForms', 2, 'Update Own Forms', 'isAuthor', NULL, 1662141596, 1662141596);
INSERT INTO `auth_item` VALUES ('updateOwnFormsSubmissions', 2, 'Update Own Forms\' Submissions', 'isAuthor', NULL, 1662141605, 1662141605);
INSERT INTO `auth_item` VALUES ('updateOwnTemplates', 2, 'Update Own Templates', 'isAuthor', NULL, 1662141600, 1662141600);
INSERT INTO `auth_item` VALUES ('updateOwnThemes', 2, 'Update Own Themes', 'isAuthor', NULL, 1662141603, 1662141603);
INSERT INTO `auth_item` VALUES ('updateSharedAddons', 2, 'Update Shared Addons', 'isShared', NULL, 1662141608, 1662141608);
INSERT INTO `auth_item` VALUES ('updateSharedForms', 2, 'Update Shared Forms', 'isShared', NULL, 1662141597, 1662141597);
INSERT INTO `auth_item` VALUES ('updateSharedFormsSubmissions', 2, 'Update Shared Forms\' Submissions', 'isShared', NULL, 1662141605, 1662141605);
INSERT INTO `auth_item` VALUES ('updateSharedTemplates', 2, 'Update Shared Templates', 'isShared', NULL, 1662141601, 1662141601);
INSERT INTO `auth_item` VALUES ('updateSharedThemes', 2, 'Update Shared Themes', 'isShared', NULL, 1662141603, 1662141603);
INSERT INTO `auth_item` VALUES ('updateTemplates', 2, 'Update Templates', NULL, NULL, 1662141602, 1662141602);
INSERT INTO `auth_item` VALUES ('updateThemes', 2, 'Update Themes', NULL, NULL, 1662141604, 1662141604);
INSERT INTO `auth_item` VALUES ('updateUsers', 2, 'Update Users', NULL, NULL, 1662141595, 1662141595);
INSERT INTO `auth_item` VALUES ('user', 1, 'Role: User', NULL, NULL, 1662141611, 1662141611);
INSERT INTO `auth_item` VALUES ('viewAddons', 2, 'View Addons', NULL, NULL, 1662141609, 1662141609);
INSERT INTO `auth_item` VALUES ('viewBulkActionsInAddons', 2, 'View Bulk Actions In Addons', NULL, NULL, 1662141610, 1662141610);
INSERT INTO `auth_item` VALUES ('viewBulkActionsInForms', 2, 'View Bulk Actions In Forms', NULL, NULL, 1662141600, 1662141600);
INSERT INTO `auth_item` VALUES ('viewBulkActionsInFormSubmissions', 2, 'View Bulk Actions In Form Submissions', NULL, NULL, 1662141608, 1662141608);
INSERT INTO `auth_item` VALUES ('viewBulkActionsInTemplates', 2, 'View Bulk Actions In Templates', NULL, NULL, 1662141602, 1662141602);
INSERT INTO `auth_item` VALUES ('viewBulkActionsInThemes', 2, 'View Bulk Actions In Themes', NULL, NULL, 1662141604, 1662141604);
INSERT INTO `auth_item` VALUES ('viewBulkActionsInUsers', 2, 'View Bulk Actions In Users', NULL, NULL, 1662141596, 1662141596);
INSERT INTO `auth_item` VALUES ('viewForms', 2, 'View Forms', NULL, NULL, 1662141598, 1662141598);
INSERT INTO `auth_item` VALUES ('viewFormSubmissionComments', 2, 'View Form Submission Comments', NULL, NULL, 1662141607, 1662141607);
INSERT INTO `auth_item` VALUES ('viewFormSubmissionFiles', 2, 'View Form Submission Files', NULL, NULL, 1662141607, 1662141607);
INSERT INTO `auth_item` VALUES ('viewFormSubmissions', 2, 'View Form Submissions', NULL, NULL, 1662141606, 1662141606);
INSERT INTO `auth_item` VALUES ('viewOtherAddons', 2, 'View Other Authors\' Addons', 'isNotAuthor', NULL, 1662141609, 1662141609);
INSERT INTO `auth_item` VALUES ('viewOtherForms', 2, 'View Other Authors\' Forms', 'isNotAuthor', NULL, 1662141597, 1662141597);
INSERT INTO `auth_item` VALUES ('viewOtherFormsSubmissions', 2, 'View Other Authors\' Forms\' Submissions', 'isNotAuthor', NULL, 1662141606, 1662141606);
INSERT INTO `auth_item` VALUES ('viewOtherFormsSubmissionsComments', 2, 'View Other Authors\' Forms\' Submissions\' Comments', 'isNotAuthor', NULL, 1662141606, 1662141606);
INSERT INTO `auth_item` VALUES ('viewOtherFormsSubmissionsFiles', 2, 'View Other Authors\' Forms\' Submissions\' Files', 'isNotAuthor', NULL, 1662141606, 1662141606);
INSERT INTO `auth_item` VALUES ('viewOtherTemplates', 2, 'View Other Authors\' Templates', 'isNotAuthor', NULL, 1662141601, 1662141601);
INSERT INTO `auth_item` VALUES ('viewOtherThemes', 2, 'View Other Authors\' Themes', 'isNotAuthor', NULL, 1662141603, 1662141603);
INSERT INTO `auth_item` VALUES ('viewOwnAddons', 2, 'View Own Addons', 'isAuthor', NULL, 1662141608, 1662141608);
INSERT INTO `auth_item` VALUES ('viewOwnForms', 2, 'View Own Forms', 'isAuthor', NULL, 1662141596, 1662141596);
INSERT INTO `auth_item` VALUES ('viewOwnFormsSubmissions', 2, 'View Own Forms\' Submissions', 'isAuthor', NULL, 1662141605, 1662141605);
INSERT INTO `auth_item` VALUES ('viewOwnFormsSubmissionsComments', 2, 'View Own Forms\' Submissions\' Comments', 'isAuthor', NULL, 1662141605, 1662141605);
INSERT INTO `auth_item` VALUES ('viewOwnFormsSubmissionsFiles', 2, 'View Own Forms\' Submissions\' Files', 'isAuthor', NULL, 1662141605, 1662141605);
INSERT INTO `auth_item` VALUES ('viewOwnTemplates', 2, 'View Own Templates', 'isAuthor', NULL, 1662141600, 1662141600);
INSERT INTO `auth_item` VALUES ('viewOwnThemes', 2, 'View Own Themes', 'isAuthor', NULL, 1662141602, 1662141602);
INSERT INTO `auth_item` VALUES ('viewSharedAddons', 2, 'View Shared Addons', 'isShared', NULL, 1662141608, 1662141608);
INSERT INTO `auth_item` VALUES ('viewSharedForms', 2, 'View Shared Forms', 'isShared', NULL, 1662141597, 1662141597);
INSERT INTO `auth_item` VALUES ('viewSharedFormsSubmissions', 2, 'View Shared Forms\' Submissions', 'isShared', NULL, 1662141605, 1662141605);
INSERT INTO `auth_item` VALUES ('viewSharedFormsSubmissionsComments', 2, 'View Shared Forms\' Submissions\' Comments', 'isShared', NULL, 1662141605, 1662141605);
INSERT INTO `auth_item` VALUES ('viewSharedFormsSubmissionsFiles', 2, 'View Shared Forms\' Submissions\' Files', 'isShared', NULL, 1662141605, 1662141605);
INSERT INTO `auth_item` VALUES ('viewSharedTemplates', 2, 'View Shared Templates', 'isShared', NULL, 1662141601, 1662141601);
INSERT INTO `auth_item` VALUES ('viewSharedThemes', 2, 'View Shared Themes', 'isShared', NULL, 1662141603, 1662141603);
INSERT INTO `auth_item` VALUES ('viewTemplates', 2, 'View Templates', NULL, NULL, 1662141601, 1662141601);
INSERT INTO `auth_item` VALUES ('viewThemes', 2, 'View Themes', NULL, NULL, 1662141604, 1662141604);
INSERT INTO `auth_item` VALUES ('viewUsers', 2, 'View Users', NULL, NULL, 1662141595, 1662141595);

-- ----------------------------
-- Table structure for auth_item_child
-- ----------------------------
DROP TABLE IF EXISTS `auth_item_child`;
CREATE TABLE `auth_item_child`  (
  `parent` varchar(64) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `child` varchar(64) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`parent`, `child`) USING BTREE,
  INDEX `child`(`child`) USING BTREE,
  CONSTRAINT `auth_item_child_ibfk_1` FOREIGN KEY (`parent`) REFERENCES `auth_item` (`name`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `auth_item_child_ibfk_2` FOREIGN KEY (`child`) REFERENCES `auth_item` (`name`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of auth_item_child
-- ----------------------------
INSERT INTO `auth_item_child` VALUES ('accessOtherFormReports', 'accessFormReports');
INSERT INTO `auth_item_child` VALUES ('accessOwnFormReports', 'accessFormReports');
INSERT INTO `auth_item_child` VALUES ('accessSharedFormReports', 'accessFormReports');
INSERT INTO `auth_item_child` VALUES ('manageForms', 'accessFormReports');
INSERT INTO `auth_item_child` VALUES ('accessOtherFormStats', 'accessFormStats');
INSERT INTO `auth_item_child` VALUES ('accessOwnFormStats', 'accessFormStats');
INSERT INTO `auth_item_child` VALUES ('accessSharedFormStats', 'accessFormStats');
INSERT INTO `auth_item_child` VALUES ('manageForms', 'accessFormStats');
INSERT INTO `auth_item_child` VALUES ('manageOtherForms', 'accessOtherFormReports');
INSERT INTO `auth_item_child` VALUES ('manageOtherForms', 'accessOtherFormStats');
INSERT INTO `auth_item_child` VALUES ('manageOwnForms', 'accessOwnFormReports');
INSERT INTO `auth_item_child` VALUES ('manageOwnForms', 'accessOwnFormStats');
INSERT INTO `auth_item_child` VALUES ('manageSite', 'accessPerformanceTools');
INSERT INTO `auth_item_child` VALUES ('manageSharedForms', 'accessSharedFormReports');
INSERT INTO `auth_item_child` VALUES ('manageSharedForms', 'accessSharedFormStats');
INSERT INTO `auth_item_child` VALUES ('manageUsers', 'assignUserPermissions');
INSERT INTO `auth_item_child` VALUES ('manageUsers', 'blockUsers');
INSERT INTO `auth_item_child` VALUES ('changeOtherAddonsOwner', 'changeAddonsOwner');
INSERT INTO `auth_item_child` VALUES ('changeOwnAddonsOwner', 'changeAddonsOwner');
INSERT INTO `auth_item_child` VALUES ('changeSharedAddonsOwner', 'changeAddonsOwner');
INSERT INTO `auth_item_child` VALUES ('manageAddons', 'changeAddonsOwner');
INSERT INTO `auth_item_child` VALUES ('changeOtherFormsOwner', 'changeFormsOwner');
INSERT INTO `auth_item_child` VALUES ('changeOwnFormsOwner', 'changeFormsOwner');
INSERT INTO `auth_item_child` VALUES ('changeSharedFormsOwner', 'changeFormsOwner');
INSERT INTO `auth_item_child` VALUES ('manageForms', 'changeFormsOwner');
INSERT INTO `auth_item_child` VALUES ('manageOtherAddons', 'changeOtherAddonsOwner');
INSERT INTO `auth_item_child` VALUES ('manageOtherForms', 'changeOtherFormsOwner');
INSERT INTO `auth_item_child` VALUES ('manageOtherTemplates', 'changeOtherTemplatesOwner');
INSERT INTO `auth_item_child` VALUES ('manageOtherThemes', 'changeOtherThemesOwner');
INSERT INTO `auth_item_child` VALUES ('manageOwnAddons', 'changeOwnAddonsOwner');
INSERT INTO `auth_item_child` VALUES ('manageOwnForms', 'changeOwnFormsOwner');
INSERT INTO `auth_item_child` VALUES ('manageOwnTemplates', 'changeOwnTemplatesOwner');
INSERT INTO `auth_item_child` VALUES ('manageOwnThemes', 'changeOwnThemesOwner');
INSERT INTO `auth_item_child` VALUES ('manageSharedAddons', 'changeSharedAddonsOwner');
INSERT INTO `auth_item_child` VALUES ('manageSharedForms', 'changeSharedFormsOwner');
INSERT INTO `auth_item_child` VALUES ('manageSharedTemplates', 'changeSharedTemplatesOwner');
INSERT INTO `auth_item_child` VALUES ('manageSharedThemes', 'changeSharedThemesOwner');
INSERT INTO `auth_item_child` VALUES ('changeOtherTemplatesOwner', 'changeTemplatesOwner');
INSERT INTO `auth_item_child` VALUES ('changeOwnTemplatesOwner', 'changeTemplatesOwner');
INSERT INTO `auth_item_child` VALUES ('changeSharedTemplatesOwner', 'changeTemplatesOwner');
INSERT INTO `auth_item_child` VALUES ('manageTemplates', 'changeTemplatesOwner');
INSERT INTO `auth_item_child` VALUES ('changeOtherThemesOwner', 'changeThemesOwner');
INSERT INTO `auth_item_child` VALUES ('changeOwnThemesOwner', 'changeThemesOwner');
INSERT INTO `auth_item_child` VALUES ('changeSharedThemesOwner', 'changeThemesOwner');
INSERT INTO `auth_item_child` VALUES ('manageThemes', 'changeThemesOwner');
INSERT INTO `auth_item_child` VALUES ('configureOtherAddons', 'configureAddons');
INSERT INTO `auth_item_child` VALUES ('configureOwnAddons', 'configureAddons');
INSERT INTO `auth_item_child` VALUES ('configureSharedAddons', 'configureAddons');
INSERT INTO `auth_item_child` VALUES ('manageAddons', 'configureAddons');
INSERT INTO `auth_item_child` VALUES ('configureOtherForms', 'configureForms');
INSERT INTO `auth_item_child` VALUES ('configureOwnForms', 'configureForms');
INSERT INTO `auth_item_child` VALUES ('configureSharedForms', 'configureForms');
INSERT INTO `auth_item_child` VALUES ('manageForms', 'configureForms');
INSERT INTO `auth_item_child` VALUES ('configureOtherFormsWithAddons', 'configureFormsWithAddons');
INSERT INTO `auth_item_child` VALUES ('configureOwnFormsWithAddons', 'configureFormsWithAddons');
INSERT INTO `auth_item_child` VALUES ('configureSharedFormsWithAddons', 'configureFormsWithAddons');
INSERT INTO `auth_item_child` VALUES ('manageForms', 'configureFormsWithAddons');
INSERT INTO `auth_item_child` VALUES ('manageSite', 'configureMailServer');
INSERT INTO `auth_item_child` VALUES ('manageOtherAddons', 'configureOtherAddons');
INSERT INTO `auth_item_child` VALUES ('manageOtherForms', 'configureOtherForms');
INSERT INTO `auth_item_child` VALUES ('manageOtherForms', 'configureOtherFormsWithAddons');
INSERT INTO `auth_item_child` VALUES ('manageOwnAddons', 'configureOwnAddons');
INSERT INTO `auth_item_child` VALUES ('manageOwnForms', 'configureOwnForms');
INSERT INTO `auth_item_child` VALUES ('manageOwnForms', 'configureOwnFormsWithAddons');
INSERT INTO `auth_item_child` VALUES ('manageSharedAddons', 'configureSharedAddons');
INSERT INTO `auth_item_child` VALUES ('manageSharedForms', 'configureSharedForms');
INSERT INTO `auth_item_child` VALUES ('user', 'configureSharedForms');
INSERT INTO `auth_item_child` VALUES ('manageSharedForms', 'configureSharedFormsWithAddons');
INSERT INTO `auth_item_child` VALUES ('user', 'configureSharedFormsWithAddons');
INSERT INTO `auth_item_child` VALUES ('manageSite', 'configureSite');
INSERT INTO `auth_item_child` VALUES ('manageUsers', 'confirmUsers');
INSERT INTO `auth_item_child` VALUES ('copyOtherForms', 'copyForms');
INSERT INTO `auth_item_child` VALUES ('copyOwnForms', 'copyForms');
INSERT INTO `auth_item_child` VALUES ('copySharedForms', 'copyForms');
INSERT INTO `auth_item_child` VALUES ('manageForms', 'copyForms');
INSERT INTO `auth_item_child` VALUES ('manageOtherForms', 'copyOtherForms');
INSERT INTO `auth_item_child` VALUES ('manageOtherTemplates', 'copyOtherTemplates');
INSERT INTO `auth_item_child` VALUES ('manageOtherThemes', 'copyOtherThemes');
INSERT INTO `auth_item_child` VALUES ('manageOwnForms', 'copyOwnForms');
INSERT INTO `auth_item_child` VALUES ('manageOwnTemplates', 'copyOwnTemplates');
INSERT INTO `auth_item_child` VALUES ('manageOwnThemes', 'copyOwnThemes');
INSERT INTO `auth_item_child` VALUES ('manageSharedForms', 'copySharedForms');
INSERT INTO `auth_item_child` VALUES ('manageSharedTemplates', 'copySharedTemplates');
INSERT INTO `auth_item_child` VALUES ('manageSharedThemes', 'copySharedThemes');
INSERT INTO `auth_item_child` VALUES ('copyOtherTemplates', 'copyTemplates');
INSERT INTO `auth_item_child` VALUES ('copyOwnTemplates', 'copyTemplates');
INSERT INTO `auth_item_child` VALUES ('copySharedTemplates', 'copyTemplates');
INSERT INTO `auth_item_child` VALUES ('manageTemplates', 'copyTemplates');
INSERT INTO `auth_item_child` VALUES ('copyOtherThemes', 'copyThemes');
INSERT INTO `auth_item_child` VALUES ('copyOwnThemes', 'copyThemes');
INSERT INTO `auth_item_child` VALUES ('copySharedThemes', 'copyThemes');
INSERT INTO `auth_item_child` VALUES ('manageThemes', 'copyThemes');
INSERT INTO `auth_item_child` VALUES ('manageForms', 'createForms');
INSERT INTO `auth_item_child` VALUES ('manageOwnForms', 'createForms');
INSERT INTO `auth_item_child` VALUES ('createOtherFormsSubmissionsComments', 'createFormSubmissionComments');
INSERT INTO `auth_item_child` VALUES ('createOwnFormsSubmissionsComments', 'createFormSubmissionComments');
INSERT INTO `auth_item_child` VALUES ('createSharedFormsSubmissionsComments', 'createFormSubmissionComments');
INSERT INTO `auth_item_child` VALUES ('manageFormSubmissions', 'createFormSubmissionComments');
INSERT INTO `auth_item_child` VALUES ('manageFormSubmissions', 'createFormSubmissions');
INSERT INTO `auth_item_child` VALUES ('manageOwnFormsSubmissions', 'createFormSubmissions');
INSERT INTO `auth_item_child` VALUES ('manageOtherFormsSubmissions', 'createOtherFormsSubmissionsComments');
INSERT INTO `auth_item_child` VALUES ('manageOwnFormsSubmissions', 'createOwnFormsSubmissionsComments');
INSERT INTO `auth_item_child` VALUES ('manageSharedFormsSubmissions', 'createSharedFormsSubmissionsComments');
INSERT INTO `auth_item_child` VALUES ('manageOwnTemplates', 'createTemplates');
INSERT INTO `auth_item_child` VALUES ('manageTemplates', 'createTemplates');
INSERT INTO `auth_item_child` VALUES ('manageOwnThemes', 'createThemes');
INSERT INTO `auth_item_child` VALUES ('manageThemes', 'createThemes');
INSERT INTO `auth_item_child` VALUES ('manageUsers', 'createUsers');
INSERT INTO `auth_item_child` VALUES ('deleteOtherForms', 'deleteForms');
INSERT INTO `auth_item_child` VALUES ('deleteOwnForms', 'deleteForms');
INSERT INTO `auth_item_child` VALUES ('deleteSharedForms', 'deleteForms');
INSERT INTO `auth_item_child` VALUES ('manageForms', 'deleteForms');
INSERT INTO `auth_item_child` VALUES ('deleteOtherFormsSubmissionsComments', 'deleteFormSubmissionComments');
INSERT INTO `auth_item_child` VALUES ('deleteOwnFormsSubmissionsComments', 'deleteFormSubmissionComments');
INSERT INTO `auth_item_child` VALUES ('deleteSharedFormsSubmissionsComments', 'deleteFormSubmissionComments');
INSERT INTO `auth_item_child` VALUES ('manageFormSubmissions', 'deleteFormSubmissionComments');
INSERT INTO `auth_item_child` VALUES ('deleteOtherFormsSubmissionsFiles', 'deleteFormSubmissionFiles');
INSERT INTO `auth_item_child` VALUES ('deleteOwnFormsSubmissionsFiles', 'deleteFormSubmissionFiles');
INSERT INTO `auth_item_child` VALUES ('deleteSharedFormsSubmissionsFiles', 'deleteFormSubmissionFiles');
INSERT INTO `auth_item_child` VALUES ('manageFormSubmissions', 'deleteFormSubmissionFiles');
INSERT INTO `auth_item_child` VALUES ('deleteOtherFormsSubmissions', 'deleteFormSubmissions');
INSERT INTO `auth_item_child` VALUES ('deleteOwnFormsSubmissions', 'deleteFormSubmissions');
INSERT INTO `auth_item_child` VALUES ('deleteSharedFormsSubmissions', 'deleteFormSubmissions');
INSERT INTO `auth_item_child` VALUES ('manageFormSubmissions', 'deleteFormSubmissions');
INSERT INTO `auth_item_child` VALUES ('manageOtherForms', 'deleteOtherForms');
INSERT INTO `auth_item_child` VALUES ('manageOtherFormsSubmissions', 'deleteOtherFormsSubmissions');
INSERT INTO `auth_item_child` VALUES ('manageOtherFormsSubmissions', 'deleteOtherFormsSubmissionsComments');
INSERT INTO `auth_item_child` VALUES ('manageOtherFormsSubmissions', 'deleteOtherFormsSubmissionsFiles');
INSERT INTO `auth_item_child` VALUES ('manageOtherTemplates', 'deleteOtherTemplates');
INSERT INTO `auth_item_child` VALUES ('manageOtherThemes', 'deleteOtherThemes');
INSERT INTO `auth_item_child` VALUES ('manageOwnForms', 'deleteOwnForms');
INSERT INTO `auth_item_child` VALUES ('manageOwnFormsSubmissions', 'deleteOwnFormsSubmissions');
INSERT INTO `auth_item_child` VALUES ('manageOwnFormsSubmissions', 'deleteOwnFormsSubmissionsComments');
INSERT INTO `auth_item_child` VALUES ('manageOwnFormsSubmissions', 'deleteOwnFormsSubmissionsFiles');
INSERT INTO `auth_item_child` VALUES ('manageOwnTemplates', 'deleteOwnTemplates');
INSERT INTO `auth_item_child` VALUES ('manageOwnThemes', 'deleteOwnThemes');
INSERT INTO `auth_item_child` VALUES ('manageSharedForms', 'deleteSharedForms');
INSERT INTO `auth_item_child` VALUES ('manageSharedFormsSubmissions', 'deleteSharedFormsSubmissions');
INSERT INTO `auth_item_child` VALUES ('manageSharedFormsSubmissions', 'deleteSharedFormsSubmissionsComments');
INSERT INTO `auth_item_child` VALUES ('manageSharedFormsSubmissions', 'deleteSharedFormsSubmissionsFiles');
INSERT INTO `auth_item_child` VALUES ('manageSharedTemplates', 'deleteSharedTemplates');
INSERT INTO `auth_item_child` VALUES ('manageSharedThemes', 'deleteSharedThemes');
INSERT INTO `auth_item_child` VALUES ('deleteOtherTemplates', 'deleteTemplates');
INSERT INTO `auth_item_child` VALUES ('deleteOwnTemplates', 'deleteTemplates');
INSERT INTO `auth_item_child` VALUES ('deleteSharedTemplates', 'deleteTemplates');
INSERT INTO `auth_item_child` VALUES ('manageTemplates', 'deleteTemplates');
INSERT INTO `auth_item_child` VALUES ('deleteOtherThemes', 'deleteThemes');
INSERT INTO `auth_item_child` VALUES ('deleteOwnThemes', 'deleteThemes');
INSERT INTO `auth_item_child` VALUES ('deleteSharedThemes', 'deleteThemes');
INSERT INTO `auth_item_child` VALUES ('manageThemes', 'deleteThemes');
INSERT INTO `auth_item_child` VALUES ('manageUsers', 'deleteUsers');
INSERT INTO `auth_item_child` VALUES ('exportOtherFormsSubmissions', 'exportFormSubmissions');
INSERT INTO `auth_item_child` VALUES ('exportOwnFormsSubmissions', 'exportFormSubmissions');
INSERT INTO `auth_item_child` VALUES ('exportSharedFormsSubmissions', 'exportFormSubmissions');
INSERT INTO `auth_item_child` VALUES ('manageFormSubmissions', 'exportFormSubmissions');
INSERT INTO `auth_item_child` VALUES ('manageOtherFormsSubmissions', 'exportOtherFormsSubmissions');
INSERT INTO `auth_item_child` VALUES ('manageOwnFormsSubmissions', 'exportOwnFormsSubmissions');
INSERT INTO `auth_item_child` VALUES ('manageSharedFormsSubmissions', 'exportSharedFormsSubmissions');
INSERT INTO `auth_item_child` VALUES ('manageUsers', 'forcePasswordChange');
INSERT INTO `auth_item_child` VALUES ('manageUsers', 'impersonateUsers');
INSERT INTO `auth_item_child` VALUES ('installOtherAddons', 'installAddons');
INSERT INTO `auth_item_child` VALUES ('installOwnAddons', 'installAddons');
INSERT INTO `auth_item_child` VALUES ('installSharedAddons', 'installAddons');
INSERT INTO `auth_item_child` VALUES ('manageAddons', 'installAddons');
INSERT INTO `auth_item_child` VALUES ('manageOtherAddons', 'installOtherAddons');
INSERT INTO `auth_item_child` VALUES ('manageOwnAddons', 'installOwnAddons');
INSERT INTO `auth_item_child` VALUES ('manageSharedAddons', 'installSharedAddons');
INSERT INTO `auth_item_child` VALUES ('administrator', 'manageAddons');
INSERT INTO `auth_item_child` VALUES ('administrator', 'manageForms');
INSERT INTO `auth_item_child` VALUES ('administrator', 'manageFormSubmissions');
INSERT INTO `auth_item_child` VALUES ('manageAddons', 'manageOtherAddons');
INSERT INTO `auth_item_child` VALUES ('manageForms', 'manageOtherForms');
INSERT INTO `auth_item_child` VALUES ('manageFormSubmissions', 'manageOtherFormsSubmissions');
INSERT INTO `auth_item_child` VALUES ('manageTemplates', 'manageOtherTemplates');
INSERT INTO `auth_item_child` VALUES ('manageThemes', 'manageOtherThemes');
INSERT INTO `auth_item_child` VALUES ('manageAddons', 'manageOwnAddons');
INSERT INTO `auth_item_child` VALUES ('manageForms', 'manageOwnForms');
INSERT INTO `auth_item_child` VALUES ('user', 'manageOwnForms');
INSERT INTO `auth_item_child` VALUES ('manageFormSubmissions', 'manageOwnFormsSubmissions');
INSERT INTO `auth_item_child` VALUES ('user', 'manageOwnFormsSubmissions');
INSERT INTO `auth_item_child` VALUES ('manageTemplates', 'manageOwnTemplates');
INSERT INTO `auth_item_child` VALUES ('user', 'manageOwnTemplates');
INSERT INTO `auth_item_child` VALUES ('manageThemes', 'manageOwnThemes');
INSERT INTO `auth_item_child` VALUES ('user', 'manageOwnThemes');
INSERT INTO `auth_item_child` VALUES ('manageUsers', 'managePermissions');
INSERT INTO `auth_item_child` VALUES ('manageUsers', 'manageRoles');
INSERT INTO `auth_item_child` VALUES ('manageUsers', 'manageRules');
INSERT INTO `auth_item_child` VALUES ('manageAddons', 'manageSharedAddons');
INSERT INTO `auth_item_child` VALUES ('manageForms', 'manageSharedForms');
INSERT INTO `auth_item_child` VALUES ('manageFormSubmissions', 'manageSharedFormsSubmissions');
INSERT INTO `auth_item_child` VALUES ('user', 'manageSharedFormsSubmissions');
INSERT INTO `auth_item_child` VALUES ('manageTemplates', 'manageSharedTemplates');
INSERT INTO `auth_item_child` VALUES ('manageThemes', 'manageSharedThemes');
INSERT INTO `auth_item_child` VALUES ('administrator', 'manageSite');
INSERT INTO `auth_item_child` VALUES ('manageTemplates', 'manageTemplateCategories');
INSERT INTO `auth_item_child` VALUES ('administrator', 'manageTemplates');
INSERT INTO `auth_item_child` VALUES ('administrator', 'manageThemes');
INSERT INTO `auth_item_child` VALUES ('administrator', 'manageUsers');
INSERT INTO `auth_item_child` VALUES ('manageSite', 'migrateData');
INSERT INTO `auth_item_child` VALUES ('manageSite', 'performUpdates');
INSERT INTO `auth_item_child` VALUES ('manageForms', 'publishForms');
INSERT INTO `auth_item_child` VALUES ('publishOtherForms', 'publishForms');
INSERT INTO `auth_item_child` VALUES ('publishOwnForms', 'publishForms');
INSERT INTO `auth_item_child` VALUES ('publishSharedForms', 'publishForms');
INSERT INTO `auth_item_child` VALUES ('manageOtherForms', 'publishOtherForms');
INSERT INTO `auth_item_child` VALUES ('manageOwnForms', 'publishOwnForms');
INSERT INTO `auth_item_child` VALUES ('manageSharedForms', 'publishSharedForms');
INSERT INTO `auth_item_child` VALUES ('user', 'publishSharedForms');
INSERT INTO `auth_item_child` VALUES ('manageAddons', 'refreshAddons');
INSERT INTO `auth_item_child` VALUES ('refreshOtherAddons', 'refreshAddons');
INSERT INTO `auth_item_child` VALUES ('refreshOwnAddons', 'refreshAddons');
INSERT INTO `auth_item_child` VALUES ('refreshSharedAddons', 'refreshAddons');
INSERT INTO `auth_item_child` VALUES ('manageOtherAddons', 'refreshOtherAddons');
INSERT INTO `auth_item_child` VALUES ('manageOwnAddons', 'refreshOwnAddons');
INSERT INTO `auth_item_child` VALUES ('manageSharedAddons', 'refreshSharedAddons');
INSERT INTO `auth_item_child` VALUES ('manageForms', 'resetFormStats');
INSERT INTO `auth_item_child` VALUES ('resetOtherFormStats', 'resetFormStats');
INSERT INTO `auth_item_child` VALUES ('resetOwnFormStats', 'resetFormStats');
INSERT INTO `auth_item_child` VALUES ('resetSharedFormStats', 'resetFormStats');
INSERT INTO `auth_item_child` VALUES ('manageOtherForms', 'resetOtherFormStats');
INSERT INTO `auth_item_child` VALUES ('manageOwnForms', 'resetOwnFormStats');
INSERT INTO `auth_item_child` VALUES ('manageSharedForms', 'resetSharedFormStats');
INSERT INTO `auth_item_child` VALUES ('manageUsers', 'resetUserPasswords');
INSERT INTO `auth_item_child` VALUES ('manageUsers', 'selectUsers');
INSERT INTO `auth_item_child` VALUES ('manageAddons', 'shareAddons');
INSERT INTO `auth_item_child` VALUES ('shareOtherAddons', 'shareAddons');
INSERT INTO `auth_item_child` VALUES ('shareOwnAddons', 'shareAddons');
INSERT INTO `auth_item_child` VALUES ('shareSharedAddons', 'shareAddons');
INSERT INTO `auth_item_child` VALUES ('manageForms', 'shareForms');
INSERT INTO `auth_item_child` VALUES ('shareOtherForms', 'shareForms');
INSERT INTO `auth_item_child` VALUES ('shareOwnForms', 'shareForms');
INSERT INTO `auth_item_child` VALUES ('shareSharedForms', 'shareForms');
INSERT INTO `auth_item_child` VALUES ('manageOtherAddons', 'shareOtherAddons');
INSERT INTO `auth_item_child` VALUES ('manageOtherForms', 'shareOtherForms');
INSERT INTO `auth_item_child` VALUES ('manageOtherTemplates', 'shareOtherTemplates');
INSERT INTO `auth_item_child` VALUES ('manageOtherThemes', 'shareOtherThemes');
INSERT INTO `auth_item_child` VALUES ('manageOwnAddons', 'shareOwnAddons');
INSERT INTO `auth_item_child` VALUES ('manageOwnForms', 'shareOwnForms');
INSERT INTO `auth_item_child` VALUES ('manageOwnTemplates', 'shareOwnTemplates');
INSERT INTO `auth_item_child` VALUES ('manageOwnThemes', 'shareOwnThemes');
INSERT INTO `auth_item_child` VALUES ('manageSharedAddons', 'shareSharedAddons');
INSERT INTO `auth_item_child` VALUES ('manageSharedForms', 'shareSharedForms');
INSERT INTO `auth_item_child` VALUES ('manageSharedTemplates', 'shareSharedTemplates');
INSERT INTO `auth_item_child` VALUES ('manageSharedThemes', 'shareSharedThemes');
INSERT INTO `auth_item_child` VALUES ('manageTemplates', 'shareTemplates');
INSERT INTO `auth_item_child` VALUES ('shareOtherTemplates', 'shareTemplates');
INSERT INTO `auth_item_child` VALUES ('shareOwnTemplates', 'shareTemplates');
INSERT INTO `auth_item_child` VALUES ('shareSharedTemplates', 'shareTemplates');
INSERT INTO `auth_item_child` VALUES ('manageThemes', 'shareThemes');
INSERT INTO `auth_item_child` VALUES ('shareOtherThemes', 'shareThemes');
INSERT INTO `auth_item_child` VALUES ('shareOwnThemes', 'shareThemes');
INSERT INTO `auth_item_child` VALUES ('shareSharedThemes', 'shareThemes');
INSERT INTO `auth_item_child` VALUES ('manageAddons', 'uninstallAddons');
INSERT INTO `auth_item_child` VALUES ('uninstallOtherAddons', 'uninstallAddons');
INSERT INTO `auth_item_child` VALUES ('uninstallOwnAddons', 'uninstallAddons');
INSERT INTO `auth_item_child` VALUES ('uninstallSharedAddons', 'uninstallAddons');
INSERT INTO `auth_item_child` VALUES ('manageOtherAddons', 'uninstallOtherAddons');
INSERT INTO `auth_item_child` VALUES ('manageOwnAddons', 'uninstallOwnAddons');
INSERT INTO `auth_item_child` VALUES ('manageSharedAddons', 'uninstallSharedAddons');
INSERT INTO `auth_item_child` VALUES ('manageAddons', 'updateAddons');
INSERT INTO `auth_item_child` VALUES ('updateOtherAddons', 'updateAddons');
INSERT INTO `auth_item_child` VALUES ('updateOwnAddons', 'updateAddons');
INSERT INTO `auth_item_child` VALUES ('updateSharedAddons', 'updateAddons');
INSERT INTO `auth_item_child` VALUES ('manageForms', 'updateForms');
INSERT INTO `auth_item_child` VALUES ('updateOtherForms', 'updateForms');
INSERT INTO `auth_item_child` VALUES ('updateOwnForms', 'updateForms');
INSERT INTO `auth_item_child` VALUES ('updateSharedForms', 'updateForms');
INSERT INTO `auth_item_child` VALUES ('manageFormSubmissions', 'updateFormSubmissions');
INSERT INTO `auth_item_child` VALUES ('updateOtherFormsSubmissions', 'updateFormSubmissions');
INSERT INTO `auth_item_child` VALUES ('updateOwnFormsSubmissions', 'updateFormSubmissions');
INSERT INTO `auth_item_child` VALUES ('updateSharedFormsSubmissions', 'updateFormSubmissions');
INSERT INTO `auth_item_child` VALUES ('manageOtherAddons', 'updateOtherAddons');
INSERT INTO `auth_item_child` VALUES ('manageOtherForms', 'updateOtherForms');
INSERT INTO `auth_item_child` VALUES ('manageOtherFormsSubmissions', 'updateOtherFormsSubmissions');
INSERT INTO `auth_item_child` VALUES ('manageOtherTemplates', 'updateOtherTemplates');
INSERT INTO `auth_item_child` VALUES ('manageOtherThemes', 'updateOtherThemes');
INSERT INTO `auth_item_child` VALUES ('manageOwnAddons', 'updateOwnAddons');
INSERT INTO `auth_item_child` VALUES ('manageOwnForms', 'updateOwnForms');
INSERT INTO `auth_item_child` VALUES ('manageOwnFormsSubmissions', 'updateOwnFormsSubmissions');
INSERT INTO `auth_item_child` VALUES ('manageOwnTemplates', 'updateOwnTemplates');
INSERT INTO `auth_item_child` VALUES ('manageOwnThemes', 'updateOwnThemes');
INSERT INTO `auth_item_child` VALUES ('manageSharedAddons', 'updateSharedAddons');
INSERT INTO `auth_item_child` VALUES ('manageSharedForms', 'updateSharedForms');
INSERT INTO `auth_item_child` VALUES ('user', 'updateSharedForms');
INSERT INTO `auth_item_child` VALUES ('manageSharedFormsSubmissions', 'updateSharedFormsSubmissions');
INSERT INTO `auth_item_child` VALUES ('manageSharedTemplates', 'updateSharedTemplates');
INSERT INTO `auth_item_child` VALUES ('manageSharedThemes', 'updateSharedThemes');
INSERT INTO `auth_item_child` VALUES ('manageTemplates', 'updateTemplates');
INSERT INTO `auth_item_child` VALUES ('updateOtherTemplates', 'updateTemplates');
INSERT INTO `auth_item_child` VALUES ('updateOwnTemplates', 'updateTemplates');
INSERT INTO `auth_item_child` VALUES ('updateSharedTemplates', 'updateTemplates');
INSERT INTO `auth_item_child` VALUES ('manageThemes', 'updateThemes');
INSERT INTO `auth_item_child` VALUES ('updateOtherThemes', 'updateThemes');
INSERT INTO `auth_item_child` VALUES ('updateOwnThemes', 'updateThemes');
INSERT INTO `auth_item_child` VALUES ('updateSharedThemes', 'updateThemes');
INSERT INTO `auth_item_child` VALUES ('manageUsers', 'updateUsers');
INSERT INTO `auth_item_child` VALUES ('manageAddons', 'viewAddons');
INSERT INTO `auth_item_child` VALUES ('viewOtherAddons', 'viewAddons');
INSERT INTO `auth_item_child` VALUES ('viewOwnAddons', 'viewAddons');
INSERT INTO `auth_item_child` VALUES ('viewSharedAddons', 'viewAddons');
INSERT INTO `auth_item_child` VALUES ('manageAddons', 'viewBulkActionsInAddons');
INSERT INTO `auth_item_child` VALUES ('manageForms', 'viewBulkActionsInForms');
INSERT INTO `auth_item_child` VALUES ('manageFormSubmissions', 'viewBulkActionsInFormSubmissions');
INSERT INTO `auth_item_child` VALUES ('manageTemplates', 'viewBulkActionsInTemplates');
INSERT INTO `auth_item_child` VALUES ('manageThemes', 'viewBulkActionsInThemes');
INSERT INTO `auth_item_child` VALUES ('manageUsers', 'viewBulkActionsInUsers');
INSERT INTO `auth_item_child` VALUES ('manageForms', 'viewForms');
INSERT INTO `auth_item_child` VALUES ('viewOtherForms', 'viewForms');
INSERT INTO `auth_item_child` VALUES ('viewOwnForms', 'viewForms');
INSERT INTO `auth_item_child` VALUES ('viewSharedForms', 'viewForms');
INSERT INTO `auth_item_child` VALUES ('manageFormSubmissions', 'viewFormSubmissionComments');
INSERT INTO `auth_item_child` VALUES ('viewOtherFormsSubmissionsComments', 'viewFormSubmissionComments');
INSERT INTO `auth_item_child` VALUES ('viewOwnFormsSubmissionsComments', 'viewFormSubmissionComments');
INSERT INTO `auth_item_child` VALUES ('viewSharedFormsSubmissionsComments', 'viewFormSubmissionComments');
INSERT INTO `auth_item_child` VALUES ('manageFormSubmissions', 'viewFormSubmissionFiles');
INSERT INTO `auth_item_child` VALUES ('viewOtherFormsSubmissionsFiles', 'viewFormSubmissionFiles');
INSERT INTO `auth_item_child` VALUES ('viewOwnFormsSubmissionsFiles', 'viewFormSubmissionFiles');
INSERT INTO `auth_item_child` VALUES ('viewSharedFormsSubmissionsFiles', 'viewFormSubmissionFiles');
INSERT INTO `auth_item_child` VALUES ('manageFormSubmissions', 'viewFormSubmissions');
INSERT INTO `auth_item_child` VALUES ('viewOtherFormsSubmissions', 'viewFormSubmissions');
INSERT INTO `auth_item_child` VALUES ('viewOwnFormsSubmissions', 'viewFormSubmissions');
INSERT INTO `auth_item_child` VALUES ('viewSharedFormsSubmissions', 'viewFormSubmissions');
INSERT INTO `auth_item_child` VALUES ('manageOtherAddons', 'viewOtherAddons');
INSERT INTO `auth_item_child` VALUES ('manageOtherForms', 'viewOtherForms');
INSERT INTO `auth_item_child` VALUES ('manageOtherFormsSubmissions', 'viewOtherFormsSubmissions');
INSERT INTO `auth_item_child` VALUES ('manageOtherFormsSubmissions', 'viewOtherFormsSubmissionsComments');
INSERT INTO `auth_item_child` VALUES ('manageOtherFormsSubmissions', 'viewOtherFormsSubmissionsFiles');
INSERT INTO `auth_item_child` VALUES ('manageOtherTemplates', 'viewOtherTemplates');
INSERT INTO `auth_item_child` VALUES ('manageOtherThemes', 'viewOtherThemes');
INSERT INTO `auth_item_child` VALUES ('manageOwnAddons', 'viewOwnAddons');
INSERT INTO `auth_item_child` VALUES ('manageOwnForms', 'viewOwnForms');
INSERT INTO `auth_item_child` VALUES ('manageOwnFormsSubmissions', 'viewOwnFormsSubmissions');
INSERT INTO `auth_item_child` VALUES ('manageOwnFormsSubmissions', 'viewOwnFormsSubmissionsComments');
INSERT INTO `auth_item_child` VALUES ('manageOwnFormsSubmissions', 'viewOwnFormsSubmissionsFiles');
INSERT INTO `auth_item_child` VALUES ('manageOwnTemplates', 'viewOwnTemplates');
INSERT INTO `auth_item_child` VALUES ('manageOwnThemes', 'viewOwnThemes');
INSERT INTO `auth_item_child` VALUES ('manageSharedAddons', 'viewSharedAddons');
INSERT INTO `auth_item_child` VALUES ('user', 'viewSharedAddons');
INSERT INTO `auth_item_child` VALUES ('manageSharedForms', 'viewSharedForms');
INSERT INTO `auth_item_child` VALUES ('user', 'viewSharedForms');
INSERT INTO `auth_item_child` VALUES ('manageSharedFormsSubmissions', 'viewSharedFormsSubmissions');
INSERT INTO `auth_item_child` VALUES ('manageSharedFormsSubmissions', 'viewSharedFormsSubmissionsComments');
INSERT INTO `auth_item_child` VALUES ('manageSharedFormsSubmissions', 'viewSharedFormsSubmissionsFiles');
INSERT INTO `auth_item_child` VALUES ('manageSharedTemplates', 'viewSharedTemplates');
INSERT INTO `auth_item_child` VALUES ('user', 'viewSharedTemplates');
INSERT INTO `auth_item_child` VALUES ('manageSharedThemes', 'viewSharedThemes');
INSERT INTO `auth_item_child` VALUES ('user', 'viewSharedThemes');
INSERT INTO `auth_item_child` VALUES ('manageTemplates', 'viewTemplates');
INSERT INTO `auth_item_child` VALUES ('viewOtherTemplates', 'viewTemplates');
INSERT INTO `auth_item_child` VALUES ('viewOwnTemplates', 'viewTemplates');
INSERT INTO `auth_item_child` VALUES ('viewSharedTemplates', 'viewTemplates');
INSERT INTO `auth_item_child` VALUES ('manageThemes', 'viewThemes');
INSERT INTO `auth_item_child` VALUES ('viewOtherThemes', 'viewThemes');
INSERT INTO `auth_item_child` VALUES ('viewOwnThemes', 'viewThemes');
INSERT INTO `auth_item_child` VALUES ('viewSharedThemes', 'viewThemes');
INSERT INTO `auth_item_child` VALUES ('manageUsers', 'viewUsers');

-- ----------------------------
-- Table structure for auth_rule
-- ----------------------------
DROP TABLE IF EXISTS `auth_rule`;
CREATE TABLE `auth_rule`  (
  `name` varchar(64) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `data` blob NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`name`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of auth_rule
-- ----------------------------
INSERT INTO `auth_rule` VALUES ('isAuthor', 0x4F3A33363A226170705C636F6D706F6E656E74735C726261635C72756C65735C417574686F7252756C65223A333A7B733A343A226E616D65223B733A383A226973417574686F72223B733A393A22637265617465644174223B693A313636323134313539343B733A393A22757064617465644174223B693A313636323134313539343B7D, 1662141594, 1662141594);
INSERT INTO `auth_rule` VALUES ('isNotAuthor', 0x4F3A33393A226170705C636F6D706F6E656E74735C726261635C72756C65735C4E6F74417574686F7252756C65223A333A7B733A343A226E616D65223B733A31313A2269734E6F74417574686F72223B733A393A22637265617465644174223B693A313636323134313539343B733A393A22757064617465644174223B693A313636323134313539343B7D, 1662141594, 1662141594);
INSERT INTO `auth_rule` VALUES ('isShared', 0x4F3A33363A226170705C636F6D706F6E656E74735C726261635C72756C65735C53686172656452756C65223A333A7B733A343A226E616D65223B733A383A226973536861726564223B733A393A22637265617465644174223B693A313636323134313539343B733A393A22757064617465644174223B693A313636323134313539343B7D, 1662141594, 1662141594);

-- ----------------------------
-- Table structure for event
-- ----------------------------
DROP TABLE IF EXISTS `event`;
CREATE TABLE `event`  (
  `app_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `platform` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `etl_tstamp` int(11) NULL DEFAULT NULL,
  `collector_tstamp` int(11) NOT NULL,
  `dvce_tstamp` bigint(20) NULL DEFAULT NULL,
  `event` varchar(128) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `event_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `txn_id` int(11) NULL DEFAULT NULL,
  `name_tracker` varchar(128) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `v_tracker` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `v_collector` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `v_etl` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `user_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `user_ipaddress` varchar(45) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `user_fingerprint` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `domain_userid` varchar(36) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `domain_sessionidx` smallint(6) NULL DEFAULT NULL,
  `network_userid` varchar(38) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `geo_country` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `geo_region` varchar(3) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `geo_city` varchar(75) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `geo_zipcode` varchar(15) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `geo_latitude` double NULL DEFAULT NULL,
  `geo_longitude` double NULL DEFAULT NULL,
  `geo_region_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `page_url` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `page_title` varchar(2000) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `page_referrer` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `page_urlscheme` varchar(16) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `page_urlhost` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `page_urlport` int(11) NULL DEFAULT NULL,
  `page_urlpath` varchar(1000) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `page_urlquery` varchar(1000) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `page_urlfragment` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `refr_urlscheme` varchar(16) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `refr_urlhost` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `refr_urlport` int(11) NULL DEFAULT NULL,
  `refr_urlpath` varchar(1000) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `refr_urlquery` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `refr_urlfragment` varchar(1000) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `refr_medium` varchar(25) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `refr_source` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `refr_term` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `mkt_medium` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `mkt_source` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `mkt_term` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `mkt_content` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `mkt_campaign` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `contexts` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `se_category` varchar(1000) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `se_action` varchar(1000) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `se_label` varchar(1000) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `se_property` varchar(1000) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `se_value` double NULL DEFAULT NULL,
  `unstruct_event` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `tr_orderid` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `tr_affiliation` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `tr_total` decimal(18, 2) NULL DEFAULT NULL,
  `tr_tax` decimal(18, 2) NULL DEFAULT NULL,
  `tr_shipping` decimal(18, 2) NULL DEFAULT NULL,
  `tr_city` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `tr_state` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `tr_country` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `ti_orderid` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `ti_sku` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `ti_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `ti_category` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `ti_price` decimal(18, 2) NULL DEFAULT NULL,
  `ti_quantity` int(11) NULL DEFAULT NULL,
  `pp_xoffset_min` int(11) NULL DEFAULT NULL,
  `pp_xoffset_max` int(11) NULL DEFAULT NULL,
  `pp_yoffset_min` int(11) NULL DEFAULT NULL,
  `pp_yoffset_max` int(11) NULL DEFAULT NULL,
  `useragent` varchar(1000) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `br_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `br_family` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `br_version` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `br_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `br_renderengine` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `br_lang` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `br_features_pdf` tinyint(1) NULL DEFAULT NULL,
  `br_features_flash` tinyint(1) NULL DEFAULT NULL,
  `br_features_java` tinyint(1) NULL DEFAULT NULL,
  `br_features_director` tinyint(1) NULL DEFAULT NULL,
  `br_features_quicktime` tinyint(1) NULL DEFAULT NULL,
  `br_features_realplayer` tinyint(1) NULL DEFAULT NULL,
  `br_features_windowsmedia` tinyint(1) NULL DEFAULT NULL,
  `br_features_gears` tinyint(1) NULL DEFAULT NULL,
  `br_features_silverlight` tinyint(1) NULL DEFAULT NULL,
  `br_cookies` tinyint(1) NULL DEFAULT NULL,
  `br_colordepth` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `br_viewwidth` int(11) NULL DEFAULT NULL,
  `br_viewheight` int(11) NULL DEFAULT NULL,
  `os_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `os_family` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `os_manufacturer` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `os_timezone` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `dvce_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `dvce_ismobile` tinyint(1) NULL DEFAULT NULL,
  `dvce_screenwidth` int(11) NULL DEFAULT NULL,
  `dvce_screenheight` int(11) NULL DEFAULT NULL,
  `doc_charset` varchar(128) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `doc_width` int(11) NULL DEFAULT NULL,
  `doc_height` int(11) NULL DEFAULT NULL,
  `geo_timezone` varchar(64) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `mkt_clickid` varchar(128) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `mkt_network` varchar(128) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `etl_tags` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `dvce_sent_tstamp` bigint(20) NULL DEFAULT NULL,
  `domain_sessionid` varchar(36) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of event
-- ----------------------------

-- ----------------------------
-- Table structure for folder
-- ----------------------------
DROP TABLE IF EXISTS `folder`;
CREATE TABLE `folder`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `description` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_by` int(11) NULL DEFAULT NULL,
  `updated_by` int(11) NULL DEFAULT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of folder
-- ----------------------------

-- ----------------------------
-- Table structure for form
-- ----------------------------
DROP TABLE IF EXISTS `form`;
CREATE TABLE `form`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `slug` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `is_private` tinyint(1) NULL DEFAULT 0,
  `use_password` tinyint(1) NOT NULL DEFAULT 0,
  `password` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `authorized_urls` tinyint(1) NOT NULL DEFAULT 0,
  `urls` varchar(2555) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `schedule` tinyint(1) NOT NULL DEFAULT 0,
  `schedule_start_date` int(11) NULL DEFAULT NULL,
  `schedule_end_date` int(11) NULL DEFAULT NULL,
  `total_limit` tinyint(1) NOT NULL DEFAULT 0,
  `total_limit_number` int(11) NULL DEFAULT NULL,
  `total_limit_time_unit` varchar(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `total_limit_action` tinyint(1) NULL DEFAULT 0,
  `user_limit` tinyint(1) NOT NULL DEFAULT 0,
  `user_limit_type` tinyint(1) NULL DEFAULT NULL,
  `submission_scope` tinyint(1) NULL DEFAULT 0,
  `user_limit_number` int(11) NULL DEFAULT NULL,
  `user_limit_time_unit` varchar(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `submission_number` int(11) NULL DEFAULT 1,
  `submission_number_prefix` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `submission_number_suffix` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `submission_number_width` int(11) NULL DEFAULT NULL,
  `submission_editable` tinyint(1) NULL DEFAULT 0,
  `submission_editable_time_length` int(11) NULL DEFAULT NULL,
  `submission_editable_time_unit` varchar(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `submission_timezone` varchar(45) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `submission_dateformat` varchar(45) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `submission_editable_conditions` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `save` tinyint(1) NOT NULL DEFAULT 1,
  `resume` tinyint(1) NOT NULL DEFAULT 0,
  `autocomplete` tinyint(1) NOT NULL DEFAULT 1,
  `novalidate` tinyint(1) NOT NULL DEFAULT 0,
  `analytics` tinyint(1) NOT NULL DEFAULT 1,
  `honeypot` tinyint(1) NOT NULL DEFAULT 1,
  `recaptcha` tinyint(1) NOT NULL DEFAULT 0,
  `protected_files` tinyint(1) NULL DEFAULT 0,
  `ip_tracking` tinyint(1) NULL DEFAULT 1,
  `browser_fingerprint` tinyint(1) NULL DEFAULT 1,
  `shared` int(11) NULL DEFAULT 0,
  `language` varchar(5) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'en-US',
  `text_direction` varchar(3) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT 'ltr',
  `message` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `created_by` int(11) NOT NULL,
  `updated_by` int(11) NOT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of form
-- ----------------------------

-- ----------------------------
-- Table structure for form_chart
-- ----------------------------
DROP TABLE IF EXISTS `form_chart`;
CREATE TABLE `form_chart`  (
  `form_id` int(11) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `label` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `title` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `width` int(11) NULL DEFAULT NULL,
  `height` int(11) NULL DEFAULT NULL,
  `gsX` int(11) NULL DEFAULT NULL,
  `gsY` int(11) NULL DEFAULT NULL,
  `gsW` int(11) NULL DEFAULT NULL,
  `gsH` int(11) NULL DEFAULT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  UNIQUE INDEX `form_chart_form_id_name`(`form_id`, `name`) USING BTREE,
  INDEX `form_chart_form_id`(`form_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of form_chart
-- ----------------------------

-- ----------------------------
-- Table structure for form_confirmation
-- ----------------------------
DROP TABLE IF EXISTS `form_confirmation`;
CREATE TABLE `form_confirmation`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_id` int(11) NOT NULL,
  `type` int(1) NOT NULL DEFAULT 0,
  `message` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `url` varchar(2555) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `append` int(11) NOT NULL DEFAULT 0,
  `alias` int(11) NOT NULL DEFAULT 0,
  `seconds` int(11) NULL DEFAULT NULL,
  `send_email` tinyint(1) NOT NULL DEFAULT 0,
  `mail_to` varchar(2555) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `mail_from` varchar(2555) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `mail_cc` varchar(2555) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `mail_bcc` varchar(2555) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `mail_subject` varchar(2555) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `mail_message` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `mail_from_name` varchar(2555) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `mail_receipt_copy` tinyint(1) NULL DEFAULT 0,
  `mail_attach` int(11) NOT NULL DEFAULT 1,
  `mail_attachments` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `opt_in` int(11) NULL DEFAULT NULL,
  `opt_in_type` int(11) NULL DEFAULT 0,
  `opt_in_message` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `opt_in_url` varchar(2555) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `opt_out` int(11) NULL DEFAULT NULL,
  `opt_out_type` int(11) NULL DEFAULT 0,
  `opt_out_message` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `opt_out_url` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `form_confirmation_form_id`(`form_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of form_confirmation
-- ----------------------------

-- ----------------------------
-- Table structure for form_confirmation_rule
-- ----------------------------
DROP TABLE IF EXISTS `form_confirmation_rule`;
CREATE TABLE `form_confirmation_rule`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_id` int(11) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `conditions` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `action` int(1) NOT NULL DEFAULT 0,
  `message` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `url` varchar(2555) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `append` int(1) NOT NULL DEFAULT 0,
  `alias` int(1) NOT NULL DEFAULT 0,
  `seconds` int(1) NULL DEFAULT NULL,
  `created_by` int(11) NULL DEFAULT NULL,
  `updated_by` int(11) NULL DEFAULT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of form_confirmation_rule
-- ----------------------------

-- ----------------------------
-- Table structure for form_data
-- ----------------------------
DROP TABLE IF EXISTS `form_data`;
CREATE TABLE `form_data`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_id` int(11) NOT NULL,
  `builder` mediumtext CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `fields` mediumtext CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `html` mediumtext CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `height` int(5) NOT NULL,
  `version` varchar(10) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `form_data_form_id`(`form_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of form_data
-- ----------------------------

-- ----------------------------
-- Table structure for form_email
-- ----------------------------
DROP TABLE IF EXISTS `form_email`;
CREATE TABLE `form_email`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_id` int(11) NOT NULL,
  `field_to` varchar(2555) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `to` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `from` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `from_name` varchar(2555) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `cc` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `bcc` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `subject` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `type` int(1) NOT NULL DEFAULT 0,
  `message` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `plain_text` tinyint(1) NOT NULL DEFAULT 0,
  `attach` tinyint(1) NOT NULL DEFAULT 1,
  `receipt_copy` int(11) NOT NULL DEFAULT 0,
  `event` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `conditions` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `form_email_form_id`(`form_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of form_email
-- ----------------------------

-- ----------------------------
-- Table structure for form_folder
-- ----------------------------
DROP TABLE IF EXISTS `form_folder`;
CREATE TABLE `form_folder`  (
  `form_id` int(11) NULL DEFAULT NULL,
  `folder_id` int(11) NULL DEFAULT NULL,
  `created_by` int(11) NULL DEFAULT NULL,
  `updated_by` int(11) NULL DEFAULT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  UNIQUE INDEX `form_folder_form_id_folder_id`(`form_id`, `folder_id`) USING BTREE,
  INDEX `form_folder_form_id`(`form_id`) USING BTREE,
  INDEX `form_folder_folder_id`(`folder_id`) USING BTREE,
  CONSTRAINT `fk_form_folder` FOREIGN KEY (`form_id`) REFERENCES `form` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of form_folder
-- ----------------------------

-- ----------------------------
-- Table structure for form_rule
-- ----------------------------
DROP TABLE IF EXISTS `form_rule`;
CREATE TABLE `form_rule`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_id` int(11) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `opposite` tinyint(1) NOT NULL DEFAULT 1,
  `ordinal` int(11) NOT NULL DEFAULT 0,
  `conditions` mediumtext CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `actions` mediumtext CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `form_rule_form_id`(`form_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of form_rule
-- ----------------------------

-- ----------------------------
-- Table structure for form_submission
-- ----------------------------
DROP TABLE IF EXISTS `form_submission`;
CREATE TABLE `form_submission`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_id` int(11) NOT NULL,
  `number` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `new` tinyint(1) NOT NULL DEFAULT 1,
  `important` tinyint(1) NOT NULL DEFAULT 0,
  `sender` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `data` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `ip` tinytext CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `browser_fingerprint` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `created_by` int(11) NULL DEFAULT NULL,
  `updated_by` int(11) NULL DEFAULT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `form_submission_form_id`(`form_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of form_submission
-- ----------------------------

-- ----------------------------
-- Table structure for form_submission_comment
-- ----------------------------
DROP TABLE IF EXISTS `form_submission_comment`;
CREATE TABLE `form_submission_comment`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `submission_id` int(11) NOT NULL,
  `form_id` int(11) NOT NULL,
  `content` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_by` int(11) NOT NULL,
  `updated_by` int(11) NOT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `form_submission_comment_submission_id`(`submission_id`) USING BTREE,
  INDEX `form_submission_comment_form_id`(`form_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of form_submission_comment
-- ----------------------------

-- ----------------------------
-- Table structure for form_submission_file
-- ----------------------------
DROP TABLE IF EXISTS `form_submission_file`;
CREATE TABLE `form_submission_file`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `submission_id` int(11) NOT NULL,
  `form_id` int(11) NOT NULL,
  `field` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `label` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `extension` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `size` int(11) NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `form_submission_file_submission_id`(`submission_id`) USING BTREE,
  INDEX `form_submission_file_form_id`(`form_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of form_submission_file
-- ----------------------------

-- ----------------------------
-- Table structure for form_ui
-- ----------------------------
DROP TABLE IF EXISTS `form_ui`;
CREATE TABLE `form_ui`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_id` int(11) NOT NULL,
  `theme_id` int(11) NULL DEFAULT NULL,
  `js_file` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `form_ui_form_id`(`form_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of form_ui
-- ----------------------------

-- ----------------------------
-- Table structure for form_user
-- ----------------------------
DROP TABLE IF EXISTS `form_user`;
CREATE TABLE `form_user`  (
  `form_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  UNIQUE INDEX `form_user_form_id_user_id`(`form_id`, `user_id`) USING BTREE,
  INDEX `form_user_form_id`(`form_id`) USING BTREE,
  INDEX `form_user_user_id`(`user_id`) USING BTREE,
  CONSTRAINT `fk_form_user` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of form_user
-- ----------------------------

-- ----------------------------
-- Table structure for log_event
-- ----------------------------
DROP TABLE IF EXISTS `log_event`;
CREATE TABLE `log_event`  (
  `app_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `platform` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `etl_tstamp` int(11) NULL DEFAULT NULL,
  `collector_tstamp` int(11) NOT NULL,
  `dvce_tstamp` bigint(20) NULL DEFAULT NULL,
  `event` varchar(128) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `event_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `txn_id` int(11) NULL DEFAULT NULL,
  `name_tracker` varchar(128) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `v_tracker` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `v_collector` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `v_etl` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `user_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `user_ipaddress` varchar(45) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `user_fingerprint` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `domain_userid` varchar(36) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `domain_sessionidx` smallint(6) NULL DEFAULT NULL,
  `network_userid` varchar(38) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `geo_country` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `geo_region` varchar(3) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `geo_city` varchar(75) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `geo_zipcode` varchar(15) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `geo_latitude` double NULL DEFAULT NULL,
  `geo_longitude` double NULL DEFAULT NULL,
  `geo_region_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `page_url` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `page_title` varchar(2000) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `page_referrer` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `page_urlscheme` varchar(16) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `page_urlhost` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `page_urlport` int(11) NULL DEFAULT NULL,
  `page_urlpath` varchar(1000) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `page_urlquery` varchar(1000) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `page_urlfragment` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `refr_urlscheme` varchar(16) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `refr_urlhost` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `refr_urlport` int(11) NULL DEFAULT NULL,
  `refr_urlpath` varchar(1000) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `refr_urlquery` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `refr_urlfragment` varchar(1000) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `refr_medium` varchar(25) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `refr_source` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `refr_term` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `mkt_medium` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `mkt_source` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `mkt_term` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `mkt_content` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `mkt_campaign` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `contexts` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `se_category` varchar(1000) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `se_action` varchar(1000) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `se_label` varchar(1000) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `se_property` varchar(1000) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `se_value` double NULL DEFAULT NULL,
  `unstruct_event` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `tr_orderid` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `tr_affiliation` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `tr_total` decimal(18, 2) NULL DEFAULT NULL,
  `tr_tax` decimal(18, 2) NULL DEFAULT NULL,
  `tr_shipping` decimal(18, 2) NULL DEFAULT NULL,
  `tr_city` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `tr_state` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `tr_country` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `ti_orderid` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `ti_sku` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `ti_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `ti_category` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `ti_price` decimal(18, 2) NULL DEFAULT NULL,
  `ti_quantity` int(11) NULL DEFAULT NULL,
  `pp_xoffset_min` int(11) NULL DEFAULT NULL,
  `pp_xoffset_max` int(11) NULL DEFAULT NULL,
  `pp_yoffset_min` int(11) NULL DEFAULT NULL,
  `pp_yoffset_max` int(11) NULL DEFAULT NULL,
  `useragent` varchar(1000) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `br_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `br_family` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `br_version` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `br_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `br_renderengine` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `br_lang` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `br_features_pdf` tinyint(1) NULL DEFAULT NULL,
  `br_features_flash` tinyint(1) NULL DEFAULT NULL,
  `br_features_java` tinyint(1) NULL DEFAULT NULL,
  `br_features_director` tinyint(1) NULL DEFAULT NULL,
  `br_features_quicktime` tinyint(1) NULL DEFAULT NULL,
  `br_features_realplayer` tinyint(1) NULL DEFAULT NULL,
  `br_features_windowsmedia` tinyint(1) NULL DEFAULT NULL,
  `br_features_gears` tinyint(1) NULL DEFAULT NULL,
  `br_features_silverlight` tinyint(1) NULL DEFAULT NULL,
  `br_cookies` tinyint(1) NULL DEFAULT NULL,
  `br_colordepth` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `br_viewwidth` int(11) NULL DEFAULT NULL,
  `br_viewheight` int(11) NULL DEFAULT NULL,
  `os_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `os_family` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `os_manufacturer` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `os_timezone` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `dvce_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `dvce_ismobile` tinyint(1) NULL DEFAULT NULL,
  `dvce_screenwidth` int(11) NULL DEFAULT NULL,
  `dvce_screenheight` int(11) NULL DEFAULT NULL,
  `doc_charset` varchar(128) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `doc_width` int(11) NULL DEFAULT NULL,
  `doc_height` int(11) NULL DEFAULT NULL,
  `geo_timezone` varchar(64) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `mkt_clickid` varchar(128) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `mkt_network` varchar(128) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `etl_tags` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `dvce_sent_tstamp` bigint(20) NULL DEFAULT NULL,
  `domain_sessionid` varchar(36) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of log_event
-- ----------------------------

-- ----------------------------
-- Table structure for mail_queue
-- ----------------------------
DROP TABLE IF EXISTS `mail_queue`;
CREATE TABLE `mail_queue`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `from` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `to` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `cc` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `bcc` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `subject` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `html_body` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `text_body` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `reply_to` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `charset` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `attachments` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `created_at` datetime(0) NOT NULL,
  `attempts` int(11) NULL DEFAULT NULL,
  `last_attempt_time` datetime(0) NULL DEFAULT NULL,
  `sent_time` datetime(0) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of mail_queue
-- ----------------------------

-- ----------------------------
-- Table structure for migration
-- ----------------------------
DROP TABLE IF EXISTS `migration`;
CREATE TABLE `migration`  (
  `version` varchar(180) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `apply_time` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`version`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of migration
-- ----------------------------
INSERT INTO `migration` VALUES ('m000000_000000_base', 1662141549);
INSERT INTO `migration` VALUES ('m150214_044830_init_user', 1662141559);
INSERT INTO `migration` VALUES ('m150410_183765_init_setting', 1662141560);
INSERT INTO `migration` VALUES ('m150412_184646_init_theme', 1662141560);
INSERT INTO `migration` VALUES ('m150415_183345_init_form', 1662141566);
INSERT INTO `migration` VALUES ('m150420_183546_init_stats', 1662141567);
INSERT INTO `migration` VALUES ('m150420_183547_init_template', 1662141570);
INSERT INTO `migration` VALUES ('m150420_183548_init_mailqueue', 1662141570);
INSERT INTO `migration` VALUES ('m150420_183550_init_addon', 1662141571);
INSERT INTO `migration` VALUES ('m160104_150526_add_slug_to_form', 1662141571);
INSERT INTO `migration` VALUES ('m160110_151514_add_password_novalidate_to_form', 1662141573);
INSERT INTO `migration` VALUES ('m160118_171459_upgrade_user_module', 1662141577);
INSERT INTO `migration` VALUES ('m160630_181205_upgrade_to_136', 1662141579);
INSERT INTO `migration` VALUES ('m160813_213103_upgrade_to_137', 1662141579);
INSERT INTO `migration` VALUES ('m160813_213105_upgrade_to_139', 1662141580);
INSERT INTO `migration` VALUES ('m190624_153537_upgrade_to_170', 1662141581);
INSERT INTO `migration` VALUES ('m190811_215815_upgrade_to_172', 1662141583);
INSERT INTO `migration` VALUES ('m191202_174827_upgrade_to_191', 1662141592);
INSERT INTO `migration` VALUES ('m191218_212749_upgrade_to_1_10', 1662141651);
INSERT INTO `migration` VALUES ('m200618_202154_upgrade_to_1_12', 1662141657);
INSERT INTO `migration` VALUES ('m210510_232206_upgraate_to_1_14', 1662141663);
INSERT INTO `migration` VALUES ('m210906_234721_upgrade_to_1_15', 1662141664);
INSERT INTO `migration` VALUES ('m210921_231209_upgrade_to_1_16', 1662141666);
INSERT INTO `migration` VALUES ('m211201_164734_upgrade_to_1_17', 1662141667);

-- ----------------------------
-- Table structure for profile
-- ----------------------------
DROP TABLE IF EXISTS `profile`;
CREATE TABLE `profile`  (
  `user_id` int(11) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `timezone` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `language` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `public_email` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `gravatar_email` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `gravatar_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `location` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `website` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `bio` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  PRIMARY KEY (`user_id`) USING BTREE,
  CONSTRAINT `profile_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of profile
-- ----------------------------

-- ----------------------------
-- Table structure for setting
-- ----------------------------
DROP TABLE IF EXISTS `setting`;
CREATE TABLE `setting`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(64) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `category` varchar(64) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `key` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `value` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `setting_category_key`(`category`, `key`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 18 CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of setting
-- ----------------------------
INSERT INTO `setting` VALUES (1, 'string', 'app', 'name', 'Easy Forms', 1, 1662141560, 1662141560);
INSERT INTO `setting` VALUES (2, 'string', 'app', 'description', '<p>Welcome to <span style=\"color: #c9d2db;\"> the easiest way </span> to build, design and manage <span style=\"color: #e8ebef; font-weight: bold;\"> your online forms</span>.</p>', 1, 1662141560, 1662141560);
INSERT INTO `setting` VALUES (3, 'string', 'app', 'adminEmail', 'admin@example.com', 1, 1662141560, 1662141560);
INSERT INTO `setting` VALUES (4, 'string', 'app', 'supportEmail', 'support@example.com', 1, 1662141560, 1662141560);
INSERT INTO `setting` VALUES (5, 'string', 'app', 'noreplyEmail', 'no-reply@example.com', 1, 1662141560, 1662141560);
INSERT INTO `setting` VALUES (6, 'string', 'app', 'reCaptchaVersion', '2', 1, 1662141560, 1662141560);
INSERT INTO `setting` VALUES (7, 'string', 'app', 'reCaptchaSecret', 'your_secret', 1, 1662141560, 1662141560);
INSERT INTO `setting` VALUES (8, 'string', 'app', 'reCaptchaSiteKey', 'your_site_key', 1, 1662141560, 1662141560);
INSERT INTO `setting` VALUES (9, 'string', 'smtp', 'host', 'localhost', 1, 1662141560, 1662141560);
INSERT INTO `setting` VALUES (10, 'string', 'smtp', 'port', '25', 1, 1662141560, 1662141560);
INSERT INTO `setting` VALUES (11, 'string', 'smtp', 'encryption', 'none', 1, 1662141560, 1662141560);
INSERT INTO `setting` VALUES (12, 'string', 'smtp', 'username', 'Username', 1, 1662141560, 1662141560);
INSERT INTO `setting` VALUES (13, 'string', 'smtp', 'password', 'Password', 1, 1662141560, 1662141560);
INSERT INTO `setting` VALUES (14, 'integer', 'app', 'anyoneCanRegister', '0', 1, 1662141577, 1662141577);
INSERT INTO `setting` VALUES (15, 'integer', 'app', 'loginWithoutPassword', '0', 1, 1662141577, 1662141577);
INSERT INTO `setting` VALUES (16, 'integer', 'app', 'useCaptcha', '0', 1, 1662141577, 1662141577);
INSERT INTO `setting` VALUES (17, 'integer', 'app', 'defaultUserRole', '2', 1, 1662141577, 1662141577);

-- ----------------------------
-- Table structure for social_account
-- ----------------------------
DROP TABLE IF EXISTS `social_account`;
CREATE TABLE `social_account`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NULL DEFAULT NULL,
  `provider` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `client_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `code` varchar(32) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `email` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `username` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `data` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `idx_social_account_provider_client_id`(`provider`, `client_id`) USING BTREE,
  UNIQUE INDEX `idx_social_account_code`(`code`) USING BTREE,
  INDEX `fk_social_account_user`(`user_id`) USING BTREE,
  CONSTRAINT `fk_social_account_user` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of social_account
-- ----------------------------

-- ----------------------------
-- Table structure for stats_performance
-- ----------------------------
DROP TABLE IF EXISTS `stats_performance`;
CREATE TABLE `stats_performance`  (
  `day` date NOT NULL,
  `app_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `users` int(11) NULL DEFAULT NULL,
  `fills` int(11) NULL DEFAULT NULL,
  `conversions` int(11) NULL DEFAULT NULL,
  `conversionTime` bigint(20) UNSIGNED NULL DEFAULT NULL,
  UNIQUE INDEX `stats_performance_day_app_id`(`day`, `app_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of stats_performance
-- ----------------------------

-- ----------------------------
-- Table structure for stats_submissions
-- ----------------------------
DROP TABLE IF EXISTS `stats_submissions`;
CREATE TABLE `stats_submissions`  (
  `app_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `collector_tstamp` int(11) NOT NULL,
  `domain_sessionidx` smallint(6) NULL DEFAULT NULL,
  `geo_country` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `geo_city` varchar(75) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `refr_urlhost` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `refr_medium` varchar(25) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `br_family` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `os_family` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `dvce_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `dvce_ismobile` tinyint(1) NULL DEFAULT NULL
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of stats_submissions
-- ----------------------------

-- ----------------------------
-- Table structure for template
-- ----------------------------
DROP TABLE IF EXISTS `template`;
CREATE TABLE `template`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NULL DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `builder` mediumtext CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `html` mediumtext CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL,
  `version` varchar(10) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `promoted` tinyint(1) NULL DEFAULT 0,
  `shared` int(11) NULL DEFAULT 0,
  `slug` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `updated_by` int(11) NOT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 13 CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of template
-- ----------------------------
INSERT INTO `template` VALUES (1, 1, 'Basic Contact Form', 'Contact information is important for business owners, professionals, and other organizations. This form allows you to collect name, email addresses and other information so that you can reach personal or business contacts in the future.', '{\"settings\":{\"name\":\"Contact Us\",\"canvas\":\"#canvas\",\"disabledFieldset\":false,\"layoutSelected\":\"\",\"layouts\":[{\"id\":\"\",\"name\":\"Vertical\"},{\"id\":\"form-horizontal\",\"name\":\"Horizontal\"},{\"id\":\"form-inline\",\"name\":\"Inline\"}],\"formSteps\":{\"title\":\"formSteps.title\",\"fields\":{\"id\":{\"label\":\"formSteps.id\",\"type\":\"input\",\"value\":\"formSteps\"},\"steps\":{\"label\":\"formSteps.steps\",\"type\":\"textarea-split\",\"value\":[]},\"progressBar\":{\"label\":\"formSteps.progressBar\",\"type\":\"checkbox\",\"value\":false},\"noTitles\":{\"label\":\"formSteps.noTitles\",\"type\":\"checkbox\",\"value\":false},\"noStages\":{\"label\":\"formSteps.noStages\",\"type\":\"checkbox\",\"value\":false},\"noSteps\":{\"label\":\"formSteps.noSteps\",\"type\":\"checkbox\",\"value\":false}}}},\"initForm\":[{\"name\":\"heading\",\"title\":\"heading.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"heading_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"input\",\"value\":\"Contact Us\",\"name\":\"text\"},\"type\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"h1\",\"selected\":false,\"label\":\"H1\"},{\"value\":\"h2\",\"selected\":false,\"label\":\"H2\"},{\"value\":\"h3\",\"selected\":true,\"label\":\"H3\"},{\"value\":\"h4\",\"selected\":false,\"label\":\"H4\"},{\"value\":\"h5\",\"selected\":false,\"label\":\"H5\"},{\"value\":\"h6\",\"selected\":false,\"label\":\"H6\"}],\"name\":\"type\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"legend\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"paragraph\",\"title\":\"paragraph.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"paragraph_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"textarea\",\"value\":\"Let us know your questions, suggestions and concerns by filling out the contact form below.\",\"name\":\"text\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_1\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Name\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minlength\":{\"label\":\"component.minlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minlength\"},\"maxlength\":{\"label\":\"component.maxlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxlength\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"}},\"fresh\":false},{\"name\":\"email\",\"title\":\"email.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"email_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Email\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minlength\":{\"label\":\"component.minlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minlength\"},\"maxlength\":{\"label\":\"component.maxlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxlength\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"checkdns\":{\"label\":\"component.checkDNS\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"checkdns\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"}},\"fresh\":false},{\"name\":\"textarea\",\"title\":\"textarea.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"textarea_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Message\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"textarea\",\"value\":\"\",\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minlength\":{\"label\":\"component.minlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minlength\"},\"maxlength\":{\"label\":\"component.maxlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxlength\"},\"fieldSize\":{\"label\":\"component.fieldSize\",\"type\":\"input\",\"value\":\"3\",\"advanced\":true,\"name\":\"fieldSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"}},\"fresh\":false},{\"name\":\"button\",\"title\":\"button.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"button_1\"},\"inputType\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"submit\",\"label\":\"Submit\",\"selected\":true},{\"value\":\"reset\",\"label\":\"Reset\",\"selected\":false},{\"value\":\"image\",\"label\":\"Image\",\"selected\":false},{\"value\":\"button\",\"label\":\"Button\",\"selected\":false}]},\"buttonText\":{\"label\":\"component.buttonText\",\"type\":\"input\",\"value\":\"Submit\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"src\":{\"label\":\"component.src\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"btn btn-primary\",\"advanced\":true},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-12\",\"advanced\":true},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true}},\"fresh\":false}],\"styles\":[{\"name\":\"global\",\"selector\":\"#canvas\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form\",\"selector\":\"#canvas form\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form-group\",\"selector\":\"#canvas form .form-group\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form-control\",\"selector\":\"#canvas form .form-control\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form-control-focus\",\"selector\":\"#canvas form .form-control:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-primary\",\"selector\":\"#canvas form .btn.btn-primary\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-primary-hover\",\"selector\":\"#canvas form .btn.btn-primary:hover, #canvas form .btn.btn-primary:active, #canvas form .btn.btn-primary:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-default\",\"selector\":\"#canvas form .btn.btn-default\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-default-hover\",\"selector\":\"#canvas form .btn.btn-default:hover, #canvas form .btn.btn-default:active, #canvas form .btn.btn-default:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-warning\",\"selector\":\"#canvas form .btn.btn-warning\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-warning-hover\",\"selector\":\"#canvas form .btn.btn-warning:hover, #canvas form .btn.btn-warning:active, #canvas form .btn.btn-warning:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-danger\",\"selector\":\"#canvas form .btn.btn-danger\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-danger-hover\",\"selector\":\"#canvas form .btn.btn-danger:hover, #canvas form .btn.btn-danger:active, #canvas form .btn.btn-danger:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-info\",\"selector\":\"#canvas form .btn.btn-danger\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-info-hover\",\"selector\":\"#canvas form .btn.btn-info:hover, #canvas form .btn.btn-info:active, #canvas form .btn.btn-info:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"control-label\",\"selector\":\"#canvas form .control-label\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"placeholder\",\"selector\":\"#canvas form ::placeholder\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"heading\",\"selector\":\"#canvas form h1, #canvas form h2, #canvas form h3, #canvas form h4, #canvas form h5, #canvas form h6, #canvas form .legend\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"paragraph\",\"selector\":\"#canvas form p\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"help-block\",\"selector\":\"#canvas form .help-block\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"link\",\"selector\":\"#canvas form a\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"link-hover\",\"selector\":\"#canvas form a:hover\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step\",\"selector\":\"#canvas form .steps .step .stage, #canvas form .steps .step:before, #canvas form .steps .step:after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-stage\",\"selector\":\"#canvas form .steps .step .stage\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-connection\",\"selector\":\"#canvas form .steps .step:after, #canvas form .steps .step:before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-current\",\"selector\":\"#canvas form .steps .step.current .stage, #canvas form .steps .step.current:after, #canvas form .steps .step.current:before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-success\",\"selector\":\"#canvas form .steps .step.success .stage, #canvas form .steps .step.success:after, #canvas form .steps .step.success:before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-title\",\"selector\":\"#canvas form .steps .step .title\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-current-title\",\"selector\":\"#canvas form .steps .step.current .title\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-success-title\",\"selector\":\"#canvas form .steps .step.success .title\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"alert\",\"selector\":\".alert\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"alert-success\",\"selector\":\".alert-success\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"alert-danger\",\"selector\":\".alert-danger\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"alert-info\",\"selector\":\".alert-info\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"alert-warning\",\"selector\":\".alert-warning\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"validation-error-field\",\"selector\":\".has-error .form-control\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"validation-error-text\",\"selector\":\".has-error .help-block, .has-error .control-label, .has-error .radio, .has-error .checkbox, .has-error .radio-inline, .has-error .checkbox-inline, .has-error.radio label, .has-error.checkbox label, .has-error.radio-inline label, .has-error.checkbox-inline label\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"validation-symbol-asterisk\",\"selector\":\".required .control-label:after, .required-control .control-label:after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"recaptcha\",\"selector\":\"#recaptcha, .g-recaptcha\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"signature-pad\",\"selector\":\".signature-pad\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"signature-canvas\",\"selector\":\".signature-pad canvas\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"checkbox-input\",\"selector\":\"input[type=checkbox]\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"checkbox-inline\",\"selector\":\".checkbox-inline\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"radio-input\",\"selector\":\"input[type=radio]\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"radio-inline\",\"selector\":\".radio-inline\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-checkbox-before\",\"selector\":\".custom-control .checkbox label::before, .custom-control .inline-control-checkbox label::before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-checkbox-after\",\"selector\":\".custom-control .checkbox label::after, .custom-control .inline-control-checkbox label::after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-checkbox-checked-before\",\"selector\":\".custom-control .checkbox input:checked+label::before, .custom-control .inline-control-checkbox input:checked+label::before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-checkbox-checked-after\",\"selector\":\".custom-control .checkbox input:checked+label::after, .custom-control .inline-control-checkbox input:checked+label::after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-radio-before\",\"selector\":\".custom-control .radio label::before, .custom-control .inline-control-radio label::before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-radio-after\",\"selector\":\".custom-control .radio label::after, .custom-control .inline-control-radio label::after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-radio-checked-before\",\"selector\":\".custom-control .radio input:checked+label::before, .custom-control .inline-control-radio input:checked+label::before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-radio-checked-after\",\"selector\":\".custom-control .radio input:checked+label::after, .custom-control .inline-control-radio input:checked+label::after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-prev\",\"selector\":\".btn.prev\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-prev-hover\",\"selector\":\"#canvas form .btn.prev:hover, #canvas form .btn.prev:active, #canvas form .btn.prev:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-next\",\"selector\":\".btn.next\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-next-hover\",\"selector\":\"#canvas form .btn.next:hover, #canvas form .btn.next:active, #canvas form .btn.next:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"progress-bar-container\",\"selector\":\".progress\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"progress-bar\",\"selector\":\".progress-bar\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"table\",\"selector\":\".table\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"well\",\"selector\":\".well\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}}],\"height\":408}', '&lt;form id=&quot;form-app&quot;&gt;\r\n&lt;fieldset class=&quot;row&quot;&gt;\r\n\r\n&lt;!-- Heading --&gt;\r\n&lt;div class=&quot;col-xs-12&quot;&gt;\r\n    &lt;h3 class=&quot;legend&quot;&gt;Contact Us&lt;/h3&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Paragraph Text --&gt;\r\n&lt;div class=&quot;col-xs-12&quot;&gt;\r\n    &lt;p&gt;Let us know your questions, suggestions and concerns by filling out the contact form below.&lt;/p&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;col-xs-12&quot;&gt;\r\n    &lt;div class=&quot;form-group&quot;&gt;\r\n        &lt;label  class=&quot;control-label&quot; for=&quot;text_1&quot;&gt;Name&lt;/label&gt;\r\n        &lt;input type=&quot;text&quot; id=&quot;text_1&quot; name=&quot;text_1&quot; value=&quot;&quot; data-alias=&quot;&quot; class=&quot;form-control&quot;&gt;\r\n    &lt;/div&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Email --&gt;\r\n&lt;div class=&quot;col-xs-12&quot;&gt;\r\n    &lt;div class=&quot;form-group required-control&quot;&gt;\r\n        &lt;label  class=&quot;control-label&quot; for=&quot;email_1&quot;&gt;Email&lt;/label&gt;\r\n        &lt;input type=&quot;email&quot; id=&quot;email_1&quot; name=&quot;email_1&quot; value=&quot;&quot; data-alias=&quot;&quot; class=&quot;form-control&quot; required&gt;\r\n    &lt;/div&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text Area --&gt;\r\n&lt;div class=&quot;col-xs-12&quot;&gt;\r\n    &lt;div class=&quot;form-group required-control&quot;&gt;\r\n        &lt;label  class=&quot;control-label&quot; for=&quot;textarea_1&quot;&gt;Message&lt;/label&gt;\r\n        &lt;textarea id=&quot;textarea_1&quot; name=&quot;textarea_1&quot; rows=&quot;3&quot; data-alias=&quot;&quot; class=&quot;form-control&quot; required&gt;&lt;/textarea&gt;\r\n    &lt;/div&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Button --&gt;\r\n&lt;div class=&quot;col-xs-12&quot;&gt;\r\n     &lt;div class=&quot;form-action&quot;&gt;\r\n        &lt;button type=&quot;submit&quot; id=&quot;button_1&quot; name=&quot;button_1&quot; class=&quot;btn btn-primary&quot;&gt;Submit&lt;/button&gt;\r\n    &lt;/div&gt;\r\n&lt;/div&gt;\r\n&lt;/fieldset&gt;\r\n&lt;/form&gt;', NULL, 1, 0, 'basic-contact-form', 1, 1, 1662140667, 1662141568);
INSERT INTO `template` VALUES (2, 2, 'Customer Satisfaction Survey', 'You don\'t need an expensive marketing research team to gather detailed information about your customers. Instead, use this survey for a quick and easy way to get invaluable feedback from customers on the quality of your product or service.', '{\"settings\":{\"name\":\"Customer Satisfaction Survey\",\"canvas\":\"#canvas\",\"disabledFieldset\":false,\"layoutSelected\":\"\",\"layouts\":[{\"id\":\"\",\"name\":\"Vertical\"},{\"id\":\"form-horizontal\",\"name\":\"Horizontal\"},{\"id\":\"form-inline\",\"name\":\"Inline\"}],\"formSteps\":{\"title\":\"formSteps.title\",\"fields\":{\"id\":{\"label\":\"formSteps.id\",\"type\":\"input\",\"value\":\"formSteps\"},\"steps\":{\"label\":\"formSteps.steps\",\"type\":\"textarea-split\",\"value\":[]},\"progressBar\":{\"label\":\"formSteps.progressBar\",\"type\":\"checkbox\",\"value\":false},\"noTitles\":{\"label\":\"formSteps.noTitles\",\"type\":\"checkbox\",\"value\":false},\"noStages\":{\"label\":\"formSteps.noStages\",\"type\":\"checkbox\",\"value\":false},\"noSteps\":{\"label\":\"formSteps.noSteps\",\"type\":\"checkbox\",\"value\":false}}}},\"initForm\":[{\"name\":\"heading\",\"title\":\"heading.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"heading_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"input\",\"value\":\"Customer Satisfaction Survey\",\"name\":\"text\"},\"type\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"h1\",\"selected\":false,\"label\":\"H1\"},{\"value\":\"h2\",\"selected\":false,\"label\":\"H2\"},{\"value\":\"h3\",\"selected\":true,\"label\":\"H3\"},{\"value\":\"h4\",\"selected\":false,\"label\":\"H4\"},{\"value\":\"h5\",\"selected\":false,\"label\":\"H5\"},{\"value\":\"h6\",\"selected\":false,\"label\":\"H6\"}],\"name\":\"type\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"legend\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"paragraph\",\"title\":\"paragraph.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"paragraph_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"textarea\",\"value\":\"Please take a few moments to complete this satisfaction survey.\",\"name\":\"text\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"radio\",\"title\":\"radio.title\",\"fields\":{\"id\":{\"label\":\"component.groupName\",\"type\":\"input\",\"value\":\"radio_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Overall, how satisfied were you with the product \\/ service?\",\"name\":\"label\"},\"radios\":{\"label\":\"component.radios\",\"type\":\"choice\",\"value\":[\"Very Satisfied\",\"Satisfied\",\"Neutral\",\"Unsatisfied\",\"Very Unsatisfied\",\"N\\/A\"],\"name\":\"radios\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"radio-inline\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"inline\":{\"label\":\"component.inline\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"inline\"}},\"fresh\":false},{\"name\":\"radio\",\"title\":\"radio.title\",\"fields\":{\"id\":{\"label\":\"component.groupName\",\"type\":\"input\",\"value\":\"radio_2\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Would you recommend our product \\/ service to colleagues or contacts within your industry?\",\"name\":\"label\"},\"radios\":{\"label\":\"component.radios\",\"type\":\"choice\",\"value\":[\"Definitely\",\"Probably\",\"Not Sure\",\"Probably Not\",\"Definitely Not\"],\"name\":\"radios\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"radio-inline\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"inline\":{\"label\":\"component.inline\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"inline\"}},\"fresh\":false},{\"name\":\"radio\",\"title\":\"radio.title\",\"fields\":{\"id\":{\"label\":\"component.groupName\",\"type\":\"input\",\"value\":\"radio_3\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Would you use our product \\/ service in the future?\",\"name\":\"label\"},\"radios\":{\"label\":\"component.radios\",\"type\":\"choice\",\"value\":[\"Less than a month\",\"1-6 months\",\"1-3 years\",\"Over 3 Years\",\"Never used\"],\"name\":\"radios\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"radio-inline\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"inline\":{\"label\":\"component.inline\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"inline\"}},\"fresh\":false},{\"name\":\"radio\",\"title\":\"radio.title\",\"fields\":{\"id\":{\"label\":\"component.groupName\",\"type\":\"input\",\"value\":\"radio_4\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"How often do you use product \\/ service?\",\"name\":\"label\"},\"radios\":{\"label\":\"component.radios\",\"type\":\"choice\",\"value\":[\"Once a week\",\"2 to 3 times a month\",\"Once a month\",\"Less than once a month\"],\"name\":\"radios\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"radio-inline\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"inline\":{\"label\":\"component.inline\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"inline\"}},\"fresh\":false},{\"name\":\"radio\",\"title\":\"radio.title\",\"fields\":{\"id\":{\"label\":\"component.groupName\",\"type\":\"input\",\"value\":\"radio_5\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"What aspect of the product \\/ service were you most satisfied by?\",\"name\":\"label\"},\"radios\":{\"label\":\"component.radios\",\"type\":\"choice\",\"value\":[\"Quality\",\"Price\",\"Purchase Experience\",\"Installation or First Use Experience\",\"Usage Experience\",\"Customer Service\",\"Repeat Purchase Experience\"],\"name\":\"radios\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"radio-inline\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"inline\":{\"label\":\"component.inline\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"inline\"}},\"fresh\":false},{\"name\":\"textarea\",\"title\":\"textarea.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"textarea_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"What do you like about the product \\/ service?\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"textarea\",\"value\":\"\",\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minlength\":{\"label\":\"component.minlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minlength\"},\"maxlength\":{\"label\":\"component.maxlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxlength\"},\"fieldSize\":{\"label\":\"component.fieldSize\",\"type\":\"input\",\"value\":\"3\",\"advanced\":true,\"name\":\"fieldSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"}},\"fresh\":false},{\"name\":\"textarea\",\"title\":\"textarea.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"textarea_2\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"What do you dislike about the product \\/ service?\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"textarea\",\"value\":\"\",\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minlength\":{\"label\":\"component.minlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minlength\"},\"maxlength\":{\"label\":\"component.maxlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxlength\"},\"fieldSize\":{\"label\":\"component.fieldSize\",\"type\":\"input\",\"value\":\"3\",\"advanced\":true,\"name\":\"fieldSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"}},\"fresh\":false},{\"name\":\"radio\",\"title\":\"radio.title\",\"fields\":{\"id\":{\"label\":\"component.groupName\",\"type\":\"input\",\"value\":\"radio_6\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Thinking of similar products \\/ services offered by other companies, how would you compare the product \\/ service offered by our company?\",\"name\":\"label\"},\"radios\":{\"label\":\"component.radios\",\"type\":\"choice\",\"value\":[\"Much Better\",\"Somewhat Better\",\"About the Same\",\"Somewhat Worse\",\"Much Worse\",\"Don\\u0027t Know\"],\"name\":\"radios\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"radio-inline\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"inline\":{\"label\":\"component.inline\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"inline\"}},\"fresh\":false},{\"name\":\"button\",\"title\":\"button.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"button_1\"},\"inputType\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"submit\",\"label\":\"Submit\",\"selected\":true},{\"value\":\"reset\",\"label\":\"Reset\",\"selected\":false},{\"value\":\"image\",\"label\":\"Image\",\"selected\":false},{\"value\":\"button\",\"label\":\"Button\",\"selected\":false}]},\"buttonText\":{\"label\":\"component.buttonText\",\"type\":\"input\",\"value\":\"Submit\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"src\":{\"label\":\"component.src\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"btn btn-primary\",\"advanced\":true},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-12\",\"advanced\":true},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true}},\"fresh\":false}],\"styles\":[{\"name\":\"global\",\"selector\":\"#canvas\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form\",\"selector\":\"#canvas form\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form-group\",\"selector\":\"#canvas form .form-group\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form-control\",\"selector\":\"#canvas form .form-control\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form-control-focus\",\"selector\":\"#canvas form .form-control:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-primary\",\"selector\":\"#canvas form .btn.btn-primary\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-primary-hover\",\"selector\":\"#canvas form .btn.btn-primary:hover, #canvas form .btn.btn-primary:active, #canvas form .btn.btn-primary:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-default\",\"selector\":\"#canvas form .btn.btn-default\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-default-hover\",\"selector\":\"#canvas form .btn.btn-default:hover, #canvas form .btn.btn-default:active, #canvas form .btn.btn-default:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-warning\",\"selector\":\"#canvas form .btn.btn-warning\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-warning-hover\",\"selector\":\"#canvas form .btn.btn-warning:hover, #canvas form .btn.btn-warning:active, #canvas form .btn.btn-warning:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-danger\",\"selector\":\"#canvas form .btn.btn-danger\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-danger-hover\",\"selector\":\"#canvas form .btn.btn-danger:hover, #canvas form .btn.btn-danger:active, #canvas form .btn.btn-danger:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-info\",\"selector\":\"#canvas form .btn.btn-danger\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-info-hover\",\"selector\":\"#canvas form .btn.btn-info:hover, #canvas form .btn.btn-info:active, #canvas form .btn.btn-info:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"control-label\",\"selector\":\"#canvas form .control-label\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"placeholder\",\"selector\":\"#canvas form ::placeholder\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"heading\",\"selector\":\"#canvas form h1, #canvas form h2, #canvas form h3, #canvas form h4, #canvas form h5, #canvas form h6, #canvas form .legend\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"paragraph\",\"selector\":\"#canvas form p\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"help-block\",\"selector\":\"#canvas form .help-block\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"link\",\"selector\":\"#canvas form a\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"link-hover\",\"selector\":\"#canvas form a:hover\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step\",\"selector\":\"#canvas form .steps .step .stage, #canvas form .steps .step:before, #canvas form .steps .step:after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-stage\",\"selector\":\"#canvas form .steps .step .stage\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-connection\",\"selector\":\"#canvas form .steps .step:after, #canvas form .steps .step:before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-current\",\"selector\":\"#canvas form .steps .step.current .stage, #canvas form .steps .step.current:after, #canvas form .steps .step.current:before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-success\",\"selector\":\"#canvas form .steps .step.success .stage, #canvas form .steps .step.success:after, #canvas form .steps .step.success:before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-title\",\"selector\":\"#canvas form .steps .step .title\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-current-title\",\"selector\":\"#canvas form .steps .step.current .title\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-success-title\",\"selector\":\"#canvas form .steps .step.success .title\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"alert\",\"selector\":\".alert\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"alert-success\",\"selector\":\".alert-success\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"alert-danger\",\"selector\":\".alert-danger\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"alert-info\",\"selector\":\".alert-info\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"alert-warning\",\"selector\":\".alert-warning\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"validation-error-field\",\"selector\":\".has-error .form-control\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"validation-error-text\",\"selector\":\".has-error .help-block, .has-error .control-label, .has-error .radio, .has-error .checkbox, .has-error .radio-inline, .has-error .checkbox-inline, .has-error.radio label, .has-error.checkbox label, .has-error.radio-inline label, .has-error.checkbox-inline label\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"validation-symbol-asterisk\",\"selector\":\".required .control-label:after, .required-control .control-label:after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"recaptcha\",\"selector\":\"#recaptcha, .g-recaptcha\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"signature-pad\",\"selector\":\".signature-pad\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"signature-canvas\",\"selector\":\".signature-pad canvas\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"checkbox-input\",\"selector\":\"input[type=checkbox]\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"checkbox-inline\",\"selector\":\".checkbox-inline\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"radio-input\",\"selector\":\"input[type=radio]\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"radio-inline\",\"selector\":\".radio-inline\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-checkbox-before\",\"selector\":\".custom-control .checkbox label::before, .custom-control .inline-control-checkbox label::before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-checkbox-after\",\"selector\":\".custom-control .checkbox label::after, .custom-control .inline-control-checkbox label::after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-checkbox-checked-before\",\"selector\":\".custom-control .checkbox input:checked+label::before, .custom-control .inline-control-checkbox input:checked+label::before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-checkbox-checked-after\",\"selector\":\".custom-control .checkbox input:checked+label::after, .custom-control .inline-control-checkbox input:checked+label::after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-radio-before\",\"selector\":\".custom-control .radio label::before, .custom-control .inline-control-radio label::before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-radio-after\",\"selector\":\".custom-control .radio label::after, .custom-control .inline-control-radio label::after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-radio-checked-before\",\"selector\":\".custom-control .radio input:checked+label::before, .custom-control .inline-control-radio input:checked+label::before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-radio-checked-after\",\"selector\":\".custom-control .radio input:checked+label::after, .custom-control .inline-control-radio input:checked+label::after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-prev\",\"selector\":\".btn.prev\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-prev-hover\",\"selector\":\"#canvas form .btn.prev:hover, #canvas form .btn.prev:active, #canvas form .btn.prev:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-next\",\"selector\":\".btn.next\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-next-hover\",\"selector\":\"#canvas form .btn.next:hover, #canvas form .btn.next:active, #canvas form .btn.next:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"progress-bar-container\",\"selector\":\".progress\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"progress-bar\",\"selector\":\".progress-bar\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"table\",\"selector\":\".table\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"well\",\"selector\":\".well\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}}],\"height\":1469}', '&lt;form id=&quot;form-app&quot;&gt;\r\n&lt;fieldset class=&quot;row&quot;&gt;\r\n\r\n&lt;!-- Heading --&gt;\r\n&lt;div class=&quot;col-xs-12&quot;&gt;\r\n    &lt;h3 class=&quot;legend&quot;&gt;Customer Satisfaction Survey&lt;/h3&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Paragraph Text --&gt;\r\n&lt;div class=&quot;col-xs-12&quot;&gt;\r\n    &lt;p&gt;Please take a few moments to complete this satisfaction survey.&lt;/p&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Radio --&gt;\r\n&lt;div class=&quot;col-xs-12&quot;&gt;\r\n    &lt;div class=&quot;form-group&quot;&gt; \r\n        &lt;label  class=&quot;control-label&quot; for=&quot;radio_1&quot;&gt;Overall, how satisfied were you with the product / service?&lt;/label&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_0&quot; value=&quot;Very Satisfied&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_1_0&quot; class=&quot;radio-inline&quot;&gt;\r\n                Very Satisfied &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_1&quot; value=&quot;Satisfied&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_1_1&quot; class=&quot;radio-inline&quot;&gt;\r\n                Satisfied &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_2&quot; value=&quot;Neutral&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_1_2&quot; class=&quot;radio-inline&quot;&gt;\r\n                Neutral &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_3&quot; value=&quot;Unsatisfied&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_1_3&quot; class=&quot;radio-inline&quot;&gt;\r\n                Unsatisfied &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_4&quot; value=&quot;Very Unsatisfied&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_1_4&quot; class=&quot;radio-inline&quot;&gt;\r\n                Very Unsatisfied &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_5&quot; value=&quot;N&amp;#x2F;A&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_1_5&quot; class=&quot;radio-inline&quot;&gt;\r\n                N/A &lt;/label&gt;\r\n        &lt;/div&gt; \r\n        &lt;span id=&quot;radio_1&quot;&gt;&lt;/span&gt;\r\n        \r\n    &lt;/div&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Radio --&gt;\r\n&lt;div class=&quot;col-xs-12&quot;&gt;\r\n    &lt;div class=&quot;form-group&quot;&gt; \r\n        &lt;label  class=&quot;control-label&quot; for=&quot;radio_2&quot;&gt;Would you recommend our product / service to colleagues or contacts within your industry?&lt;/label&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_2&quot; id=&quot;radio_2_0&quot; value=&quot;Definitely&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_2_0&quot; class=&quot;radio-inline&quot;&gt;\r\n                Definitely &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_2&quot; id=&quot;radio_2_1&quot; value=&quot;Probably&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_2_1&quot; class=&quot;radio-inline&quot;&gt;\r\n                Probably &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_2&quot; id=&quot;radio_2_2&quot; value=&quot;Not Sure&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_2_2&quot; class=&quot;radio-inline&quot;&gt;\r\n                Not Sure &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_2&quot; id=&quot;radio_2_3&quot; value=&quot;Probably Not&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_2_3&quot; class=&quot;radio-inline&quot;&gt;\r\n                Probably Not &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_2&quot; id=&quot;radio_2_4&quot; value=&quot;Definitely Not&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_2_4&quot; class=&quot;radio-inline&quot;&gt;\r\n                Definitely Not &lt;/label&gt;\r\n        &lt;/div&gt; \r\n        &lt;span id=&quot;radio_2&quot;&gt;&lt;/span&gt;\r\n        \r\n    &lt;/div&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Radio --&gt;\r\n&lt;div class=&quot;col-xs-12&quot;&gt;\r\n    &lt;div class=&quot;form-group&quot;&gt; \r\n        &lt;label  class=&quot;control-label&quot; for=&quot;radio_3&quot;&gt;Would you use our product / service in the future?&lt;/label&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_3&quot; id=&quot;radio_3_0&quot; value=&quot;Less than a month&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_3_0&quot; class=&quot;radio-inline&quot;&gt;\r\n                Less than a month &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_3&quot; id=&quot;radio_3_1&quot; value=&quot;1-6 months&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_3_1&quot; class=&quot;radio-inline&quot;&gt;\r\n                1-6 months &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_3&quot; id=&quot;radio_3_2&quot; value=&quot;1-3 years&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_3_2&quot; class=&quot;radio-inline&quot;&gt;\r\n                1-3 years &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_3&quot; id=&quot;radio_3_3&quot; value=&quot;Over 3 Years&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_3_3&quot; class=&quot;radio-inline&quot;&gt;\r\n                Over 3 Years &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_3&quot; id=&quot;radio_3_4&quot; value=&quot;Never used&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_3_4&quot; class=&quot;radio-inline&quot;&gt;\r\n                Never used &lt;/label&gt;\r\n        &lt;/div&gt; \r\n        &lt;span id=&quot;radio_3&quot;&gt;&lt;/span&gt;\r\n        \r\n    &lt;/div&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Radio --&gt;\r\n&lt;div class=&quot;col-xs-12&quot;&gt;\r\n    &lt;div class=&quot;form-group&quot;&gt; \r\n        &lt;label  class=&quot;control-label&quot; for=&quot;radio_4&quot;&gt;How often do you use product / service?&lt;/label&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_4&quot; id=&quot;radio_4_0&quot; value=&quot;Once a week&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_4_0&quot; class=&quot;radio-inline&quot;&gt;\r\n                Once a week &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_4&quot; id=&quot;radio_4_1&quot; value=&quot;2 to 3 times a month&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_4_1&quot; class=&quot;radio-inline&quot;&gt;\r\n                2 to 3 times a month &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_4&quot; id=&quot;radio_4_2&quot; value=&quot;Once a month&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_4_2&quot; class=&quot;radio-inline&quot;&gt;\r\n                Once a month &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_4&quot; id=&quot;radio_4_3&quot; value=&quot;Less than once a month&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_4_3&quot; class=&quot;radio-inline&quot;&gt;\r\n                Less than once a month &lt;/label&gt;\r\n        &lt;/div&gt; \r\n        &lt;span id=&quot;radio_4&quot;&gt;&lt;/span&gt;\r\n        \r\n    &lt;/div&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Radio --&gt;\r\n&lt;div class=&quot;col-xs-12&quot;&gt;\r\n    &lt;div class=&quot;form-group&quot;&gt; \r\n        &lt;label  class=&quot;control-label&quot; for=&quot;radio_5&quot;&gt;What aspect of the product / service were you most satisfied by?&lt;/label&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_0&quot; value=&quot;Quality&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_5_0&quot; class=&quot;radio-inline&quot;&gt;\r\n                Quality &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_1&quot; value=&quot;Price&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_5_1&quot; class=&quot;radio-inline&quot;&gt;\r\n                Price &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_2&quot; value=&quot;Purchase Experience&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_5_2&quot; class=&quot;radio-inline&quot;&gt;\r\n                Purchase Experience &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_3&quot; value=&quot;Installation or First Use Experience&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_5_3&quot; class=&quot;radio-inline&quot;&gt;\r\n                Installation or First Use Experience &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_4&quot; value=&quot;Usage Experience&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_5_4&quot; class=&quot;radio-inline&quot;&gt;\r\n                Usage Experience &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_5&quot; value=&quot;Customer Service&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_5_5&quot; class=&quot;radio-inline&quot;&gt;\r\n                Customer Service &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_6&quot; value=&quot;Repeat Purchase Experience&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_5_6&quot; class=&quot;radio-inline&quot;&gt;\r\n                Repeat Purchase Experience &lt;/label&gt;\r\n        &lt;/div&gt; \r\n        &lt;span id=&quot;radio_5&quot;&gt;&lt;/span&gt;\r\n        \r\n    &lt;/div&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text Area --&gt;\r\n&lt;div class=&quot;col-xs-12&quot;&gt;\r\n    &lt;div class=&quot;form-group&quot;&gt;\r\n        &lt;label  class=&quot;control-label&quot; for=&quot;textarea_1&quot;&gt;What do you like about the product / service?&lt;/label&gt;\r\n        &lt;textarea id=&quot;textarea_1&quot; name=&quot;textarea_1&quot; rows=&quot;3&quot; data-alias=&quot;&quot; class=&quot;form-control&quot;&gt;&lt;/textarea&gt;\r\n    &lt;/div&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text Area --&gt;\r\n&lt;div class=&quot;col-xs-12&quot;&gt;\r\n    &lt;div class=&quot;form-group&quot;&gt;\r\n        &lt;label  class=&quot;control-label&quot; for=&quot;textarea_2&quot;&gt;What do you dislike about the product / service?&lt;/label&gt;\r\n        &lt;textarea id=&quot;textarea_2&quot; name=&quot;textarea_2&quot; rows=&quot;3&quot; data-alias=&quot;&quot; class=&quot;form-control&quot;&gt;&lt;/textarea&gt;\r\n    &lt;/div&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Radio --&gt;\r\n&lt;div class=&quot;col-xs-12&quot;&gt;\r\n    &lt;div class=&quot;form-group&quot;&gt; \r\n        &lt;label  class=&quot;control-label&quot; for=&quot;radio_6&quot;&gt;Thinking of similar products / services offered by other companies, how would you compare the product / service offered by our company?&lt;/label&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_6&quot; id=&quot;radio_6_0&quot; value=&quot;Much Better&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_6_0&quot; class=&quot;radio-inline&quot;&gt;\r\n                Much Better &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_6&quot; id=&quot;radio_6_1&quot; value=&quot;Somewhat Better&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_6_1&quot; class=&quot;radio-inline&quot;&gt;\r\n                Somewhat Better &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_6&quot; id=&quot;radio_6_2&quot; value=&quot;About the Same&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_6_2&quot; class=&quot;radio-inline&quot;&gt;\r\n                About the Same &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_6&quot; id=&quot;radio_6_3&quot; value=&quot;Somewhat Worse&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_6_3&quot; class=&quot;radio-inline&quot;&gt;\r\n                Somewhat Worse &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_6&quot; id=&quot;radio_6_4&quot; value=&quot;Much Worse&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_6_4&quot; class=&quot;radio-inline&quot;&gt;\r\n                Much Worse &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_6&quot; id=&quot;radio_6_5&quot; value=&quot;Don&amp;#x27;t Know&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_6_5&quot; class=&quot;radio-inline&quot;&gt;\r\n                Don&#039;t Know &lt;/label&gt;\r\n        &lt;/div&gt; \r\n        &lt;span id=&quot;radio_6&quot;&gt;&lt;/span&gt;\r\n        \r\n    &lt;/div&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Button --&gt;\r\n&lt;div class=&quot;col-xs-12&quot;&gt;\r\n     &lt;div class=&quot;form-action&quot;&gt;\r\n        &lt;button type=&quot;submit&quot; id=&quot;button_1&quot; name=&quot;button_1&quot; class=&quot;btn btn-primary&quot;&gt;Submit&lt;/button&gt;\r\n    &lt;/div&gt;\r\n&lt;/div&gt;\r\n&lt;/fieldset&gt;\r\n&lt;/form&gt;', NULL, 1, 0, 'customer-satisfaction-survey', 1, 1, 1662140667, 1662140667);
INSERT INTO `template` VALUES (3, 1, 'Job Application Form', 'Easy way to apply online. Gather information and upload resume using the form.', '{\"settings\":{\"name\":\"Product Manager\",\"canvas\":\"#canvas\",\"disabledFieldset\":false,\"layoutSelected\":\"\",\"layouts\":[{\"id\":\"\",\"name\":\"Vertical\"},{\"id\":\"form-horizontal\",\"name\":\"Horizontal\"},{\"id\":\"form-inline\",\"name\":\"Inline\"}],\"formSteps\":{\"title\":\"formSteps.title\",\"fields\":{\"id\":{\"label\":\"formSteps.id\",\"type\":\"input\",\"value\":\"formSteps\"},\"steps\":{\"label\":\"formSteps.steps\",\"type\":\"textarea-split\",\"value\":[]},\"progressBar\":{\"label\":\"formSteps.progressBar\",\"type\":\"checkbox\",\"value\":false},\"noTitles\":{\"label\":\"formSteps.noTitles\",\"type\":\"checkbox\",\"value\":false},\"noStages\":{\"label\":\"formSteps.noStages\",\"type\":\"checkbox\",\"value\":false},\"noSteps\":{\"label\":\"formSteps.noSteps\",\"type\":\"checkbox\",\"value\":false}}}},\"initForm\":[{\"name\":\"heading\",\"title\":\"heading.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"heading_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"input\",\"value\":\"Product Manager\",\"name\":\"text\"},\"type\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"h1\",\"selected\":false,\"label\":\"H1\"},{\"value\":\"h2\",\"selected\":false,\"label\":\"H2\"},{\"value\":\"h3\",\"selected\":true,\"label\":\"H3\"},{\"value\":\"h4\",\"selected\":false,\"label\":\"H4\"},{\"value\":\"h5\",\"selected\":false,\"label\":\"H5\"},{\"value\":\"h6\",\"selected\":false,\"label\":\"H6\"}],\"name\":\"type\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"legend\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"paragraph\",\"title\":\"paragraph.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"paragraph_1\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"textarea\",\"value\":\"\\u003Cstrong\\u003EWill you be our next Product Manager?\\u003C\\/strong\\u003E\",\"name\":\"text\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-12\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"snippet\",\"title\":\"snippet.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"snippet_1\",\"name\":\"id\"},\"snippet\":{\"label\":\"component.htmlCode\",\"type\":\"textarea\",\"value\":\"\\u003Cdiv style=\\u0022border: 1px solid #DDD; padding: 10px; overflow-y: scroll; height: 200px; margin-bottom: 20px;\\u0022\\u003E\\n\\u003Cp\\u003E\\u003Cstrong\\u003EAre you...\\u003C\\/strong\\u003E\\u003C\\/p\\u003E\\n\\u003Cul\\u003E\\n\\u003Cli\\u003EFascinated by software products and how they can impact the lives of their users?\\u003C\\/li\\u003E\\n\\u003Cli\\u003ESomeone who enjoys collaborating with customers, developers and marketers to develop a roadmap for a product?\\u003C\\/li\\u003E\\n\\u003Cli\\u003EA person that enjoys being a vital part of an organization?\\u003C\\/li\\u003E\\n\\u003Cli\\u003EA believer that great software can provide significant savings of time and money?\\u003C\\/li\\u003E\\n\\u003C\\/ul\\u003E\\n\\u003Cp\\u003EIf so, you should consider applying to become our next Product Manager.\\u003C\\/p\\u003E\\n\\u003Cp\\u003EWe are looking for a high energy and fun person to add to our team.\\u003C\\/p\\u003E\\n\\u003Cp\\u003EThey will have the opportunity to significantly direct and impact the development path of our web application and the future of our product.\\u003C\\/p\\u003E\\n\\u003Cp\\u003E\\u003Cstrong\\u003EResponsibilities:\\u003C\\/strong\\u003E\\u003C\\/p\\u003E\\n\\u003Cul\\u003E\\n\\u003Cli\\u003EDefining new improvements for our web application, gathering requirements \\u0026amp; documenting designs\\u003C\\/li\\u003E\\n\\u003Cli\\u003ECollect and interpret customer feedback and needs but realize the customer might not always know what they need\\u003C\\/li\\u003E\\n\\u003Cli\\u003EUtilize a healthy amount of intuition but balance that with the appropriate amount of \\u0027data\\u0027 to back your decisions\\u003C\\/li\\u003E\\n\\u003Cli\\u003EAbility to prioritize\\u003C\\/li\\u003E\\n\\u003Cli\\u003EManage usability testing of new features to understand the \\u0022how\\u0022 and \\u0022why\\u0022 for people who use the software\\u003C\\/li\\u003E\\n\\u003Cli\\u003EProject management, seeing all projects from start to finish, new software every week\\u003C\\/li\\u003E\\n\\u003Cli\\u003ECollaborate with Marketing to define the strategies and define use cases\\u003C\\/li\\u003E\\n\\u003Cli\\u003EWork with the Customer Experience Team to analyze customer feedback and feature requests\\u003C\\/li\\u003E\\n\\u003Cli\\u003EInsure the end product is meeting the goals set in the beginning\\u003C\\/li\\u003E\\n\\u003C\\/ul\\u003E\\n\\u003Cp\\u003E\\u003Cstrong\\u003ESkills:\\u003C\\/strong\\u003E\\u003C\\/p\\u003E\\n\\u003Cul\\u003E\\n\\u003Cli\\u003EKnowledge of Web Applications, SaaS companies and more than 4 years of experience guiding product development\\u003C\\/li\\u003E\\n\\u003Cli\\u003EA background or passion for user experience and design\\u003C\\/li\\u003E\\n\\u003Cli\\u003ETechnical understanding of the limitations and possibilities within the Web Applications space\\u003C\\/li\\u003E\\n\\u003Cli\\u003EHighly organized with demonstrated effective verbal and written communication skills\\u003C\\/li\\u003E\\n\\u003Cli\\u003EAbility to act as a liaison between departments and maintain lines of communication\\u003C\\/li\\u003E\\n\\u003Cli\\u003EGoal-oriented but able to make changes and pivots when necessary\\u003C\\/li\\u003E\\n\\u003C\\/ul\\u003E\\n\\u003Cp\\u003E*we are an Indianapolis-based company but accept applications for remote team members\\u003C\\/p\\u003E\\n\\u003C\\/div\\u003E\",\"name\":\"snippet\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-12\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_1\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Name\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minlength\":{\"label\":\"component.minlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minlength\"},\"maxlength\":{\"label\":\"component.maxlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxlength\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_2\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Last Name\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minlength\":{\"label\":\"component.minlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minlength\"},\"maxlength\":{\"label\":\"component.maxlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxlength\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"}},\"fresh\":false},{\"name\":\"email\",\"title\":\"email.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"email_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Email\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minlength\":{\"label\":\"component.minlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minlength\"},\"maxlength\":{\"label\":\"component.maxlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxlength\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"checkdns\":{\"label\":\"component.checkDNS\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"checkdns\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_3\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Address\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minlength\":{\"label\":\"component.minlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minlength\"},\"maxlength\":{\"label\":\"component.maxlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxlength\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"}},\"fresh\":false},{\"name\":\"radio\",\"title\":\"radio.title\",\"fields\":{\"id\":{\"label\":\"component.groupName\",\"type\":\"input\",\"value\":\"radio_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"How did you find out about this position?\",\"name\":\"label\"},\"radios\":{\"label\":\"component.radios\",\"type\":\"choice\",\"value\":[\"Current Employee\",\"Career Fair\",\"Newspaper Ad\",\"Radio\\/TV Ad\",\"Search Engine\",\"Other\"],\"name\":\"radios\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"radio-inline\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"inline\":{\"label\":\"component.inline\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"inline\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_4\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"If other, please specify\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minlength\":{\"label\":\"component.minlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minlength\"},\"maxlength\":{\"label\":\"component.maxlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxlength\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"}},\"fresh\":false},{\"name\":\"file\",\"title\":\"file.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"file_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Upload your resume\",\"name\":\"label\"},\"accept\":{\"label\":\"component.accept\",\"type\":\"input\",\"value\":\".pdf, .docx, .doc\",\"name\":\"accept\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minFiles\":{\"label\":\"component.minFiles\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minFiles\"},\"maxFiles\":{\"label\":\"component.maxFiles\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxFiles\"},\"minSize\":{\"label\":\"component.minSize\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minSize\"},\"maxSize\":{\"label\":\"component.maxSize\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"file\",\"title\":\"file.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"file_2\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Upload a cover letter\",\"name\":\"label\"},\"accept\":{\"label\":\"component.accept\",\"type\":\"input\",\"value\":\".gif, .jpg, .png\",\"name\":\"accept\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minFiles\":{\"label\":\"component.minFiles\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minFiles\"},\"maxFiles\":{\"label\":\"component.maxFiles\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxFiles\"},\"minSize\":{\"label\":\"component.minSize\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minSize\"},\"maxSize\":{\"label\":\"component.maxSize\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"textarea\",\"title\":\"textarea.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"textarea_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Additional info\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"textarea\",\"value\":\"\",\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minlength\":{\"label\":\"component.minlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minlength\"},\"maxlength\":{\"label\":\"component.maxlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxlength\"},\"fieldSize\":{\"label\":\"component.fieldSize\",\"type\":\"input\",\"value\":\"3\",\"advanced\":true,\"name\":\"fieldSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"}},\"fresh\":false},{\"name\":\"button\",\"title\":\"button.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"button_1\"},\"inputType\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"submit\",\"label\":\"Submit\",\"selected\":true},{\"value\":\"reset\",\"label\":\"Reset\",\"selected\":false},{\"value\":\"image\",\"label\":\"Image\",\"selected\":false},{\"value\":\"button\",\"label\":\"Button\",\"selected\":false}]},\"buttonText\":{\"label\":\"component.buttonText\",\"type\":\"input\",\"value\":\"Submit\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"src\":{\"label\":\"component.src\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"btn btn-primary\",\"advanced\":true},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-12\",\"advanced\":true},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true}},\"fresh\":false}],\"styles\":[{\"name\":\"global\",\"selector\":\"#canvas\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form\",\"selector\":\"#canvas form\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form-group\",\"selector\":\"#canvas form .form-group\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form-control\",\"selector\":\"#canvas form .form-control\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form-control-focus\",\"selector\":\"#canvas form .form-control:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-primary\",\"selector\":\"#canvas form .btn.btn-primary\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-primary-hover\",\"selector\":\"#canvas form .btn.btn-primary:hover, #canvas form .btn.btn-primary:active, #canvas form .btn.btn-primary:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-default\",\"selector\":\"#canvas form .btn.btn-default\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-default-hover\",\"selector\":\"#canvas form .btn.btn-default:hover, #canvas form .btn.btn-default:active, #canvas form .btn.btn-default:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-warning\",\"selector\":\"#canvas form .btn.btn-warning\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-warning-hover\",\"selector\":\"#canvas form .btn.btn-warning:hover, #canvas form .btn.btn-warning:active, #canvas form .btn.btn-warning:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-danger\",\"selector\":\"#canvas form .btn.btn-danger\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-danger-hover\",\"selector\":\"#canvas form .btn.btn-danger:hover, #canvas form .btn.btn-danger:active, #canvas form .btn.btn-danger:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-info\",\"selector\":\"#canvas form .btn.btn-danger\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-info-hover\",\"selector\":\"#canvas form .btn.btn-info:hover, #canvas form .btn.btn-info:active, #canvas form .btn.btn-info:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"control-label\",\"selector\":\"#canvas form .control-label\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"placeholder\",\"selector\":\"#canvas form ::placeholder\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"heading\",\"selector\":\"#canvas form h1, #canvas form h2, #canvas form h3, #canvas form h4, #canvas form h5, #canvas form h6, #canvas form .legend\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"paragraph\",\"selector\":\"#canvas form p\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"help-block\",\"selector\":\"#canvas form .help-block\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"link\",\"selector\":\"#canvas form a\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"link-hover\",\"selector\":\"#canvas form a:hover\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step\",\"selector\":\"#canvas form .steps .step .stage, #canvas form .steps .step:before, #canvas form .steps .step:after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-stage\",\"selector\":\"#canvas form .steps .step .stage\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-connection\",\"selector\":\"#canvas form .steps .step:after, #canvas form .steps .step:before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-current\",\"selector\":\"#canvas form .steps .step.current .stage, #canvas form .steps .step.current:after, #canvas form .steps .step.current:before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-success\",\"selector\":\"#canvas form .steps .step.success .stage, #canvas form .steps .step.success:after, #canvas form .steps .step.success:before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-title\",\"selector\":\"#canvas form .steps .step .title\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-current-title\",\"selector\":\"#canvas form .steps .step.current .title\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-success-title\",\"selector\":\"#canvas form .steps .step.success .title\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"alert\",\"selector\":\".alert\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"alert-success\",\"selector\":\".alert-success\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"alert-danger\",\"selector\":\".alert-danger\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"alert-info\",\"selector\":\".alert-info\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"alert-warning\",\"selector\":\".alert-warning\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"validation-error-field\",\"selector\":\".has-error .form-control\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"validation-error-text\",\"selector\":\".has-error .help-block, .has-error .control-label, .has-error .radio, .has-error .checkbox, .has-error .radio-inline, .has-error .checkbox-inline, .has-error.radio label, .has-error.checkbox label, .has-error.radio-inline label, .has-error.checkbox-inline label\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"validation-symbol-asterisk\",\"selector\":\".required .control-label:after, .required-control .control-label:after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"recaptcha\",\"selector\":\"#recaptcha, .g-recaptcha\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"signature-pad\",\"selector\":\".signature-pad\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"signature-canvas\",\"selector\":\".signature-pad canvas\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"checkbox-input\",\"selector\":\"input[type=checkbox]\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"checkbox-inline\",\"selector\":\".checkbox-inline\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"radio-input\",\"selector\":\"input[type=radio]\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"radio-inline\",\"selector\":\".radio-inline\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-checkbox-before\",\"selector\":\".custom-control .checkbox label::before, .custom-control .inline-control-checkbox label::before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-checkbox-after\",\"selector\":\".custom-control .checkbox label::after, .custom-control .inline-control-checkbox label::after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-checkbox-checked-before\",\"selector\":\".custom-control .checkbox input:checked+label::before, .custom-control .inline-control-checkbox input:checked+label::before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-checkbox-checked-after\",\"selector\":\".custom-control .checkbox input:checked+label::after, .custom-control .inline-control-checkbox input:checked+label::after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-radio-before\",\"selector\":\".custom-control .radio label::before, .custom-control .inline-control-radio label::before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-radio-after\",\"selector\":\".custom-control .radio label::after, .custom-control .inline-control-radio label::after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-radio-checked-before\",\"selector\":\".custom-control .radio input:checked+label::before, .custom-control .inline-control-radio input:checked+label::before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"custom-control-radio-checked-after\",\"selector\":\".custom-control .radio input:checked+label::after, .custom-control .inline-control-radio input:checked+label::after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-prev\",\"selector\":\".btn.prev\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-prev-hover\",\"selector\":\"#canvas form .btn.prev:hover, #canvas form .btn.prev:active, #canvas form .btn.prev:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-next\",\"selector\":\".btn.next\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-next-hover\",\"selector\":\"#canvas form .btn.next:hover, #canvas form .btn.next:active, #canvas form .btn.next:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"progress-bar-container\",\"selector\":\".progress\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"progress-bar\",\"selector\":\".progress-bar\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"table\",\"selector\":\".table\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"well\",\"selector\":\".well\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}}],\"height\":1176}', '&lt;form id=&quot;form-app&quot; enctype=&quot;multipart/form-data&quot;&gt;\r\n&lt;fieldset class=&quot;row&quot;&gt;\r\n\r\n&lt;!-- Heading --&gt;\r\n&lt;div class=&quot;col-xs-12&quot;&gt;\r\n    &lt;h3 class=&quot;legend&quot;&gt;Product Manager&lt;/h3&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Paragraph Text --&gt;\r\n&lt;div class=&quot;col-xs-12&quot;&gt;\r\n    &lt;p&gt;&lt;strong&gt;Will you be our next Product Manager?&lt;/strong&gt;&lt;/p&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Snippet --&gt;\r\n&lt;div class=&quot;snippet col-xs-12&quot;&gt;&lt;div style=&quot;border: 1px solid #DDD; padding: 10px; overflow-y: scroll; height: 200px; margin-bottom: 20px;&quot;&gt;\r\n&lt;p&gt;&lt;strong&gt;Are you...&lt;/strong&gt;&lt;/p&gt;\r\n&lt;ul&gt;\r\n&lt;li&gt;Fascinated by software products and how they can impact the lives of their users?&lt;/li&gt;\r\n&lt;li&gt;Someone who enjoys collaborating with customers, developers and marketers to develop a roadmap for a product?&lt;/li&gt;\r\n&lt;li&gt;A person that enjoys being a vital part of an organization?&lt;/li&gt;\r\n&lt;li&gt;A believer that great software can provide significant savings of time and money?&lt;/li&gt;\r\n&lt;/ul&gt;\r\n&lt;p&gt;If so, you should consider applying to become our next Product Manager.&lt;/p&gt;\r\n&lt;p&gt;We are looking for a high energy and fun person to add to our team.&lt;/p&gt;\r\n&lt;p&gt;They will have the opportunity to significantly direct and impact the development path of our web application and the future of our product.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Responsibilities:&lt;/strong&gt;&lt;/p&gt;\r\n&lt;ul&gt;\r\n&lt;li&gt;Defining new improvements for our web application, gathering requirements &amp;amp; documenting designs&lt;/li&gt;\r\n&lt;li&gt;Collect and interpret customer feedback and needs but realize the customer might not always know what they need&lt;/li&gt;\r\n&lt;li&gt;Utilize a healthy amount of intuition but balance that with the appropriate amount of &#039;data&#039; to back your decisions&lt;/li&gt;\r\n&lt;li&gt;Ability to prioritize&lt;/li&gt;\r\n&lt;li&gt;Manage usability testing of new features to understand the &quot;how&quot; and &quot;why&quot; for people who use the software&lt;/li&gt;\r\n&lt;li&gt;Project management, seeing all projects from start to finish, new software every week&lt;/li&gt;\r\n&lt;li&gt;Collaborate with Marketing to define the strategies and define use cases&lt;/li&gt;\r\n&lt;li&gt;Work with the Customer Experience Team to analyze customer feedback and feature requests&lt;/li&gt;\r\n&lt;li&gt;Insure the end product is meeting the goals set in the beginning&lt;/li&gt;\r\n&lt;/ul&gt;\r\n&lt;p&gt;&lt;strong&gt;Skills:&lt;/strong&gt;&lt;/p&gt;\r\n&lt;ul&gt;\r\n&lt;li&gt;Knowledge of Web Applications, SaaS companies and more than 4 years of experience guiding product development&lt;/li&gt;\r\n&lt;li&gt;A background or passion for user experience and design&lt;/li&gt;\r\n&lt;li&gt;Technical understanding of the limitations and possibilities within the Web Applications space&lt;/li&gt;\r\n&lt;li&gt;Highly organized with demonstrated effective verbal and written communication skills&lt;/li&gt;\r\n&lt;li&gt;Ability to act as a liaison between departments and maintain lines of communication&lt;/li&gt;\r\n&lt;li&gt;Goal-oriented but able to make changes and pivots when necessary&lt;/li&gt;\r\n&lt;/ul&gt;\r\n&lt;p&gt;*we are an Indianapolis-based company but accept applications for remote team members&lt;/p&gt;\r\n&lt;/div&gt;&lt;/div&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;col-xs-12&quot;&gt;\r\n    &lt;div class=&quot;form-group required-control&quot;&gt;\r\n        &lt;label  class=&quot;control-label&quot; for=&quot;text_1&quot;&gt;Name&lt;/label&gt;\r\n        &lt;input type=&quot;text&quot; id=&quot;text_1&quot; name=&quot;text_1&quot; value=&quot;&quot; data-alias=&quot;&quot; class=&quot;form-control&quot; required&gt;\r\n    &lt;/div&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;col-xs-12&quot;&gt;\r\n    &lt;div class=&quot;form-group required-control&quot;&gt;\r\n        &lt;label  class=&quot;control-label&quot; for=&quot;text_2&quot;&gt;Last Name&lt;/label&gt;\r\n        &lt;input type=&quot;text&quot; id=&quot;text_2&quot; name=&quot;text_2&quot; value=&quot;&quot; data-alias=&quot;&quot; class=&quot;form-control&quot; required&gt;\r\n    &lt;/div&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Email --&gt;\r\n&lt;div class=&quot;col-xs-12&quot;&gt;\r\n    &lt;div class=&quot;form-group required-control&quot;&gt;\r\n        &lt;label  class=&quot;control-label&quot; for=&quot;email_1&quot;&gt;Email&lt;/label&gt;\r\n        &lt;input type=&quot;email&quot; id=&quot;email_1&quot; name=&quot;email_1&quot; value=&quot;&quot; data-alias=&quot;&quot; class=&quot;form-control&quot; required&gt;\r\n    &lt;/div&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;col-xs-12&quot;&gt;\r\n    &lt;div class=&quot;form-group required-control&quot;&gt;\r\n        &lt;label  class=&quot;control-label&quot; for=&quot;text_3&quot;&gt;Address&lt;/label&gt;\r\n        &lt;input type=&quot;text&quot; id=&quot;text_3&quot; name=&quot;text_3&quot; value=&quot;&quot; data-alias=&quot;&quot; class=&quot;form-control&quot; required&gt;\r\n    &lt;/div&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Radio --&gt;\r\n&lt;div class=&quot;col-xs-12&quot;&gt;\r\n    &lt;div class=&quot;form-group&quot;&gt; \r\n        &lt;label  class=&quot;control-label&quot; for=&quot;radio_1&quot;&gt;How did you find out about this position?&lt;/label&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_0&quot; value=&quot;Current Employee&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_1_0&quot; class=&quot;radio-inline&quot;&gt;\r\n                Current Employee &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_1&quot; value=&quot;Career Fair&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_1_1&quot; class=&quot;radio-inline&quot;&gt;\r\n                Career Fair &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_2&quot; value=&quot;Newspaper Ad&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_1_2&quot; class=&quot;radio-inline&quot;&gt;\r\n                Newspaper Ad &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_3&quot; value=&quot;Radio&amp;#x2F;TV Ad&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_1_3&quot; class=&quot;radio-inline&quot;&gt;\r\n                Radio/TV Ad &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_4&quot; value=&quot;Search Engine&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_1_4&quot; class=&quot;radio-inline&quot;&gt;\r\n                Search Engine &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;radio &quot;&gt;\r\n            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_5&quot; value=&quot;Other&quot; data-alias=&quot;&quot; &gt;&lt;label for=&quot;radio_1_5&quot; class=&quot;radio-inline&quot;&gt;\r\n                Other &lt;/label&gt;\r\n        &lt;/div&gt; \r\n        &lt;span id=&quot;radio_1&quot;&gt;&lt;/span&gt;\r\n        \r\n    &lt;/div&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;col-xs-12&quot;&gt;\r\n    &lt;div class=&quot;form-group&quot;&gt;\r\n        &lt;label  class=&quot;control-label&quot; for=&quot;text_4&quot;&gt;If other, please specify&lt;/label&gt;\r\n        &lt;input type=&quot;text&quot; id=&quot;text_4&quot; name=&quot;text_4&quot; value=&quot;&quot; data-alias=&quot;&quot; class=&quot;form-control&quot;&gt;\r\n    &lt;/div&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- File --&gt;\r\n&lt;div class=&quot;col-xs-12&quot;&gt;\r\n    &lt;div class=&quot;form-group&quot;&gt;\r\n        &lt;label  class=&quot;control-label&quot; for=&quot;file_1&quot;&gt;Upload your resume&lt;/label&gt;\r\n        &lt;input type=&quot;file&quot; id=&quot;file_1&quot; name=&quot;file_1[]&quot; data-alias=&quot;&quot; accept=&quot;.pdf, .docx, .doc&quot;&gt;\r\n    &lt;/div&gt;\r\n&lt;/div&gt;\r\n\r\n\r\n&lt;!-- File --&gt;\r\n&lt;div class=&quot;col-xs-12&quot;&gt;\r\n    &lt;div class=&quot;form-group&quot;&gt;\r\n        &lt;label  class=&quot;control-label&quot; for=&quot;file_2&quot;&gt;Upload a cover letter&lt;/label&gt;\r\n        &lt;input type=&quot;file&quot; id=&quot;file_2&quot; name=&quot;file_2[]&quot; data-alias=&quot;&quot; accept=&quot;.gif, .jpg, .png&quot;&gt;\r\n    &lt;/div&gt;\r\n&lt;/div&gt;\r\n\r\n\r\n&lt;!-- Text Area --&gt;\r\n&lt;div class=&quot;col-xs-12&quot;&gt;\r\n    &lt;div class=&quot;form-group&quot;&gt;\r\n        &lt;label  class=&quot;control-label&quot; for=&quot;textarea_1&quot;&gt;Additional info&lt;/label&gt;\r\n        &lt;textarea id=&quot;textarea_1&quot; name=&quot;textarea_1&quot; rows=&quot;3&quot; data-alias=&quot;&quot; class=&quot;form-control&quot;&gt;&lt;/textarea&gt;\r\n    &lt;/div&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Button --&gt;\r\n&lt;div class=&quot;col-xs-12&quot;&gt;\r\n     &lt;div class=&quot;form-action&quot;&gt;\r\n        &lt;button type=&quot;submit&quot; id=&quot;button_1&quot; name=&quot;button_1&quot; class=&quot;btn btn-primary&quot;&gt;Submit&lt;/button&gt;\r\n    &lt;/div&gt;\r\n&lt;/div&gt;\r\n&lt;/fieldset&gt;\r\n&lt;/form&gt;', NULL, 1, 0, 'job-application-form', 1, 1, 1662140667, 1662140667);
INSERT INTO `template` VALUES (4, 7, 'Bug Tracker', 'Do you need to track bugs for an IT department or a group of developers? With this form, you can collect and track the information you need to quickly and effectively intake clients. ', '{\"settings\":{\"name\":\"Bug Tracker\",\"canvas\":\"#canvas\",\"disabledFieldset\":false,\"layoutSelected\":\"\",\"layouts\":[{\"id\":\"\",\"name\":\"Vertical\"},{\"id\":\"form-horizontal\",\"name\":\"Horizontal\"},{\"id\":\"form-inline\",\"name\":\"Inline\"}],\"formSteps\":{\"title\":\"formSteps.title\",\"fields\":{\"id\":{\"label\":\"formSteps.id\",\"type\":\"input\",\"value\":\"formSteps\"},\"steps\":{\"label\":\"formSteps.steps\",\"type\":\"textarea-split\",\"value\":[]},\"progressBar\":{\"label\":\"formSteps.progressBar\",\"type\":\"checkbox\",\"value\":false},\"noTitles\":{\"label\":\"formSteps.noTitles\",\"type\":\"checkbox\",\"value\":false},\"noStages\":{\"label\":\"formSteps.noStages\",\"type\":\"checkbox\",\"value\":false},\"noSteps\":{\"label\":\"formSteps.noSteps\",\"type\":\"checkbox\",\"value\":false}}}},\"initForm\":[{\"name\":\"heading\",\"title\":\"heading.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"heading_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"input\",\"value\":\"Bug Tracker\",\"name\":\"text\"},\"type\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"h1\",\"selected\":false,\"label\":\"H1\"},{\"value\":\"h2\",\"selected\":false,\"label\":\"H2\"},{\"value\":\"h3\",\"selected\":true,\"label\":\"H3\"},{\"value\":\"h4\",\"selected\":false,\"label\":\"H4\"},{\"value\":\"h5\",\"selected\":false,\"label\":\"H5\"},{\"value\":\"h6\",\"selected\":false,\"label\":\"H6\"}],\"name\":\"type\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"legend\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"paragraph\",\"title\":\"paragraph.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"paragraph_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"textarea\",\"value\":\"Report all bugs!\",\"name\":\"text\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_1\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Bug Title\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minlength\":{\"label\":\"component.minlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minlength\"},\"maxlength\":{\"label\":\"component.maxlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxlength\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"}},\"fresh\":false},{\"name\":\"textarea\",\"title\":\"textarea.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"textarea_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Issue Description\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"textarea\",\"value\":\"\",\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minlength\":{\"label\":\"component.minlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minlength\"},\"maxlength\":{\"label\":\"component.maxlength\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxlength\"},\"fieldSize\":{\"label\":\"component.fieldSize\",\"type\":\"input\",\"value\":\"3\",\"advanced\":true,\"name\":\"fieldSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"}},\"fresh\":false},{\"name\":\"selectlist\",\"title\":\"selectlist.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"selectlist_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Operating System\",\"name\":\"label\"},\"options\":{\"label\":\"component.options\",\"type\":\"choice\",\"value\":[\"Windows XP\",\"Windows Vista\",\"Mac OS X\",\"Linux\",\"Other\"],\"name\":\"options\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"-Select-\",\"name\":\"placeholder\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-6\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"}},\"fresh\":false},{\"name\":\"selectlist\",\"title\":\"selectlist.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"selectlist_2\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Browser\",\"name\":\"label\"},\"options\":{\"label\":\"component.options\",\"type\":\"choice\",\"value\":[\"Internet Explorer\",\"Chrome\",\"Firefox\",\"Safari\",\"Opera\",\"Other\"],\"name\":\"options\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"-Select-\",\"name\":\"placeholder\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-6\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"}},\"fresh\":false},{\"name\":\"selectlist\",\"title\":\"selectlist.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"selectlist_3\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Assign To\",\"name\":\"label\"},\"options\":{\"label\":\"component.options\",\"type\":\"choice\",\"value\":[\"Team Member #1\",\"Team Member #2\",\"Team Member #3\"],\"name\":\"options\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"-Select-\",\"name\":\"placeholder\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-9\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"}},\"fresh\":false},{\"name\":\"selectlist\",\"title\":\"selectlist.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"selectlist_4\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Priority\",\"name\":\"label\"},\"options\":{\"label\":\"component.options\",\"type\":\"choice\",\"value\":[\"Low\",\"Medium\",\"High\"],\"name\":\"options\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"-Select-\",\"name\":\"placeholder\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-3\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"}},\"fresh\":false},{\"name\":\"file\",\"title\":\"file.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"file_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Upload a Screenshot\",\"name\":\"label\"},\"accept\":{\"label\":\"component.accept\",\"type\":\"input\",\"value\":\".gif, .jpg, .png\",\"name\":\"accept\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"minFiles\":{\"label\":\"component.minFiles\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minFiles\"},\"maxFiles\":{\"label\":\"component.maxFiles\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxFiles\"},\"minSize\":{\"label\":\"component.minSize\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minSize\"},\"maxSize\":{\"label\":\"component.maxSize\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"selectlist\",\"title\":\"selectlist.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"selectlist_5\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Status\",\"name\":\"label\"},\"options\":{\"label\":\"component.options\",\"type\":\"choice\",\"value\":[\"New\",\"Acknowledged\",\"Confirmed\",\"Assigned\",\"Resolved\",\"Closed\"],\"name\":\"options\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"-Select-\",\"name\":\"placeholder\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"helpTextPlacement\":{\"label\":\"component.helpTextPlacement\",\"type\":\"select\",\"value\":[{\"value\":\"below\",\"selected\":true,\"label\":\"Below inputs\"},{\"value\":\"above\",\"selected\":false,\"label\":\"Above inputs\"}],\"advanced\":true,\"name\":\"helpTextPlacement\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-12\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"alias\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"advanced\":true,\"name\":\"required\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"}},\"fresh\":false},{\"name\":\"button\",\"title\":\"button.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"button_1\"},\"inputType\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"submit\",\"label\":\"Submit\",\"selected\":true},{\"value\":\"reset\",\"label\":\"Reset\",\"selected\":false},{\"value\":\"image\",\"label\":\"Image\",\"selected\":false},{\"value\":\"button\",\"label\":\"Button\",\"selected\":false}]},\"buttonText\":{\"label\":\"component.buttonText\",\"type\":\"input\",\"value\":\"Submit\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"src\":{\"label\":\"component.src\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"btn btn-primary\",\"advanced\":true},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-12\",\"advanced\":true},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true}},\"fresh\":false}],\"styles\":[{\"name\":\"global\",\"selector\":\"#canvas\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form\",\"selector\":\"#canvas form\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form-group\",\"selector\":\"#canvas form .form-group\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form-control\",\"selector\":\"#canvas form .form-control\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"form-control-focus\",\"selector\":\"#canvas form .form-control:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-primary\",\"selector\":\"#canvas form .btn.btn-primary\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-primary-hover\",\"selector\":\"#canvas form .btn.btn-primary:hover, #canvas form .btn.btn-primary:active, #canvas form .btn.btn-primary:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-default\",\"selector\":\"#canvas form .btn.btn-default\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-default-hover\",\"selector\":\"#canvas form .btn.btn-default:hover, #canvas form .btn.btn-default:active, #canvas form .btn.btn-default:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-warning\",\"selector\":\"#canvas form .btn.btn-warning\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-warning-hover\",\"selector\":\"#canvas form .btn.btn-warning:hover, #canvas form .btn.btn-warning:active, #canvas form .btn.btn-warning:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-danger\",\"selector\":\"#canvas form .btn.btn-danger\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-danger-hover\",\"selector\":\"#canvas form .btn.btn-danger:hover, #canvas form .btn.btn-danger:active, #canvas form .btn.btn-danger:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-info\",\"selector\":\"#canvas form .btn.btn-danger\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"button-info-hover\",\"selector\":\"#canvas form .btn.btn-info:hover, #canvas form .btn.btn-info:active, #canvas form .btn.btn-info:focus\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"control-label\",\"selector\":\"#canvas form .control-label\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"placeholder\",\"selector\":\"#canvas form ::placeholder\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"heading\",\"selector\":\"#canvas form h1, #canvas form h2, #canvas form h3, #canvas form h4, #canvas form h5, #canvas form h6, #canvas form .legend\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"paragraph\",\"selector\":\"#canvas form p\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"help-block\",\"selector\":\"#canvas form .help-block\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"link\",\"selector\":\"#canvas form a\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"link-hover\",\"selector\":\"#canvas form a:hover\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step\",\"selector\":\"#canvas form .steps .step .stage, #canvas form .steps .step:before, #canvas form .steps .step:after\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-stage\",\"selector\":\"#canvas form .steps .step .stage\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-connection\",\"selector\":\"#canvas form .steps .step:after, #canvas form .steps .step:before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-current\",\"selector\":\"#canvas form .steps .step.current .stage, #canvas form .steps .step.current:after, #canvas form .steps .step.current:before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-color\":\"\",\"border-image\":\"\",\"border-image-outset\":\"\",\"border-image-repeat\":\"\",\"border-image-source\":\"\",\"border-image-width\":\"\",\"border-left\":\"\",\"border-left-color\":\"\",\"border-left-style\":\"\",\"border-left-width\":\"\",\"border-radius\":\"\",\"border-right\":\"\",\"border-right-color\":\"\",\"border-right-style\":\"\",\"border-right-width\":\"\",\"border-spacing\":\"\",\"border-style\":\"\",\"border-top\":\"\",\"border-top-color\":\"\",\"border-top-left-radius\":\"\",\"border-top-right-radius\":\"\",\"border-top-style\":\"\",\"border-top-width\":\"\",\"border-width\":\"\",\"bottom\":\"\",\"box-shadow\":\"\",\"box-sizing\":\"\",\"caption-side\":\"\",\"clear\":\"\",\"clip\":\"\",\"color\":\"\",\"column-count\":\"\",\"column-fill\":\"\",\"column-gap\":\"\",\"column-rule\":\"\",\"column-rule-color\":\"\",\"column-rule-style\":\"\",\"column-rule-width\":\"\",\"column-span\":\"\",\"column-width\":\"\",\"columns\":\"\",\"content\":\"\",\"counter-increment\":\"\",\"counter-reset\":\"\",\"cursor\":\"\",\"direction\":\"\",\"display\":\"\",\"empty-cells\":\"\",\"float\":\"\",\"font\":\"\",\"font-family\":\"\",\"font-size\":\"\",\"font-size-adjust\":\"\",\"font-stretch\":\"\",\"font-style\":\"\",\"font-variant\":\"\",\"font-weight\":\"\",\"height\":\"\",\"hyphens\":\"\",\"image-rendering\":\"\",\"left\":\"\",\"letter-spacing\":\"\",\"line-height\":\"\",\"list-style\":\"\",\"list-style-image\":\"\",\"list-style-position\":\"\",\"list-style-type\":\"\",\"margin\":\"\",\"margin-bottom\":\"\",\"margin-left\":\"\",\"margin-right\":\"\",\"margin-top\":\"\",\"marker-offset\":\"\",\"marks\":\"\",\"max-height\":\"\",\"max-width\":\"\",\"min-height\":\"\",\"min-width\":\"\",\"opacity\":\"\",\"orphans\":\"\",\"outline\":\"\",\"outline-color\":\"\",\"outline-offset\":\"\",\"outline-style\":\"\",\"outline-width\":\"\",\"overflow\":\"\",\"overflow-x\":\"\",\"padding\":\"\",\"padding-bottom\":\"\",\"padding-left\":\"\",\"padding-right\":\"\",\"padding-top\":\"\",\"page-break-after\":\"\",\"page-break-before\":\"\",\"page-break-inside\":\"\",\"perspective\":\"\",\"perspective-origin\":\"\",\"position\":\"\",\"quotes\":\"\",\"resize\":\"\",\"right\":\"\",\"tab-size\":\"\",\"table-layout\":\"\",\"text-align\":\"\",\"text-align-last\":\"\",\"text-decoration\":\"\",\"text-decoration-color\":\"\",\"text-decoration-line\":\"\",\"text-decoration-style\":\"\",\"text-indent\":\"\",\"text-shadow\":\"\",\"text-transform\":\"\",\"top\":\"\",\"transform\":\"\",\"transform-origin\":\"\",\"transform-style\":\"\",\"transition\":\"\",\"transition-delay\":\"\",\"transition-duration\":\"\",\"transition-property\":\"\",\"transition-timing-function\":\"\",\"vertical-align\":\"\",\"visibility\":\"\",\"white-space\":\"\",\"widows\":\"\",\"width\":\"\",\"word-spacing\":\"\",\"word-wrap\":\"\",\"z-index\":\"\"}},{\"name\":\"step-success\",\"selector\":\"#canvas form .steps .step.success .stage, #canvas form .steps .step.success:after, #canvas form .steps .step.success:before\",\"properties\":{\"animation\":\"\",\"animation-delay\":\"\",\"animation-direction\":\"\",\"animation-duration\":\"\",\"animation-iteration-count\":\"\",\"animation-name\":\"\",\"animation-play-state\":\"\",\"animation-timing-function\":\"\",\"azimuth\":\"\",\"backface-visibility\":\"\",\"background\":\"\",\"background-attachment\":\"\",\"background-clip\":\"\",\"background-color\":\"\",\"background-image\":\"\",\"background-origin\":\"\",\"background-position\":\"\",\"background-repeat\":\"\",\"background-size\":\"\",\"bleed\":\"\",\"border\":\"\",\"border-bottom\":\"\",\"border-bottom-color\":\"\",\"border-bottom-left-radius\":\"\",\"border-bottom-right-radius\":\"\",\"border-bottom-style\":\"\",\"border-bottom-width\":\"\",\"border-collapse\":\"\",\"border-co