<?php
    $this->db->set('Dashboard_Version', '2.2.0');
    $this->db->where('id', 1);
    $this->db->update('config');

    $this->load->dbforge();
    
    //v2.0.5
    if (!$this->db->field_exists('unity_interstitial_id', 'config')):
        $fields = array(
            'unity_interstitial_id' => array('type' => 'TEXT', 'after' => 'unity_banner_id')
        );
        $this->dbforge->add_column('config', $fields);
    endif;
    
    if (!$this->db->field_exists('user_agent', 'live_tv_channels')):
        $fields = array(
            'user_agent' => array('type' => 'TEXT', 'after' => 'featured')
        );
        $this->dbforge->add_column('live_tv_channels', $fields);
    endif;
    
    if (!$this->db->field_exists('headers', 'live_tv_channels')):
        $fields = array(
            'headers' => array('type' => 'LONGTEXT', 'after' => 'user_agent')
        );
        $this->dbforge->add_column('live_tv_channels', $fields);
    endif;
    
    //v2.1.0
    if (!$this->db->field_exists('applovin_sdk_key', 'config')):
        $fields = array(
            'applovin_sdk_key' => array('type' => 'TEXT', 'after' => 'custom_interstitial_click_url')
        );
        $this->dbforge->add_column('config', $fields);
    endif;
    
    if (!$this->db->field_exists('applovin_apiKey', 'config')):
        $fields = array(
            'applovin_apiKey' => array('type' => 'TEXT', 'after' => 'applovin_sdk_key')
        );
        $this->dbforge->add_column('config', $fields);
    endif;

    if (!$this->db->field_exists('applovin_Banner_ID', 'config')):
        $fields = array(
            'applovin_Banner_ID' => array('type' => 'TEXT', 'after' => 'applovin_apiKey')
        );
        $this->dbforge->add_column('config', $fields);
    endif;

    if (!$this->db->field_exists('applovin_Interstitial_ID', 'config')):
        $fields = array(
            'applovin_Interstitial_ID' => array('type' => 'TEXT', 'after' => 'applovin_Banner_ID')
        );
        $this->dbforge->add_column('config', $fields);
    endif;

    if (!$this->db->field_exists('ironSource_app_key', 'config')):
        $fields = array(
            'ironSource_app_key' => array('type' => 'TEXT', 'after' => 'applovin_Interstitial_ID')
        );
        $this->dbforge->add_column('config', $fields);
    endif;
    
    if (!$this->db->field_exists('webSeriesEpisodeitemType', 'config')):
        $fields = array(
            'webSeriesEpisodeitemType' => array('type' => 'INT', 'default'=>'0', 'COMMENT'=>'0=Default, 1=v2', 'after' => 'live_tv_content_item_type')
        );
        $this->dbforge->add_column('config', $fields);
    endif;

    if (!$this->db->field_exists('paypal_status', 'config')):
        $fields = array(
            'paypal_status' => array('type' => 'INT', '0=Disabled, 1=Enabled', 'after' => 'razorpay_key_secret')
        );
        $this->dbforge->add_column('config', $fields);
    endif;

    if (!$this->db->field_exists('paypal_clint_id', 'config')):
        $fields = array(
            'paypal_clint_id' => array('type' => 'TEXT', 'after' => 'paypal_status')
        );
        $this->dbforge->add_column('config', $fields);
    endif;
    
    if (!$this->db->field_exists('googleplayAppUpdateType', 'config')):
        $fields = array(
            'googleplayAppUpdateType' => array('type' => 'INT', 'default'=>'0', 'COMMENT'=>'0 = FLEXIBLE, 1 = IMMEDIATE', 'after' => 'Update_Type')
        );
        $this->dbforge->add_column('config', $fields);
    endif;
    
    if (!$this->db->field_exists('splash_screen_type', 'config')):
        $fields = array(
            'splash_screen_type' => array('type' => 'INT', 'default'=>'0', 'COMMENT'=>'0=Default, 1=Image, 2=Lottie, 3=Custom', 'after' => 'telegram_chat_id')
        );
        $this->dbforge->add_column('config', $fields);
    endif;
    
    if (!$this->db->field_exists('splash_image_url', 'config')):
        $fields = array(
            'splash_image_url' => array('type' => 'TEXT', 'after' => 'splash_screen_type')
        );
        $this->dbforge->add_column('config', $fields);
    endif;

    if (!$this->db->field_exists('splash_lottie_url', 'config')):
        $fields = array(
            'splash_lottie_url' => array(
                'type' => 'TEXT', 
                'after' => 'splash_image_url'
            ),
        );
        $this->dbforge->add_column('config', $fields);
    endif;

    if (!$this->db->field_exists('splash_bg_color', 'config')):
        $fields = array(
            'splash_bg_color' => array(
                'type' => 'TEXT', 
                'after' => 'splash_screen_type'
            ),
        );
        $this->dbforge->add_column('config', $fields);
    endif;

    if (!$this->db->field_exists('message_animation_url', 'config')):
        $fields = array(
            'message_animation_url' => array(
                'type' => 'TEXT', 
                'after' => 'Show_Message'
            ),
        );
        $this->dbforge->add_column('config', $fields);
    endif;

    if (!$this->db->field_exists('code', 'mail_token_details')):
        $fields = array(
            'code' => array(
                'type' => 'VARCHAR', 
                'constraint' => 4,
                'after' => 'id'
            ),
        );
        $this->dbforge->add_column('mail_token_details', $fields);
    endif;

    if (!$this->db->field_exists('status', 'mail_token_details')):
        $fields = array(
            'status' => array(
                'type' => 'INT', 
                'default'=>'0', 
                'COMMENT'=>'0=Not Used, 1=Used',
                'after' => 'type'
            ),
        );
        $this->dbforge->add_column('mail_token_details', $fields);
    endif;

    //v2.1.5b
    if (!$this->db->field_exists('cron_key', 'config')):
        $fields = array(
            'cron_key' => array(
                'type' => 'TEXT', 
                'after' => 'splash_lottie_url'
            ),
        );
        $this->dbforge->add_column('config', $fields);
    endif;

    if (!$this->db->field_exists('cron_status', 'config')):
        $fields = array(
            'cron_status' => array(
                'type' => 'INT', 
                'default'=>'0', 
                'COMMENT'=>'0=Disabled, 1=Enabled',
                'after' => 'cron_key'
            ),
        );
        $this->dbforge->add_column('config', $fields);
    endif;

    if (!$this->db->field_exists('auto_notification_status', 'config')):
        $fields = array(
            'auto_notification_status' => array(
                'type' => 'INT', 
                'default'=>'0', 
                'COMMENT'=>'0=Disabled, 1=Enabled',
                'after' => 'cron_status'
            ),
        );
        $this->dbforge->add_column('config', $fields);
    endif;

    if (!$this->db->field_exists('auto_notification_schedule', 'config')):
        $fields = array(
            'auto_notification_schedule' => array(
                'type' => 'INT', 
                'default'=>'0',
                'after' => 'auto_notification_status'
            ),
        );
        $this->dbforge->add_column('config', $fields);
    endif;

    if (!$this->db->field_exists('db_backup_status', 'config')):
        $fields = array(
            'db_backup_status' => array(
                'type' => 'INT', 
                'default'=>'0', 
                'COMMENT'=>'0=Disabled, 1=Enabled',
                'after' => 'auto_notification_schedule'
            ),
        );
        $this->dbforge->add_column('config', $fields);
    endif;

    if (!$this->db->field_exists('db_backup_schedule', 'config')):
        $fields = array(
            'db_backup_schedule' => array(
                'type' => 'INT', 
                'default'=>'0',
                'after' => 'db_backup_status'
            ),
        );
        $this->dbforge->add_column('config', $fields);
    endif;

    //v2.2.0
    if (!$this->db->field_exists('safeMode', 'config')):
        $fields = array(
            'safeMode' => array(
                'type' => 'INT', 
                'default'=>'0',
                'after' => 'db_backup_schedule'
            ),
        );
        $this->dbforge->add_column('config', $fields);
    endif;

    if (!$this->db->field_exists('primeryThemeColor', 'config')):
        $fields = array(
            'primeryThemeColor' => array(
                'type' => 'TEXT',  
                'default'=>'#DF4674',
                'after' => 'safeMode'
            ),
        );
        $this->dbforge->add_column('config', $fields);
    endif;

    if (!$this->db->field_exists('blocked_regions', 'config')):
        $fields = array(
            'blocked_regions' => array(
                'type' => 'TEXT',  
                'after' => 'primeryThemeColor'
            ),
        );
        $this->dbforge->add_column('config', $fields);
    endif;
?>