<?php
defined('BASEPATH') OR exit('No direct script access allowed');
?><!doctype html>
<html lang="en">

    <head>
    
        <meta charset="utf-8">
        <title>Dashboard | Dooo - Movie & Web Series Portal App</title>

        <?php include("partials/header.php"); ?>
    
    </head>

    <body data-sidebar="dark">

        <!-- Begin page -->
        <div id="layout-wrapper">

            
            <?php include("partials/topbar.php"); ?>

            
            <?php include("partials/sidebar.php"); ?>
            

            <!-- ============================================================== -->
            <!-- Start right Content here -->
            <!-- ============================================================== -->
            <div class="main-content">

            	<div class="page-content">

            		<div class="container-fluid">

            			<!-- start page title -->

            			<div class="row align-items-center">

            				<div class="col-sm-6">

            					<div class="page-title-box">

            						<h4 class="font-size-18">Android Setting</h4>

            						<ol class="breadcrumb mb-0">

            							<li class="breadcrumb-item"><a href="javascript: void(0);">Dooo</a></li>

            							<li class="breadcrumb-item"><a href="javascript: void(0);">Android Setting</a></li>

            							<li class="breadcrumb-item active">Android Setting</li>

            						</ol>

            					</div>

            				</div>

            			</div>

            			<!-- end page title -->


            			<div class="form">

            				<div class="row">
            					<form method="post">
            						<div class="col-md-12">

            							<div class="card card-body">

            								<h3 class="card-title mt-0">Android Setting</h3>

            								<hr>

            								<div class="form-group row mb-3">
            									<label class="col-sm-3 control-label">App Name</label>
            									<div class="col-sm-6">
            										<input type="text" value="" name="apk_name" id="apk_name" placeholder="Ex: Dooo"
            											class="form-control" required="">
            									</div>
            								</div>

            								<div class="form-group row mb-3">
            									<label class="control-label col-sm-3 ">Login Mandatory?</label>
            									<div class="col-sm-6">
            										<input type="checkbox" id="login_mandatory_bool" name="login_mandatory_bool" switch="bool">
            										<label for="login_mandatory_bool" data-on-label="" data-off-label=""></label>
            									</div>
            								</div>
            								<div class="form-group row mb-3">
            									<label class="control-label col-sm-3 ">Maintenance</label>
            									<div class="col-sm-6">
            										<input type="checkbox" id="maintenance_bool" name="maintenance_bool" switch="bool">
            										<label for="maintenance_bool" data-on-label="" data-off-label=""></label>
            									</div>
            								</div>

            								<div class="form-group row mb-3">
            									<label class="col-sm-3 control-label">All Live TV Type</label>
            									<div class="col-sm-3 ">
            										<select class="form-control form-select" id="All_Live_TV_Type" name="All_Live_TV_Type">
            											<option value="0">Default</option>
            											<option value="1">Free</option>
            											<option value="2">Paid</option>
            										</select>
            									</div>
            								</div>

            								<div class="form-group row mb-3">
            									<label class="col-sm-3 control-label">All Movies Type</label>
            									<div class="col-sm-3 ">
            										<select class="form-control form-select" id="All_Movies_Type" name="All_Movies_Type">
            											<option value="0">Default</option>
            											<option value="1">Free</option>
            											<option value="2">Paid</option>
            										</select>
            									</div>
            								</div>

            								<div class="form-group row mb-3">
            									<label class="col-sm-3 control-label">All Series Type</label>
            									<div class="col-sm-3 ">
            										<select class="form-control form-select" id="All_Series_Type" name="All_Series_Type">
            											<option value="0">Default</option>
            											<option value="1">Free</option>
            											<option value="2">Paid</option>
            										</select>
            									</div>
            								</div>

            								<div class="form-group row mb-3">
            									<label class="control-label col-sm-3 ">LiveTV Visiable in Home</label>
            									<div class="col-sm-6">
            										<input type="checkbox" id="LiveTV_Visiable_in_Home_bool" name="LiveTV_Visiable_in_Home_bool" switch="bool">
            										<label for="LiveTV_Visiable_in_Home_bool" data-on-label=""
            											data-off-label=""></label>
            									</div>
            								</div>

            								<div class="form-group row mb-3">
            									<label class="control-label col-sm-3 ">Genre List Visiable in Home</label>
            									<div class="col-sm-6">
            										<input type="checkbox" id="genreList_Visiable_in_Home_bool" name="genreList_Visiable_in_Home_bool" switch="bool">
            										<label for="genreList_Visiable_in_Home_bool" data-on-label=""
            											data-off-label=""></label>
            									</div>
            								</div>

											<div class="form-group row mb-3">
            									<label class="control-label col-sm-3 ">Safe Mode</label>
            									<div class="col-sm-6">
            										<input type="checkbox" id="safe_mode_bool" name="safe_mode_bool" switch="bool">
            										<label for="safe_mode_bool" data-on-label=""
            											data-off-label=""></label>
            									</div>
            								</div>

											<div class="form-group row mb-3">
												<label class="col-sm-3 control-label">Primery Theme Color</label>
												<div class="col-sm-3 ">
													<input type="text" class="form-control" id="primeryThemeColor" name="primeryThemeColor"
														value="#DF4674">
												</div>
											</div>

											<div class="form-group row mb-3">
												<label class="col-sm-3 control-label">Region Blocker</label>
												<div class="col-sm-3 ">
												<select class="select2 form-control select2-multiple" multiple="" id="blocked_regions" name="blocked_regions[]"
                								multiple="multiple" multiple data-placeholder="Choose ...">
												<?php include("partials/source/country_code_list.php"); ?>
											    </select>
												</div>
											</div>

            								<div class="form-group mb-3 row justify-content-end">

            									<div class="col-md-1">

            										<button class="btn btn-primary dropdown-toggle waves-effect waves-light"
            											id="create_btn" type="submit" name="androidSetting" value="androidSetting"
            											aria-haspopup="true" aria-expanded="false">

            											<i class="mdi mdi-content-save-all"></i> SAVE

            										</button>

            									</div>

            								</div>

            							</div>
            						</div>
            					</form>
            				</div>

            				<div class="row">
            					<form method="post">
            						<div class="col-md-12">

            							<div class="card card-body">

            								<h3 class="card-title mt-0">Login Setting</h3>

            								<hr>

            								<div class="form-group row mb-3">
            									<label class="control-label col-sm-3 ">Google Login</label>
            									<div class="col-sm-6">
            										<input type="checkbox" id="google_login_bool" name="google_login_bool"
            											switch="bool">
            										<label for="google_login_bool" data-on-label="" data-off-label=""></label>
            									</div>
            								</div>

            								<div class="form-group mb-3 row justify-content-end">

            									<div class="col-md-1">

            										<button class="btn btn-primary dropdown-toggle waves-effect waves-light"
            											id="create_btn" type="submit" name="loginSetting" value="loginSetting"
            											aria-haspopup="true" aria-expanded="false">

            											<i class="mdi mdi-content-save-all"></i> SAVE

            										</button>

            									</div>

            								</div>

            							</div>
            						</div>
            					</form>
            				</div>

            				<div class="row">
            					<form method="post">
            						<div class="col-md-12">

            							<div class="card card-body">

            								<h3 class="card-title mt-0">Content Setting</h3>

            								<hr>

            								<div class="form-group row mb-3">
            									<label class="control-label col-sm-3 ">shuffle contents</label>
            									<div class="col-sm-6">
            										<input type="checkbox" id="shuffle_contents_bool" name="shuffle_contents_bool" switch="bool">
            										<label for="shuffle_contents_bool" data-on-label="" data-off-label=""></label>
            									</div>
            								</div>

            								<div class="form-group row mb-3">

            									<label class="control-label col-md-3">Home Rand Max Movie Show</label>
            									<div class="col-sm-6">
            										<input class="form-control" type="number" value="0"
            											id="Home_Rand_Max_Movie_Show" name="Home_Rand_Max_Movie_Show">
            									</div>
            								</div>
            								<div class="form-group row mb-3">

            									<label class="control-label col-md-3">Home Rand Max Series Show</label>
            									<div class="col-sm-6">
            										<input class="form-control" type="number" value="0"
            											id="Home_Rand_Max_Series_Show" name="Home_Rand_Max_Series_Show">
            									</div>

            								</div>
            								<div class="form-group row mb-3">

            									<label class="control-label col-md-3">Home Recent Max Movie Show</label>
            									<div class="col-sm-6">
            										<input class="form-control" type="number" value="0"
            											id="Home_Recent_Max_Movie_Show" name="Home_Recent_Max_Movie_Show">
            									</div>

            								</div>
            								<div class="form-group row mb-3">

            									<label class="control-label col-md-3">Home Recent Max Series Show</label>
            									<div class="col-sm-6">
            										<input class="form-control" type="number" value="0"
            											id="Home_Recent_Max_Series_Show" name="Home_Recent_Max_Series_Show">
            									</div>

            								</div>

            								<div class="form-group mb-3 row justify-content-end">

            									<div class="col-md-1">

            										<button class="btn btn-primary dropdown-toggle waves-effect waves-light"
            											id="create_btn" type="submit" name="contentSetting" value="contentSetting"
            											aria-haspopup="true" aria-expanded="false">

            											<i class="mdi mdi-content-save-all"></i> SAVE

            										</button>

            									</div>

            								</div>

            							</div>
            						</div>
            					</form>
            				</div>

            				<div class="form">
            					<form method="post">
            						<div class="row">

            							<div class="col-md-12">

            								<div class="card card-body">

            									<h3 class="card-title mt-0">Comment Settings</h3>

            									<hr>

            									<div class="panel-body">
            										<div class="form-group row mb-3">
            											<label class="control-label col-sm-3 ">Movies Comment</label>
            											<div class="col-sm-6">
            												<input type="checkbox" id="moviesComment" name="moviesComment"
            													switch="bool">
            												<label for="moviesComment" data-on-label="" data-off-label=""></label>
            											</div>
            										</div>
            										<div class="form-group row mb-3">
            											<label class="control-label col-sm-3 ">WebSeries Comment</label>
            											<div class="col-sm-6">
            												<input type="checkbox" id="webSeriesComment" name="webSeriesComment"
            													switch="bool">
            												<label for="webSeriesComment" data-on-label=""
            													data-off-label=""></label>
            											</div>
            										</div>


            										<div class="form-group mb-3 row justify-content-end">

            											<div class="col-md-1">

            												<button class="btn btn-primary dropdown-toggle waves-effect waves-light"
            													id="create_btn" type="submit" name="commentSettings"
            													value="commentSettings" aria-haspopup="true" aria-expanded="false">

            													<i class="mdi mdi-content-save-all"></i> SAVE

            												</button>

            											</div>

            										</div>
            									</div>

            								</div>
            							</div>
            						</div>
            					</form>
            				</div>

            				<div class="row">
            					<form method="post">
            						<div class="col-md-12">

            							<div class="card card-body">

            								<h3 class="card-title mt-0">Message Setting</h3>

            								<hr>

            								<div class="form-group row mb-3">
            									<label class="control-label col-sm-3 ">Show Message</label>
            									<div class="col-sm-6">
            										<input type="checkbox" id="Show_Message_bool" name="Show_Message_bool" switch="bool">
            										<label for="Show_Message_bool" data-on-label="" data-off-label=""></label>
            									</div>
            								</div>

											<div class="form-group row mb-3">
            									<label class="col-sm-3 control-label">Message Animation  (<a href="https://lottiefiles.com/"
                                                target="_blank">Lottie Animation</a>)</label>
            									<div class="col-sm-6">
            										<input type="text" value="" name="Message_Animation" id="Message_Animation"
            											placeholder="" class="form-control" required="">
            									</div>
            								</div>

            								<div class="form-group row mb-3">
            									<label class="col-sm-3 control-label">Message Title</label>
            									<div class="col-sm-6">
            										<input type="text" value="" name="Message_Title" id="Message_Title"
            											placeholder="Ex: Dooo" class="form-control" required="">
            									</div>
            								</div>

            								<div class="form-group row mb-3">
            									<label class="col-sm-3 control-label">Message</label>
            									<div class="col-sm-6">
            										<textarea rows="3" type="text" value="" name="Message" id="Message"
            											placeholder="Ex: Thank You For Using Our app" class="form-control"
            											required=""></textarea>
            									</div>
            								</div>

            								<div class="form-group mb-3 row justify-content-end">

            									<div class="col-md-1">

            										<button class="btn btn-primary dropdown-toggle waves-effect waves-light"
            											id="create_btn" type="submit" name="messageSetting" value="messageSetting" aria-haspopup="true" aria-expanded="false">

            											<i class="mdi mdi-content-save-all"></i> SAVE

            										</button>

            									</div>

            								</div>

            							</div>
            						</div>
            					</form>
            				</div>

            				<div class="form">

            					<form method="post">

            						<div class="row">

            							<div class="col-md-12">

            								<div class="card card-body">

            									<h3 class="card-title mt-0">Android Update</h3>

            									<hr>

            									<div class="panel-body">
            										<!-- panel  -->
            										<div class="alert alert-success"><strong>Note: </strong>An update popup will
            											be display to old version user based on bellow APK information.</div>

            										<div class="form-group row mb-3">
            											<label class="col-sm-3 control-label">Update Type</label>
            											<div class="col-sm-3 ">
            												<select class="form-control form-select" id="Update_Type" name="Update_Type">
            													<option value="0">In App Update</option>
            													<option value="1">External Browser</option>
																<option value="2">Google Play In App Update</option>
            												</select>
            											</div>
            										</div>

													<div class="form-group row mb-3" id="GooglePlay_Update_Type_form">
            											<label class="col-sm-3 control-label">Googleplay App Update Type</label>
            											<div class="col-sm-3 ">
            												<select class="form-control form-select" id="GooglePlay_Update_Type" name="GooglePlay_Update_Type">
            													<option value="0">Flexible</option>
            													<option value="1">Immediate</option>
            												</select>
            											</div>
            										</div>

            										<div class="form-group row mb-3" id="apk_version_name_form">
            											<label class="col-sm-3 control-label">Latest APK Version Name</label>
            											<div class="col-sm-9">
            												<input type="text" value="" name="apk_version_name"
            													id="apk_version_name" placeholder="Ex: V1.0.0" class="form-control">
            											</div>
            										</div>

            										<div class="form-group row mb-3" id="apk_version_code_form">
            											<label class="col-sm-3 control-label">Latest APK Version Code</label>
            											<div class="col-sm-9">
            												<input type="number" value="" name="apk_version_code"
            													id="apk_version_code" placeholder="Ex: 0" class="form-control">
            											</div>
            										</div>

            										<div class="form-group row mb-3" id="latest_apk_url_form">
            											<label class="control-label col-sm-3 ">APK File URL</label>
            											<div class="col-sm-9">
            												<input type="text" value="" name="latest_apk_url" id="latest_apk_url"
            													placeholder="Ex: PlayStore URL or any other direct download URL"
            													class="form-control">
            											</div>
            										</div>

            										<div class="form-group row mb-3" id="apk_whats_new_form">
            											<label class="col-sm-3 control-label">What's new on latest APK</label>
            											<div class="col-sm-9">
            												<textarea type="text" rows="6" name="apk_whats_new" id="apk_whats_new"
            													class="form-control"></textarea>
            												<p><small>Separate Line By Comma ( , ).</small></p>
            											</div>
            										</div>

            										<div class="form-group row mb-3" id="update_skipable_form">
            											<label class="control-label col-sm-3 ">Update Skipable?</label>
            											<div class="col-sm-6">
            												<input type="checkbox" id="update_skipable" name="update_skipable"
            													switch="bool">
            												<label for="update_skipable" data-on-label="" data-off-label=""></label>
            											</div>
            										</div>


            										<div class="form-group mb-3 row justify-content-end">

            											<div class="col-md-1">

            												<button class="btn btn-primary dropdown-toggle waves-effect waves-light"
            													id="create_btn" type="submit" name="androidUpdate" value="androidUpdate"
            													aria-haspopup="true" aria-expanded="false">

            													<i class="mdi mdi-content-save-all"></i> SAVE

            												</button>

            											</div>

            										</div>
            									</div>

            								</div>
            							</div>
            						</div>
            					</form>
            				</div>

            				<div class="form">

            					<form method="post">

            						<div class="row">

            							<div class="col-md-12">

            								<div class="card card-body">

            									<h3 class="card-title mt-0">OnScreen Effects</h3>

            									<hr>

            									<div class="panel-body">
            										<!-- panel  -->

            										<div class="form-group row mb-3">
            											<label class="col-sm-3 control-label">Effect Type</label>
            											<div class="col-sm-3 ">
            												<select class="form-control form-select" id="Effect_Type" name="Effect_Type">
            													<option value="0">Nothing</option>
            													<option value="1">SnowFall</option>
            												</select>
            											</div>
            										</div>




            										<div class="form-group mb-3 row justify-content-end">

            											<div class="col-md-1">

            												<button class="btn btn-primary dropdown-toggle waves-effect waves-light"
            													id="create_btn"
            													type="submit" name="onScreenEffets" value="onScreenEffets" aria-haspopup="true" aria-expanded="false">

            													<i class="mdi mdi-content-save-all"></i> SAVE

            												</button>

            											</div>

            										</div>
            									</div>

            								</div>
            							</div>
            						</div>

            					</form>
            				</div>

            				<div class="form">
            					<form method="post">
            						<div class="row">

            							<div class="col-md-12">

            								<div class="card card-body">

            									<h3 class="card-title mt-0">Content Item UI</h3>

            									<hr>

            									<div class="panel-body">
            										<!-- panel  -->

            										<div class="form-group row mb-3">
            											<label class="col-sm-3 control-label">Movie/WebSeries Item UI</label>
            											<div class="col-sm-3 ">
            												<select class="form-control form-select" id="MW_Item_Type" name="MW_Item_Type">
            													<option value="0">Default</option>
            													<option value="1">V2</option>
            												</select>
            											</div>
            										</div>

            										<div class="form-group row mb-3">
            											<label class="col-sm-3 control-label">Live TV Item UI</label>
            											<div class="col-sm-3 ">
            												<select class="form-control form-select" id="LT_Item_Type" name="LT_Item_Type">
            													<option value="0">Default</option>
            													<option value="1">V2</option>
            												</select>
            											</div>
            										</div>

													<div class="form-group row mb-3">
            											<label class="col-sm-3 control-label">Episodes UI</label>
            											<div class="col-sm-3 ">
            												<select class="form-control form-select" id="EP_Type" name="EP_Type">
            													<option value="0">Default</option>
            													<option value="1">V2</option>
            												</select>
            											</div>
            										</div>


            										<div class="form-group mb-3 row justify-content-end">

            											<div class="col-md-1">

            												<button class="btn btn-primary dropdown-toggle waves-effect waves-light"
            													id="create_btn" type="submit"
            													name="contentItemUI" value="contentItemUI" aria-haspopup="true" aria-expanded="false">

            													<i class="mdi mdi-content-save-all"></i> SAVE

            												</button>

            											</div>

            										</div>
            									</div>

            								</div>
            							</div>
            						</div>
            					</form>
            				</div>

							<div class="form">
            					<form method="post">
            						<div class="row">

            							<div class="col-md-12">

            								<div class="card card-body">

            									<h3 class="card-title mt-0">Splash Screen UI</h3>

            									<hr>

            									<div class="panel-body">
            										<!-- panel  -->
													<div class="alert alert-success" role="alert">
														<strong>Note: </strong> The Changes will Take Effect Form Second time App Open.
													</div>
													<div class="form-group row mb-3">
            											<label class="col-sm-3 control-label">Splash Screen Background Color</label>
            											<div class="col-sm-3 ">
														    <input type="text" class="form-control" id="splashScreenBgColor" name="splashScreenBgColor" value="#1B242F">
            											</div>
            										</div>

            										<div class="form-group row mb-3">
            											<label class="col-sm-3 control-label">Splash Screen UI Type</label>
            											<div class="col-sm-3 ">
            												<select class="form-control form-select" id="splash_screen_ui_type" name="splash_screen_ui_type">
            													<option value="0">Default</option>
            													<option value="1">Image/Animated Image</option>
																<option value="2">Lottie Animation</option>
																<option value="3">Custom Page</option>
            												</select>
            											</div>
            										</div>

													<div class="form-group row mb-3" id="splash_image_url_form">
            											<label class="control-label col-sm-3 ">Image/Animated Image URL</label>
            											<div class="col-sm-6">
            												<input type="text" value="" name="splash_image_url" id="splash_image_url"
            													class="form-control">
            											</div>
            										</div>

													<div class="form-group row mb-3" id="splash_lottie_animation_url_form">
            											<label class="control-label col-sm-3 ">Lottie Animation URL</label>
            											<div class="col-sm-6">
            												<input type="text" value="" name="splash_lottie_animation_url" id="splash_lottie_animation_url"
            													class="form-control">
            											</div>
            										</div>

													<div class="form-group row mb-3" id="summernote_splash_code_form">
            											<label class="control-label col-sm-3 ">Custom Code</label>
            											<div class="col-sm-9">
														<div class="summernote_splash_code" id="summernote_splash_code"></div>
            											</div>
            										</div>

            										<div class="form-group mb-3 row justify-content-end">

            											<div class="col-md-1">

            												<button class="btn btn-primary dropdown-toggle waves-effect waves-light"
            													id="create_btn" type="submit" onclick="customSplashUiCode()"
            													name="SplashScreenUI" value="SplashScreenUI" aria-haspopup="true" aria-expanded="false">

            													<i class="mdi mdi-content-save-all"></i> SAVE

            												</button>

            											</div>

            										</div>
            									</div>

            								</div>
            							</div>
            						</div>
            					</form>
            				</div>


            			</div> <!-- container-fluid -->


            		</div> <!-- container-fluid -->

            	</div>


            	<?php include("partials/footer_rights.php"); ?>


            </div>
            <!-- end main content-->

        </div>
        <!-- END layout-wrapper -->

        <?php include("partials/footer.php"); ?>
		<?php $splash_custom_code = htmlspecialchars(trim(preg_replace('/\s+/', ' ', file_get_contents(APPPATH.'views/extras/splash.php')))); ?>
    <script>
        $(document).ready(function() {
			$('#blocked_regions').select2();
			$('#blocked_regions').val(<?php echo json_encode(explode(",", "$config->blocked_regions")); ?>).change();

            $('#apk_name').val('<?php echo $config->name; ?>');

			if ('<?php echo $config->login_mandatory; ?>' == 1) {
                document.getElementById("login_mandatory_bool").checked = true;
            } else {
                document.getElementById("login_mandatory_bool").checked = false;
			}

            if ('<?php echo $config->maintenance; ?>' == 1) {
                document.getElementById("maintenance_bool").checked = true;
            } else {
                document.getElementById("maintenance_bool").checked = false;
            }

			$('#All_Live_TV_Type').val('<?php echo $config->all_live_tv_type; ?>');
			$('#All_Movies_Type').val('<?php echo $config->all_movies_type; ?>');
			$('#All_Series_Type').val('<?php echo $config->all_series_type; ?>');

			if ('<?php echo $config->LiveTV_Visiable_in_Home; ?>' == 1) {
                document.getElementById("LiveTV_Visiable_in_Home_bool").checked = true;
            } else {
                document.getElementById("LiveTV_Visiable_in_Home_bool").checked = false;
			}

            if ('<?php echo $config->genre_visible_in_home; ?>' == 1) {
                document.getElementById("genreList_Visiable_in_Home_bool").checked = true;
            } else {
                document.getElementById("genreList_Visiable_in_Home_bool").checked = false;
            }

			if ('<?php echo $config->google_login; ?>' == 1) {
                document.getElementById("google_login_bool").checked = true;
            } else {
                document.getElementById("google_login_bool").checked = false;
            }

			if ('<?php echo $config->shuffle_contents; ?>' == 1) {
                document.getElementById("shuffle_contents_bool").checked = true;
            } else {
                document.getElementById("shuffle_contents_bool").checked = false;
            }
            $('#Home_Rand_Max_Movie_Show').val('<?php echo $config->Home_Rand_Max_Movie_Show; ?>');
            $('#Home_Rand_Max_Series_Show').val('<?php echo $config->Home_Rand_Max_Series_Show; ?>');
            $('#Home_Recent_Max_Movie_Show').val('<?php echo $config->Home_Recent_Max_Movie_Show; ?>');
            $('#Home_Recent_Max_Series_Show').val('<?php echo $config->Home_Recent_Max_Series_Show; ?>');

			if ('<?php echo $config->movie_comments; ?>' == 1) {
                document.getElementById("moviesComment").checked = true;
            } else {
                document.getElementById("moviesComment").checked = false;
            }
            if ('<?php echo $config->webseries_comments; ?>' == 1) {
                document.getElementById("webSeriesComment").checked = true;
            } else {
                document.getElementById("webSeriesComment").checked = false;
            }

			if ('<?php echo $config->Show_Message; ?>' == 1) {
                document.getElementById("Show_Message_bool").checked = true;
            } else {
                document.getElementById("Show_Message_bool").checked = false;
			}
        
			$('#Message_Animation').val('<?php echo $config->message_animation_url; ?>');
            $('#Message_Title').val('<?php echo $config->Message_Title; ?>');
            $('#Message').val('<?php echo $config->Message; ?>');

			$('#apk_version_name').val('<?php echo $config->Latest_APK_Version_Name; ?>');
            $('#apk_version_code').val('<?php echo $config->Latest_APK_Version_Code; ?>');
            $('#latest_apk_url').val('<?php echo $config->APK_File_URL; ?>');
            $('#apk_whats_new').val('<?php echo $config->Whats_new_on_latest_APK; ?>');

			$('#Update_Type').val('<?php echo $config->Update_Type; ?>');
			$('#GooglePlay_Update_Type').val('<?php echo $config->googleplayAppUpdateType; ?>');

			if ('<?php echo $config->Update_Skipable; ?>' == 1) {
                document.getElementById("update_skipable").checked = true;
            } else {
                document.getElementById("update_skipable").checked = false;
            }

			$('#Effect_Type').val('<?php echo $config->onscreen_effect; ?>');

			$('#MW_Item_Type').val('<?php echo $config->content_item_type; ?>');
			$('#LT_Item_Type').val('<?php echo $config->live_tv_content_item_type; ?>');
			$('#EP_Type').val('<?php echo $config->webSeriesEpisodeitemType; ?>');

			if(document.getElementById("Update_Type").value == 0 || document.getElementById("Update_Type").value == 1) {
				$("#GooglePlay_Update_Type_form").hide();

				$("#apk_version_name_form").show();
				$("#apk_version_code_form").show();
				$("#latest_apk_url_form").show();
				$("#apk_whats_new_form").show();
				$("#update_skipable_form").show();
			  } else if(document.getElementById("Update_Type").value == 2) {
				$("#GooglePlay_Update_Type_form").show();

				$("#apk_version_name_form").hide();
				$("#apk_version_code_form").hide();
				$("#latest_apk_url_form").hide();
				$("#apk_whats_new_form").hide();
				$("#update_skipable_form").hide();
			  }
			document.getElementById("Update_Type").addEventListener('change', function() {
              if(this.value == 0 || this.value == 1) {
				$("#GooglePlay_Update_Type_form").hide();

				$("#apk_version_name_form").show();
				$("#apk_version_code_form").show();
				$("#latest_apk_url_form").show();
				$("#apk_whats_new_form").show();
				$("#update_skipable_form").show();
			  } else if(this.value == 2) {
				$("#GooglePlay_Update_Type_form").show();

				$("#apk_version_name_form").hide();
				$("#apk_version_code_form").hide();
				$("#latest_apk_url_form").hide();
				$("#apk_whats_new_form").hide();
				$("#update_skipable_form").hide();
			  }
            }, false);
			

			$("#splashScreenBgColor").spectrum({
				allowEmpty:false,
				showInput:true,
                showAlpha:false,
				color: "<?php echo $config->splash_bg_color; ?>",
				
				change: function(color) { color.toHexString(); }
            });

			//$('#splashScreenBgColor').val();
			$('#splash_screen_ui_type').val('<?php echo $config->splash_screen_type; ?>');
			$('#splash_image_url').val('<?php echo $config->splash_image_url; ?>');
			$('#splash_lottie_animation_url').val('<?php echo $config->splash_lottie_url; ?>');

			if('<?php echo $config->splash_screen_type; ?>' == 0) {
				$("#splash_image_url_form").hide();
				$("#splash_lottie_animation_url_form").hide();
				$("#summernote_splash_code_form").hide();
			} else if('<?php echo $config->splash_screen_type; ?>' == 1) {
				$("#splash_image_url_form").show();
				$("#splash_lottie_animation_url_form").hide();
				$("#summernote_splash_code_form").hide();
			} else if('<?php echo $config->splash_screen_type; ?>' == 2) {
				$("#splash_image_url_form").hide();
				$("#splash_lottie_animation_url_form").show();
				$("#summernote_splash_code_form").hide();
			} else if('<?php echo $config->splash_screen_type; ?>' == 3) {
				$(document).ready(function() {
                    $('.summernote_splash_code').summernote({
                        height: 250
                    });
					$('#summernote_splash_code').html(escape($('#summernote_splash_code').summernote('code', '<?php echo $splash_custom_code; ?>')));
                });
				$("#splash_image_url_form").hide();
				$("#splash_lottie_animation_url_form").hide();
				$("#summernote_splash_code_form").show();
			}
			document.getElementById("splash_screen_ui_type").addEventListener('change', function() {
				if(this.value == 0) {
					$("#splash_image_url_form").hide();
					$("#splash_lottie_animation_url_form").hide();
				    $("#summernote_splash_code_form").hide();
				}else if(this.value == 1) {
					$("#splash_image_url_form").show();
					$("#splash_lottie_animation_url_form").hide();
				    $("#summernote_splash_code_form").hide();
				}else if(this.value == 2) {
					$("#splash_image_url_form").hide();
					$("#splash_lottie_animation_url_form").show();
				    $("#summernote_splash_code_form").hide();
				}else if(this.value == 3) {
					$(document).ready(function() {
                        $('.summernote_splash_code').summernote({
                            height: 250
                        });
			            $('#summernote_splash_code').html(escape($('#summernote_splash_code').summernote('code', '<?php echo $splash_custom_code; ?>')));
                    });
					$("#splash_image_url_form").hide();
					$("#splash_lottie_animation_url_form").hide();
				    $("#summernote_splash_code_form").show();
				}
			}, false);

			
			

			if('<?php if($this->session->flashdata('success') != "") {echo true;} else { echo false;} ?>') {
				swal.fire({
                    title: 'Successful!',
                    text: "<?php echo $this->session->flashdata('success'); ?>",
                    icon: 'success',
                    showCancelButton: false,
                    confirmButtonColor: '#556ee6',
                    cancelButtonColor: "#f46a6a"
                }).then(function () {
                    location.reload();
                });
			}
			if('<?php if($this->session->flashdata('error') != "") {echo true;} else { echo false;} ?>') {
				swal.fire({
                    title: 'Error',
                    text: "<?php echo $this->session->flashdata('error'); ?>",
                    icon: 'error'
                }).then(function () {
                    location.reload();
                });
			}

			if ('<?php echo $config->safeMode; ?>' == 1) {
                document.getElementById("safe_mode_bool").checked = true;
            } else {
                document.getElementById("safe_mode_bool").checked = false;
            }

			$("#primeryThemeColor").spectrum({
				allowEmpty:false,
				showInput:true,
                showAlpha:false,
				color: "<?php echo $config->primeryThemeColor; ?>",
				
				change: function(color) { color.toHexString(); }
            });
			
        });

		function customSplashUiCode() {
			var summernote_splash_code_form = $('#summernote_splash_code').html(escape($('#summernote_splash_code').summernote('code')));//$('#summernote_splash_code_form').summernote('code');
			$.ajax({
              url: '<?= site_url('Admin_api/customSplashUiCode') ?>',
              type: 'POST',
	    	  data : { code : summernote_splash_code_form },
              dataType:'text',
                success: function(result){
	    			if(result) {
	    				
	    			}
                }
            });
		}

    </script>