<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Android_api_model extends CI_Model {
	function __construct()
	{
		parent::__construct();
	}

	function AppConfig() {
        $this->db->where('id', 1);
        $q = $this->db->get('config');
        $g = $q->result_array();
        $data = array_shift($g);
        return $data;
    }

	function login($email, $password) {
        $this->db->where('email', $email);  
        $this->db->where('password', $password);  
        $query = $this->db->get('user_db');  
  
        if ($query->num_rows() == 1) {  
            $g = $query->result_array();
            $data = array_shift($g);
            return $data;
        } else {
            return false;  
        }  
	}

	function signup($name, $email, $password) {
		$this->db->where('email', $email);
        $query = $this->db->get('user_db');  
 
        if (!$query->num_rows() > 0)  
        { 
        	$data = array(
                'name' => $name,
                'email' => $email,
                'password' => $password,
				'active_subscription' => 'Free',
                'subscription_start' => '0000-00-00',
                'subscription_exp' => '0000-00-00'
            );

            if ($this->db->insert('user_db', $data))  
            {  
                return true;  
            } else {  
                return false;  
            } 
        } else {
        	return false;
        }
	}

	function getCustomImageSlider() {
		$this->db->order_by('id', 'DESC');
		$query = $this->db->get('image_slider');
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				$json[] = $row;
			}
			return $json;
	    }
        
	}

	function getMovieImageSlider() {
		$this->db->limit($this->AppConfig()['movie_image_slider_max_visible']);
		$this->db->order_by('id', 'DESC');
		$query = $this->db->get('movies');
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				$json[] = $row;
			}
			return $json;
	    }
	}

	function getWebSeriesImageSlider() {
		$this->db->limit($this->AppConfig()['webseries_image_slider_max_visible']);
		$this->db->order_by('id', 'DESC');
		$query = $this->db->get('web_series');
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				$json[] = $row;
			}
			return $json;
	    }
	}

	function getFeaturedLiveTV() {
		$this->db->where('featured', '1');
		$this->db->order_by('id', 'DESC');
		$query = $this->db->get('live_tv_channels');
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				$json[] = $row;
			}
			return $json;
	    }
	}

	function getAllLiveTV() {
		$query = $this->db->get('live_tv_channels');
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				$json[] = $row;
			}
			return $json;
	    }
	}

	function searchLiveTV($search_term, $includePremium) {
		$this->db->order_by('id', 'DESC');
		if($includePremium == 0) {
			$this->db->where('type', '0');
		} else if($includePremium == 1) {
			//$this->db->where('type', '1');
		}
		$query = $this->db->get('live_tv_channels');
		$json =array(); 
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				if (stripos(preg_replace('/[^a-zA-Z0-9_ -]/s','',$row->name), preg_replace('/[^a-zA-Z0-9_ -]/s','',$search_term)) !== false) {
					$json[] = $row;
				}
			}
			if(json_encode($json) != "[]") {
				return $json;
			}
	    }
	}

	function getRandMovies() {
		$this->db->limit($this->AppConfig()['Home_Rand_Max_Movie_Show']);
		$this->db->order_by('id', 'RANDOM');
		$query = $this->db->get('movies');
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				$json[] = $row;
			}
			return $json;
	    }
	}

	function getRandWebSeries() {
		$this->db->limit($this->AppConfig()['Home_Rand_Max_Series_Show']);
		$this->db->order_by('id', 'RANDOM');
		$query = $this->db->get('web_series');
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				$json[] = $row;
			}
			return $json;
	    }
	}

	function getMovieDetails($movieID) {
		$this->db->where('id', $movieID);
        $q = $this->db->get('movies');
		if ($q->num_rows() > 0) {
			$g = $q->result_array();
            $data = array_shift($g);
            return $data;
	    }
        
	}

	function getWebSeriesDetails($seriesID) {
		$this->db->where('id', $seriesID);
        $q = $this->db->get('web_series');
		if ($q->num_rows() > 0) {
			$g = $q->result_array();
            $data = array_shift($g);
            return $data;
	    }
	}

	function getLiveTVDetails($ID) {
		$this->db->where('id', $ID);
        $q = $this->db->get('live_tv_channels');
		if ($q->num_rows() > 0) {
			$g = $q->result_array();
            $data = array_shift($g);
            return $data;
	    }
	}

	function getRecentMovieList() {
		$this->db->limit($this->AppConfig()['Home_Recent_Max_Movie_Show']);
		$this->db->order_by('id', 'DESC');
		$query = $this->db->get('movies');
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				$json[] = $row;
			}
			return $json;
	    }
    }

	function getRecentWebSeriesList() {
		$this->db->limit($this->AppConfig()['Home_Recent_Max_Series_Show']);
		$this->db->order_by('id', 'DESC');
		$query = $this->db->get('web_series');
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				$json[] = $row;
			}
			return $json;
	    }
    }

	function getMostWatchedMovies($limit) {
		$query = $this->db->query("SELECT *, count(content_id ) as max FROM view_log WHERE content_type LIKE 1 GROUP BY content_id ORDER BY max DESC LIMIT $limit");
		$json =array();
		foreach ($query->result() as $row) {
			if($this->getMovieDetails($row->content_id) != "") {
				$json[] = $this->getMovieDetails($row->content_id);
			}
		}
		if(json_encode($json) != "[]") {
			return $json;
		}
	}

	function getMostWatchedWebSeries($limit) {
		$query = $this->db->query("SELECT *, count(content_id ) as max FROM view_log WHERE content_type LIKE 2 GROUP BY content_id ORDER BY max DESC LIMIT $limit");
		$json =array();
		foreach ($query->result() as $row) {
			if($this->getWebSeriesDetails($row->content_id) != "") {
				$json[] = $this->getWebSeriesDetails($row->content_id);
			}
		}
		if(json_encode($json) != "[]") {
			return $json;
		}
	}

	function beacauseYouWatchedMovie($userID, $limit) {
		$this->db->where('user_id', $userID);
		$this->db->where('content_type', '1');
		$this->db->limit(1);
		$this->db->order_by('id', 'DESC');
		$query = $this->db->get('watch_log');
		$g = $query->result_array();
        $data = array_shift($g);
        if($data != "") {
            $lastWatchedContentIDWatchedByUser = $data['content_id'];
            if($this->getMovieDetails($lastWatchedContentIDWatchedByUser) != "") {
                $lastWatchedMovieGenres = $this->getMovieDetails($lastWatchedContentIDWatchedByUser)['genres'];
    
		        $single_MovieGenres = explode(',', $lastWatchedMovieGenres);
		        foreach ($single_MovieGenres as $value) {
		            $this->db->limit($limit);
		            $this->db->like('genres', $value);
		            $this->db->order_by('id', 'DESC');
		            $query = $this->db->get('movies');
		            if ($query->num_rows() > 0) {
		            	foreach ($query->result() as $row) {
		            		$json[] = $row;
		            	}
		            	return $json;
	                }
	            }
            }
        }
        
		
	}

	function beacauseYouWatchedWebSeries($userID, $limit) {
		$this->db->where('user_id', $userID);
		$this->db->where('content_type', '2');
		$this->db->limit(1);
		$this->db->order_by('id', 'DESC');
		$query = $this->db->get('watch_log');
		$g = $query->result_array();
        $data = array_shift($g);
        if($data != "") {
            $lastWatchedContentIDWatchedByUser = $data['content_id'];
            if($this->getWebSeriesDetails($lastWatchedContentIDWatchedByUser) != "") {
                $lastWatchedMovieGenres = $this->getWebSeriesDetails($lastWatchedContentIDWatchedByUser)['genres'];
    
		        $single_MovieGenres = explode(',', $lastWatchedMovieGenres);
		        foreach ($single_MovieGenres as $value) {
		            $this->db->limit($limit);
		            $this->db->like('genres', $value);
		            $this->db->order_by('id', 'DESC');
		            $query = $this->db->get('web_series');
		            if ($query->num_rows() > 0) {
		            	foreach ($query->result() as $row) {
		            		$json[] = $row;
		            	}
		            	return $json;
	                }
	            }
            }
        }
        
		
	}

	function getAllMovies($page = 0) {
		if($page > 0) {
			$page_num = filter_var($page, FILTER_VALIDATE_INT,[
                'options' => [
                    'default' => 1,
                    'min_range' => 1
                ]
            ]); 
			$page_limit = 20;
			$page_offset = $page_limit * ($page_num - 1);
			$json =array();

			$this->db->limit($page_limit, $page_offset);
			$this->db->order_by('id', 'DESC');
			$query = $this->db->get('movies');
		    if ($query->num_rows() > 0) {
		    	foreach ($query->result() as $row) {
		    		$json[] = $row;
		    	}
		    	return $json;
	        }

		} else {
			$this->db->order_by('id', 'DESC');
		    $query = $this->db->get('movies');
		    if ($query->num_rows() > 0) {
		    	foreach ($query->result() as $row) {
		    		$json[] = $row;
		    	}
		    	return $json;
	        }
		}
	}

	function getAllWebSeries($page = 0) {
		if($page > 0) {
			$page_num = filter_var($page, FILTER_VALIDATE_INT,[
                'options' => [
                    'default' => 1,
                    'min_range' => 1
                ]
            ]); 
			$page_limit = 20;
			$page_offset = $page_limit * ($page_num - 1);
			$json =array();

			$this->db->limit($page_limit, $page_offset);
			$this->db->order_by('id', 'DESC');
			$query = $this->db->get('web_series');
		    if ($query->num_rows() > 0) {
		    	foreach ($query->result() as $row) {
		    		$json[] = $row;
		    	}
		    	return $json;
	        }

		} else {
			$this->db->order_by('id', 'DESC');
		    $query = $this->db->get('web_series');
		    if ($query->num_rows() > 0) {
		    	foreach ($query->result() as $row) {
		    		$json[] = $row;
		    	}
		    	return $json;
	        }
		}
	}

	function getComments($content_id, $content_type) {
		$json =array();
		$this->db->where('content_id', $content_id);
		$this->db->where('content_type', $content_type);
		$query = $this->db->get('comments');
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				$this->db->where('id', $row->user_id);
		        $query2 = $this->db->get('user_db');
				foreach ($query2->result() as $row2) {
					$json[] = array("userID"=>$row2->id, "userName"=>$row2->name, "comment"=>$row->comment);
				}
			}
			return $json;
		}
	}

	function addComments() {
		$user_id = $_POST["user_id"];
        $content_id = $_POST["content_id"];
        $content_type = $_POST["content_type"];
        $comment = $_POST["comment"];

		$data = array(
			'user_id' => $user_id,
			'content_id' => $content_id,
			'content_type' => $content_type,
			'comment' => $comment
	    );
	    $this->db->insert('comments', $data);
		return $this->db->insert_id();
	}

	function getSeasons($WebSeriesID) {
		$this->db->order_by('season_order', 'ASC');
		$this->db->where('web_series_id', $WebSeriesID);
		$query = $this->db->get('web_series_seasons');
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				$json[] = $row;
			}
			return $json;
		}
	}

	function getSeasonDetails($WebSeriesID, $seasonName) {
		$this->db->where('Session_Name', $seasonName);
		$this->db->where('web_series_id', $WebSeriesID);
		$query = $this->db->get('web_series_seasons');
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				$json = $row;
			}
			return $json;
		}
	}

	function getEpisodes($seasonID) {
		$this->db->order_by('episoade_order', 'ASC');
		$this->db->where('season_id', $seasonID);
		$query = $this->db->get('web_series_episoade');
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				$json[] = $row;
			}
			return $json;
		}
	}

	function getRelatedWebseries($id, $genres, $limit) {
		$genres_single = explode(',', $genres);
		$json =array();

		$this->db->order_by('id', 'DESC');
		$query = $this->db->get('web_series');
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				if($row->id != $id) {
					if(count($json) < $limit) {
						foreach ($genres_single as $value) {
							$genre = trim($value);
					
						   if (stripos($row->genres, $genre) !== false) {
								if(json_encode($json) != "[]") {
									$stat = false;
									foreach ($json as $item) {
										if ($item->id == $row->id) {
											$stat = true;
										}
									}
									if($stat == false) {
										$json[] = $row;
									}
								} else {
								  $json[] = $row; 
								}
									 
							}
						}
					}
				}
			}
			if(json_encode($json) != "[]") {
				return $json;
			}
		}
	}

	function getRelatedMovies($id, $genres, $limit) {
		$genres_single = explode(',', $genres);
		$json =array();

		$this->db->order_by('id', 'DESC');
		$query = $this->db->get('movies');
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				if($row->id != $id) {
					if(count($json) < $limit) {
						foreach ($genres_single as $value) {
							$genre = trim($value);
					
						   if (stripos($row->genres, $genre) !== false) {
								if(json_encode($json) != "[]") {
									$stat = false;
									foreach ($json as $item) {
										if ($item->id == $row->id) {
											$stat = true;
										}
									}
									if($stat == false) {
										$json[] = $row;
									}
								} else {
								  $json[] = $row; 
								}
									 
							}
						}
					}
				}
			}
			if(json_encode($json) != "[]") {
				return $json;
			}
		}
	}

	function setFavourite($USER_ID, $CONTENT_TYPE, $CONTENT_ID) {
		$data = array(
			'user_id' => $USER_ID,
			'content_type' => $CONTENT_TYPE,
			'content_id' => $CONTENT_ID
	    );
	    $this->db->insert('favourite', $data);
		return "New favourite created successfully";
	}

	function getFavourite($USER_ID, $CONTENT_TYPE, $CONTENT_ID) {
		$this->db->where('user_id', $USER_ID);
		$this->db->where('content_type', $CONTENT_TYPE);
		$this->db->where('content_id', $CONTENT_ID);
		$query = $this->db->get('favourite');
		if ($query->num_rows() > 0) {
			return "Record Found";
		}
	}

	function removeFavourite($USER_ID, $CONTENT_TYPE, $CONTENT_ID) {
		$this->db->where('user_id', $USER_ID);
		$this->db->where('content_type', $CONTENT_TYPE);
		$this->db->where('content_id', $CONTENT_ID);
        $this->db->delete('favourite');
		return "Favourite successfully Removed";
	}

	function getFavouriteList($USER_ID) {
		$this->db->order_by('id', 'DESC');
		$this->db->where('user_id', $USER_ID);
		$query = $this->db->get('favourite');
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				$json[] = $row;
			}
			return $json;
	    }
    }

	function createReport($user_id, $title, $description, $report_type) {
		$data = array(
			'user_id' => $user_id,
			'title' => $title,
			'description' => $description,
			'report_type' => $report_type,
			'status' => '0'
	    );
	    $this->db->insert('report', $data);
		return $this->db->insert_id();
	}

	function getMovieDownloadLinks($MovieID) {
		$this->db->order_by('link_order', 'ASC');
		$this->db->where('movie_id', $MovieID);
		$this->db->where('status', '1');
		$query = $this->db->get('movie_download_links');
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				$json[] = $row;
			}
			return $json;
	    }
    }

	function getMoviePlayLinks($MovieID) {
		$this->db->order_by('link_order', 'ASC');
		$this->db->where('movie_id', $MovieID);
		$this->db->where('status', '1');
		$query = $this->db->get('movie_play_links');
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				$json[] = $row;
			}
			return $json;
	    }
    }

	function getGenreList() {
		$this->db->order_by('id', 'DESC');
		$query = $this->db->get('genres');
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				$json[] = $row;
			}
			return $json;
	    }
    }

	function getContentsReletedToGenre($search) {
		$json =array();

		$this->db->order_by('id', 'DESC');
		$query = $this->db->get('movies');
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				if (stripos($row->genres, $search) !== false) {
					$json[] = $row;
				}
			}
	    }

		$this->db->order_by('id', 'DESC');
		$query = $this->db->get('web_series');
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				if (stripos($row->genres, $search) !== false) {
					$json[] = $row;
				}
			}
	    }

		if(json_encode($json) != "[]") {
			return $json;
		}
	}

	function getFeaturedGenre() {
		$this->db->order_by('id', 'DESC');
		$this->db->where('featured', '1');
		$query = $this->db->get('genres');
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				$json[] = $row;
			}
			return $json;
	    }
	}

	function addRequest($user_id, $title, $description, $type, $status) {
		$data = array(
			'user_id' => $user_id,
			'title' => $title,
			'description' => $description,
			'type' => $type,
			'status' => $status
	    );
	    $this->db->insert('request', $data);
		return $this->db->insert_id();
	}

	function searchContent($search_term, $includePremium) {
		$json =array();

		$this->db->order_by('id', 'DESC');
		
		if($includePremium == 0) {
		    $this->db->where('type', '0');
		} else if ($includePremium == 1) {
			//$this->db->where('type', '1');
		}
		$query = $this->db->get('movies');

		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				if (stripos(preg_replace('/[^a-zA-Z0-9_ -]/s','',$row->name), preg_replace('/[^a-zA-Z0-9_ -]/s','',$search_term)) !== false) {
					$json[] = $row;
				}else if (stripos(preg_replace('/[^a-zA-Z0-9_ -]/s','',$row->description), preg_replace('/[^a-zA-Z0-9_ -]/s','',$search_term)) !== false) {
					$json[] = $row;
				}else if (stripos(preg_replace('/[^a-zA-Z0-9_ -]/s','',$row->genres), preg_replace('/[^a-zA-Z0-9_ -]/s','',$search_term)) !== false) {
					$json[] = $row;
				}
			}
	    }

		$this->db->order_by('id', 'DESC');
		if($includePremium == 0) {
		    $this->db->where('type', '0');
		} else if ($includePremium == 1) {
			//$this->db->where('type', '1');
		}
		$query = $this->db->get('web_series');

		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				if (stripos(preg_replace('/[^a-zA-Z0-9_ -]/s','',$row->name), preg_replace('/[^a-zA-Z0-9_ -]/s','',$search_term)) !== false) {
					$json[] = $row;
				}else if (stripos(preg_replace('/[^a-zA-Z0-9_ -]/s','',$row->description), preg_replace('/[^a-zA-Z0-9_ -]/s','',$search_term)) !== false) {
					$json[] = $row;
				}else if (stripos(preg_replace('/[^a-zA-Z0-9_ -]/s','',$row->genres), preg_replace('/[^a-zA-Z0-9_ -]/s','',$search_term)) !== false) {
					$json[] = $row;
				}
			}
	    }

		if(json_encode($json) != "[]") {
			return $json;
		}
	}

	function getSubscriptionLog($userID) {
		$this->db->order_by('id', 'ASC');
		$this->db->where('user_id', $userID);
		$query = $this->db->get('subscription_log');
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				$json[] = $row;
			}
			return $json;
	    }
	}

	function getSubscriptionPlans() {
		$this->db->order_by('id', 'ASC');
		$query = $this->db->get('subscription');
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				$json[] = $row;
			}
			return $json;
	    }
	}

	function getSubscriptionDetails($ID) {
		$this->db->where('id', $ID);
		$query = $this->db->get('subscription');
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				$json = $row;
			}
			return $json;
	    }
	}

	function redeemCoupon($couponCode, $C_User_ID) {
        $Today = date("Y-m-d");
		$this->db->where('coupon_code', $couponCode);
		$query = $this->db->get('coupon');
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				if($row->coupon_code == $couponCode) {
					if($row->status == 1) {
						$diff=date_diff(date_create(date("Y-m-d")),date_create($row->expire_date));
						if($diff->format('%R') == "+") {

							if($row->max_use == 0) {
								$this->db->where('id', $C_User_ID);
								$query = $this->db->get('user_db');
								if ($query->num_rows() > 0) {
									foreach ($query->result() as $userRow) {
										if($userRow->subscription_type == 0) {
											$used = $row->used + 1;
											$id = $row->id;
				
											if($row->used_by == "") {
												$User_ID = $User_ID;
											} else {
											   $User_ID = $row->used_by.','.$User_ID;
											}
				
											$this->db->set('used', $used);
											$this->db->set('used_by', $User_ID);
                                            $this->db->where('id', $id);
                                            $this->db->update('coupon');
				
											$exp_Date = date('Y-m-d', strtotime($Today . " + " . $row->time . " day"));
				
											$this->db->set('active_subscription', $row->name);
											$this->db->set('subscription_type', $row->subscription_type);
											$this->db->set('time', $row->time);
											$this->db->set('amount', $row->amount);
											$this->db->set('subscription_start', $Today);
											$this->db->set('subscription_exp', $exp_Date);
                                            $this->db->where('id', $C_User_ID);
                                            $this->db->update('user_db');
				
											return "Coupan Successfully Redeemed";
										} else {
											return "User Already Have Subscription";
										}
									}
								}
							} else {
								if($row->max_use > $row->used) {
									$this->db->where('id', $C_User_ID);
									$query = $this->db->get('user_db');
									if ($query->num_rows() > 0) {
										foreach ($query->result() as $userRow) {
											if($userRow->subscription_type == 0) {
			
												$used = $row->used + 1;
												$id = $row->id;
				 
												if($row->used_by == "") {
												   $User_ID = $C_User_ID;
												} else {
												   $User_ID = $row->used_by.','.$C_User_ID;
												}
				
												$this->db->set('used', $used);
												$this->db->set('used_by', $User_ID);
                                                $this->db->where('id', $id);
                                                $this->db->update('coupon');
				
												$exp_Date = date('Y-m-d', strtotime($Today . " + " . $row->time . " day"));
				
												$this->db->set('active_subscription', $row->name);
												$this->db->set('subscription_type', $row->subscription_type);
												$this->db->set('time', $row->time);
												$this->db->set('amount', $row->amount);
												$this->db->set('subscription_start', $Today);
												$this->db->set('subscription_exp', $exp_Date);
                                                $this->db->where('id', $C_User_ID);
                                                $this->db->update('user_db');
				
												return "Coupan Successfully Redeemed";
											} else {
												return "User Already Have Subscription";
											}
										}
									}
			
								} else {
									return "Coupan Used";
								}
							}

						} else if($diff->format('%R') == "-") {
							$this->db->set('status', '0');
                            $this->db->where('id', $row->id);
                            $this->db->update('coupon');
							return "Coupan Expired";
						}
					} else {
						return "Coupan Expired";
					}
				} else {
					return "invalid Coupan";
				}
			}
	    } else {
			return "invalid Coupan";
		}
	}

	function registerDevice($device) {
		$date = date('m-d-Y', time());
        $time = date('h:i:s a', time());

		$this->db->where('device', $device);
		$query = $this->db->get('devices');
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $Row) {
			    $device_id = $Row->id;
			}
		} else {
			$data = array(
				'device' => $device
			);
			$this->db->insert('devices', $data);
			$device_id = $this->db->insert_id();
		}

		$data2 = array(
			'device_id' => $device_id,
			'open_date' => $date,
			'open_time' => $time
		);
		$this->db->insert('devices_log', $data2);
		return $this->db->insert_id();
	}

	function updateAccount($UserID, $UserName, $Email, $Password) {
		$this->db->where('id', $UserID);
		$query = $this->db->get('user_db');
		foreach($query->result() as $UData) {
			$UserData = $UData;
		}

		if($Password == $UserData->password) {
			$this->db->set('name', $UserName);
			$this->db->set('email', $Email);
			$this->db->where('id', $UserData->id);
			$this->db->update('user_db');
			return "Account Updated Successfully";
		} else {
			return "Wrong Password";
		}
	}

	function addviewlog($user_id, $content_id, $content_type) {
		$date = date('m-d-Y', time());
        $time = date('h:i:s a', time());
		$data = array(
			'user_id' => $user_id,
			'content_id' => $content_id,
			'content_type' => $content_type,
			'date' => $date,
			'time' => $time
		);
		$this->db->insert('view_log', $data);
		return $this->db->insert_id();
	}

	function addwatchlog($user_id, $content_id, $content_type) {
		$data = array(
			'user_id' => $user_id,
			'content_id' => $content_id,
			'content_type' => $content_type
		);
		$this->db->insert('watch_log', $data);
		return $this->db->insert_id();
	}

	function getsubtitle($content_id, $ct) {
		$this->db->where('content_id', $content_id);
		$this->db->where('content_type', $ct);
		$this->db->where('status', '1');
		$query = $this->db->get('subtitles');
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				$json[] = $row;
			}
			return $json;
	    }
	}

	function getcontentidfromurl($main_content_id, $content_url, $ct) {
		if($ct == 1) {
			$this->db->where('movie_id', $main_content_id);
			$this->db->where('status', '1');
			$this->db->where('url', $content_url);
			$q = $this->db->get('movie_play_links');
			$g = $q->result_array();
			$data = array_shift($g);
			return $data;
		} else if($ct == 2) {
			$this->db->where('content_id', $main_content_id);
			$this->db->where('status', '1');
			$this->db->where('content_type', $ct);
			$q = $this->db->get('web_series_episoade');
			$g = $q->result_array();
			$data = array_shift($g);
			return $data;
		}
	}

	function getEpisodeDownloadLinks($episode_id) {
		$this->db->where('episode_id', $episode_id);
		$this->db->where('status', '1');
		$this->db->order_by('id', 'DESC');
		$query = $this->db->get('episode_download_links');
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				$json[] = $row;
			}
			return $json;
	    }
	}

	function dXBncmFkZQ($User_ID, $name, $subscription_type, $time, $amount) {
		date_default_timezone_set("Asia/Kolkata");
		$Today = date("Y-m-d");
		$exp_Date = date('Y-m-d', strtotime($Today . " + " . $time . " day"));

		$this->db->set('active_subscription', $name);
		$this->db->set('subscription_type', $subscription_type);
		$this->db->set('time', $time);
		$this->db->set('amount', $amount);
		$this->db->set('subscription_start', $Today);
		$this->db->set('subscription_exp', $exp_Date);
        $this->db->where('id', $User_ID);
        $this->db->update('user_db');
		return ($this->db->affected_rows() > 0);
    }
}