const plugin = require('tailwindcss/plugin');
const {
  sharedOverride,
  sharedExtend,
  sharedPlugins,
} = require('./src/common/shared.tailwind');

module.exports = {
  content: ['./index.html', './src/**/*.ts*'],
  darkMode: 'class',
  theme: {
    ...sharedOverride,
    colors: theme => {
      return {
        ...sharedOverride.colors(theme),
        controls: '#323232',
      };
    },
    spacing: {
      ...sharedOverride.spacing,
      1: '1px',
      2: '2px',
      3: '3px',
      4: '4px',
      5: '5px',
      6: '6px',
      8: '8px',
      10: '10px',
      12: '12px',
      14: '14px',
      16: '16px',
      18: '18px',
      20: '20px',
      22: '22px',
      24: '24px',
      26: '26px',
      28: '28px',
      30: '30px',
      32: '32px',
      36: '36px',
      40: '40px',
      42: '42px',
      44: '44px',
      48: '48px',
      50: '50px',
      56: '56px',
      60: '60px',
      64: '64px',
      68: '68px',
      70: '70px',
      76: '76px',
      80: '80px',
      84: '84px',
      86: '86px',
      92: '92px',
      96: '96px',
      110: '110px',
      112: '112px',
      128: '128px',
      144: '144px',
      160: '160px',
      176: '176px',
      192: '192px',
      208: '208px',
      224: '224px',
      240: '240px',
      256: '256px',
      288: '288px',
      320: '320px',
      375: '375px',
      384: '384px',
    },
    fontSize: {
      xs: ['12px', {lineHeight: '16px'}],
      sm: ['14px', {lineHeight: '20px'}],
      base: ['16px', {lineHeight: '24px'}],
      lg: ['18px', {lineHeight: '28px'}],
      xl: ['20px', {lineHeight: '28px'}],
      '2xl': ['24px', {lineHeight: '32px'}],
      '3xl': ['30px', {lineHeight: '36px'}],
      '4xl': ['36px', {lineHeight: '40px'}],
      '5xl': ['48px', {lineHeight: '1'}],
      '6xl': ['60px', {lineHeight: '1'}],
      '7xl': ['72px', {lineHeight: '1'}],
      '8xl': ['96px', {lineHeight: '1'}],
      '9xl': ['128px', {lineHeight: '1'}],
    },
    borderRadius: {
      none: '0px',
      sm: '2px',
      DEFAULT: '4px',
      md: '6px',
      lg: '8px',
      xl: '12px',
      '2xl': '16px',
      '3xl': '24px',
      full: '9999px',
    },
    extend: {
      ...sharedExtend,
      zIndex: {
        ...sharedExtend.zIndex,
        'loading-indicator': 50,
        navbar: 40,
        'tool-overlay': 30,
        'obj-box': 20,
        cropzone: 10,
      },
      gridTemplateColumns: {
        '5-min-content': 'repeat(5, min-content)',
      },
    },
  },
  variants: {
    extend: {},
  },
  plugins: sharedPlugins(plugin),
};
