import React, {Children, cloneElement, isValidElement, ReactNode} from 'react';
import clsx from 'clsx';
import {FocusScope} from '@react-aria/focus';
import {TabProps} from './tab';
import {TabLine} from './tab-line';

export interface TabListProps {
  children: ReactNode;
  center?: boolean;
}
export function TabList({children, center}: TabListProps) {
  const childrenArray = Children.toArray(children);

  return (
    <FocusScope>
      <div
        className="flex relative max-w-full overflow-auto border-b"
        role="tablist"
        aria-orientation="horizontal"
      >
        {childrenArray.map((child, index) => {
          if (isValidElement<TabProps>(child)) {
            return cloneElement<TabProps>(child, {
              index,
              className: clsx(
                child.props.className,
                center && index === 0 && 'ml-auto',
                center && index === childrenArray.length - 1 && 'mr-auto'
              ),
            });
          }
          return null;
        })}
        <TabLine />
      </div>
    </FocusScope>
  );
}
