import {DateRangeValue} from '../date-range-value';
import {message} from '../../../../../../i18n/message';
import {MessageDescriptor} from '../../../../../../i18n/message-descriptor';
import {getLocalTimeZone, now} from '@internationalized/date';

const Now = now(getLocalTimeZone());

export interface DateRangePreset {
  key: number;
  label: MessageDescriptor;
  getRangeValue?: () => DateRangeValue;
  isCustomRange?: boolean;
}

export const DateRangePresets: DateRangePreset[] = [
  {
    key: 0,
    label: message('last 7 days'),
    getRangeValue: () => ({
      preset: 0,
      start: Now.subtract({days: 7}),
      end: Now,
    }),
  },
  {
    key: 1,
    label: message('last 14 days'),
    getRangeValue: () => ({
      preset: 1,
      start: Now.subtract({days: 14}),
      end: Now,
    }),
  },
  {
    key: 2,
    label: message('last 30 days'),
    getRangeValue: () => ({
      preset: 2,
      start: Now.subtract({days: 30}),
      end: Now,
    }),
  },
  {
    key: 3,
    label: message('last 3 months'),
    getRangeValue: () => ({
      preset: 3,
      start: Now.subtract({months: 3}),
      end: Now,
    }),
  },
  {
    key: 4,
    label: message('last 12 months'),
    getRangeValue: () => ({
      preset: 4,
      start: Now.subtract({months: 12}),
      end: Now,
    }),
  },
];
