import {List, ListItem} from '../../../../../list/list';
import {DateRangePresets} from './date-range-presets';
import {KeyboardArrowRightIcon} from '../../../../../../icons/material/KeyboardArrowRight';
import {Trans} from '../../../../../../i18n/trans';
import {DateRangeValue} from '../date-range-value';

interface DatePresetList {
  onPresetSelected: (value: DateRangeValue) => void;
  selectedValue?: DateRangeValue | null;
}
export function DatePresetList({
  onPresetSelected,
  selectedValue,
}: DatePresetList) {
  return (
    <List className="min-w-192 pt-14">
      {DateRangePresets.map(preset => {
        return (
          <ListItem
            borderRadius="rounded-none"
            capitalizeFirst
            key={preset.key}
            isSelected={selectedValue?.preset === preset.key}
            onSelected={() => {
              const newValue = preset.getRangeValue!();
              onPresetSelected(newValue);
            }}
            startIcon={preset.key === 6 && <KeyboardArrowRightIcon />}
          >
            <Trans {...preset.label} />
          </ListItem>
        );
      })}
    </List>
  );
}
