import React from 'react';
import {ComponentMeta, ComponentStory} from '@storybook/react';
import {
  endOfMonth,
  getLocalTimeZone,
  now,
  startOfMonth,
} from '@internationalized/date';
import {DateRangePicker} from './date-range-picker';

export default {
  title: 'Common/Date and Time/Date Range Picker',
  component: DateRangePicker,
} as ComponentMeta<typeof DateRangePicker>;

const Now = now(getLocalTimeZone());

export const EndAndStartSet: ComponentStory<typeof DateRangePicker> = args => {
  return (
    <DateRangePicker
      label="Pick a date"
      defaultValue={{
        start: startOfMonth(Now),
        end: endOfMonth(Now.add({months: 1})),
      }}
      {...args}
    />
  );
};

export const NoEndDate: ComponentStory<typeof DateRangePicker> = args => {
  return (
    <DateRangePicker
      label="Pick a date"
      defaultValue={{start: Now}}
      max={endOfMonth(Now.add({months: 1}))}
      {...args}
    />
  );
};
