import React, {ElementType, HTMLProps, ReactElement, ReactNode} from 'react';
import {InputSize} from './input-size';

export interface BaseFieldProps {
  disabled?: boolean;
  required?: boolean;
  labelSuffix?: ReactNode;
  autoFocus?: boolean;
  autoSelectText?: boolean;
  labelElementType?: ElementType;
  label?: ReactNode;
  labelPosition?: 'top' | 'side';
  labelDisplay?: string;
  size?: InputSize;
  invalid?: boolean;
  errorMessage?: ReactNode;
  description?: ReactNode;
  flexibleHeight?: boolean;
  // usually an icon or icon button, displayed inside the input
  startAdornment?: React.ReactNode;
  endAdornment?: React.ReactNode;
  // usually a text button, displayed side by side with input
  startAppend?: ReactElement;
  endAppend?: ReactElement;
  className?: string;
  inputWrapperClassName?: string;
  inputClassName?: string;
  unstyled?: boolean;
  background?: 'transparent' | 'bg-alt' | 'bg-paper';
}

export interface BaseFieldPropsWithDom<T>
  extends BaseFieldProps,
    Omit<HTMLProps<T>, 'label' | 'size' | 'ref' | 'children'> {}
